/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.SerializationFactoryFinder;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.modify.NodeTransformBNodesToVariables;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateAdd;
import org.apache.jena.sparql.modify.request.UpdateBinaryOp;
import org.apache.jena.sparql.modify.request.UpdateClear;
import org.apache.jena.sparql.modify.request.UpdateCopy;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDataDelete;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.sparql.modify.request.UpdateDeleteWhere;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateDropClear;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateMove;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateException;
import org.apache.jena.util.iterator.ExtendedIterator;

public class UpdateEngineWorker
implements UpdateVisitor {
    protected final DatasetGraph datasetGraph;
    protected final boolean alwaysSilent = true;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineWorker(DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        this.datasetGraph = datasetGraph;
        this.inputBinding = inputBinding;
        this.context = context;
    }

    @Override
    public void visit(UpdateDrop update) {
        this.execDropClear(update, false);
    }

    @Override
    public void visit(UpdateClear update) {
        this.execDropClear(update, true);
    }

    protected void execDropClear(UpdateDropClear update, boolean isClear) {
        if (update.isAll()) {
            this.execDropClear(update, null, true);
            this.execDropClearAllNamed(update, isClear);
        } else if (update.isAllNamed()) {
            this.execDropClearAllNamed(update, isClear);
        } else if (update.isDefault()) {
            this.execDropClear(update, null, true);
        } else if (update.isOneGraph()) {
            this.execDropClear(update, update.getGraph(), isClear);
        } else {
            throw new ARQInternalErrorException("Target is undefined: " + update.getTarget());
        }
    }

    protected void execDropClear(UpdateDropClear update, Node g, boolean isClear) {
        if (isClear) {
            if (g == null || this.datasetGraph.containsGraph(g)) {
                UpdateEngineWorker.graph(this.datasetGraph, g).clear();
            }
        } else {
            this.datasetGraph.removeGraph(g);
        }
    }

    protected void execDropClearAllNamed(UpdateDropClear update, boolean isClear) {
        List list = Iter.toList(this.datasetGraph.listGraphNodes());
        for (Node gn : list) {
            this.execDropClear(update, gn, isClear);
        }
    }

    @Override
    public void visit(UpdateCreate update) {
        Node g = update.getGraph();
        if (g == null) {
            return;
        }
        if (this.datasetGraph.containsGraph(g)) {
            return;
        }
        this.datasetGraph.addGraph(g, GraphFactory.createDefaultGraph());
    }

    @Override
    public void visit(UpdateLoad update) {
        block10: {
            String source = update.getSource();
            Node dest = update.getDest();
            Graph graph = UpdateEngineWorker.graph(this.datasetGraph, dest);
            boolean loadBuffered = update.getSilent() || !this.datasetGraph.supportsTransactionAbort();
            try {
                if (dest == null) {
                    if (loadBuffered) {
                        DatasetGraph dsg2 = DatasetGraphFactory.create();
                        RDFDataMgr.read(dsg2, source);
                        dsg2.find().forEachRemaining(this.datasetGraph::add);
                    } else {
                        RDFDataMgr.read(this.datasetGraph, source);
                    }
                    return;
                }
                TypedInputStream input = RDFDataMgr.open(source);
                String contentType = input.getContentType();
                Lang lang = RDFDataMgr.determineLang(source, contentType, Lang.TTL);
                if (lang == null) {
                    throw new UpdateException("Failed to determine the syntax for '" + source + "'");
                }
                if (!RDFLanguages.isTriples(lang)) {
                    throw new UpdateException("Attempt to load quads into a graph");
                }
                RDFParser parser = RDFParser.source(input.getInputStream()).forceLang(lang).build();
                if (loadBuffered) {
                    Graph g = GraphFactory.createGraphMem();
                    parser.parse(g);
                    GraphUtil.addInto((Graph)graph, (Graph)g);
                } else {
                    parser.parse(graph);
                }
            }
            catch (RuntimeException ex) {
                if (update.getSilent()) break block10;
                if (ex instanceof UpdateException) {
                    throw ex;
                }
                throw new UpdateException("Failed to LOAD '" + source + "'", ex);
            }
        }
    }

    @Override
    public void visit(UpdateAdd update) {
        if (!this.validBinaryGraphOp(update)) {
            return;
        }
        if (update.getSrc().equals(update.getDest())) {
            return;
        }
        UpdateEngineWorker.gsAddTriples(this.datasetGraph, update.getSrc(), update.getDest());
    }

    @Override
    public void visit(UpdateCopy update) {
        if (!this.validBinaryGraphOp(update)) {
            return;
        }
        if (update.getSrc().equals(update.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.datasetGraph, update.getSrc(), update.getDest(), update.getSilent());
    }

    @Override
    public void visit(UpdateMove update) {
        if (!this.validBinaryGraphOp(update)) {
            return;
        }
        if (update.getSrc().equals(update.getDest())) {
            return;
        }
        UpdateEngineWorker.gsCopy(this.datasetGraph, update.getSrc(), update.getDest(), update.getSilent());
        UpdateEngineWorker.gsDrop(this.datasetGraph, update.getSrc(), true);
    }

    private boolean validBinaryGraphOp(UpdateBinaryOp update) {
        if (update.getSrc().isDefault()) {
            return true;
        }
        if (update.getSrc().isOneNamedGraph()) {
            Node gn = update.getSrc().getGraph();
            if (!this.datasetGraph.containsGraph(gn)) {
                if (!update.getSilent()) {
                    UpdateEngineWorker.error("No such graph: " + gn);
                }
                return false;
            }
            return true;
        }
        UpdateEngineWorker.error("Invalid source target for oepration; " + update.getSrc());
        return false;
    }

    protected static void gsCopy(DatasetGraph dsg, Target src, Target dest, boolean isSilent) {
        if (dest.equals(src)) {
            return;
        }
        UpdateEngineWorker.gsClear(dsg, dest, true);
        UpdateEngineWorker.gsAddTriples(dsg, src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void gsAddTriples(DatasetGraph dsg, Target src, Target dest) {
        Graph gSrc = UpdateEngineWorker.graph(dsg, src);
        Graph gDest = UpdateEngineWorker.graph(dsg, dest);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(dsg.getContext());
        try (DefaultDataBag<Triple> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.tripleSerializationFactory());){
            ExtendedIterator triples = gSrc.find(null, null, null);
            db.addAll(triples);
            Iter.close((Iterator)triples);
            GraphOps.addAll(gDest, db.iterator());
        }
    }

    protected static void gsClear(DatasetGraph dsg, Target target, boolean isSilent) {
        Graph g = UpdateEngineWorker.graph(dsg, target);
        g.clear();
    }

    protected static void gsDrop(DatasetGraph dsg, Target target, boolean isSilent) {
        if (target.isDefault()) {
            dsg.getDefaultGraph().clear();
        } else {
            dsg.removeGraph(target.getGraph());
        }
    }

    @Override
    public Sink<Quad> createInsertDataSink() {
        return new Sink<Quad>(){

            public void send(Quad quad) {
                UpdateEngineWorker.addToDatasetGraph(UpdateEngineWorker.this.datasetGraph, quad);
            }

            public void flush() {
                SystemARQ.sync(UpdateEngineWorker.this.datasetGraph);
            }

            public void close() {
            }
        };
    }

    @Override
    public void visit(UpdateDataInsert update) {
        for (Quad quad : update.getQuads()) {
            UpdateEngineWorker.addToDatasetGraph(this.datasetGraph, quad);
        }
    }

    @Override
    public Sink<Quad> createDeleteDataSink() {
        return new Sink<Quad>(){

            public void send(Quad quad) {
                UpdateEngineWorker.deleteFromDatasetGraph(UpdateEngineWorker.this.datasetGraph, quad);
            }

            public void flush() {
                SystemARQ.sync(UpdateEngineWorker.this.datasetGraph);
            }

            public void close() {
            }
        };
    }

    @Override
    public void visit(UpdateDataDelete update) {
        for (Quad quad : update.getQuads()) {
            UpdateEngineWorker.deleteFromDatasetGraph(this.datasetGraph, quad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateDeleteWhere update) {
        List<Quad> quads = update.getQuads();
        Element el = this.elementFromQuads(quads);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.datasetGraph.getContext());
        try (DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());){
            Iterator<Binding> bindings = this.evalBindings(el);
            db.addAll(bindings);
            Iter.close(bindings);
            Iterator it = db.iterator();
            UpdateEngineWorker.execDelete(this.datasetGraph, quads, null, it);
            Iter.close((Iterator)it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UpdateModify update) {
        Node withGraph = update.getWithIRI();
        Element elt = update.getWherePattern();
        DatasetGraph dsg = this.processUsing(update);
        if (dsg == null && withGraph != null) {
            elt = new ElementNamedGraph(withGraph, elt);
        }
        if (dsg == null) {
            dsg = this.datasetGraph;
        }
        Query query = this.elementToQuery(elt);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(this.datasetGraph.getContext());
        try (DefaultDataBag<Binding> db = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());){
            Iterator<Binding> bindings = UpdateEngineWorker.evalBindings(query, dsg, this.inputBinding, this.context);
            db.addAll(bindings);
            Iter.close(bindings);
            Iterator it = db.iterator();
            UpdateEngineWorker.execDelete(this.datasetGraph, update.getDeleteQuads(), withGraph, it);
            Iter.close((Iterator)it);
            Iterator it2 = db.iterator();
            UpdateEngineWorker.execInsert(this.datasetGraph, update.getInsertQuads(), withGraph, it2);
            Iter.close((Iterator)it2);
        }
    }

    protected DatasetGraph processUsing(UpdateModify update) {
        if (update.getUsing().size() == 0 && update.getUsingNamed().size() == 0) {
            return null;
        }
        return DynamicDatasets.dynamicDataset(update.getUsing(), update.getUsingNamed(), this.datasetGraph, false);
    }

    private Graph graphOrDummy(DatasetGraph dsg, Node gn) {
        Graph g = UpdateEngineWorker.graph(this.datasetGraph, gn);
        if (g == null) {
            g = GraphFactory.createGraphMem();
        }
        return g;
    }

    protected static List<Quad> unused_convertBNodesToVariables(List<Quad> quads) {
        NodeTransformBNodesToVariables bnodesToVariables = new NodeTransformBNodesToVariables();
        return NodeTransformLib.transformQuads(bnodesToVariables, quads);
    }

    protected Element elementFromQuads(List<Quad> quads) {
        ElementGroup el = new ElementGroup();
        ElementTriplesBlock x = new ElementTriplesBlock();
        el.addElement(x);
        Node g = Quad.defaultGraphNodeGenerated;
        for (Quad q : quads) {
            if (q.getGraph() != g) {
                g = q.getGraph();
                x = new ElementTriplesBlock();
                if (g == null || g == Quad.defaultGraphNodeGenerated) {
                    el.addElement(x);
                } else {
                    ElementNamedGraph eng = new ElementNamedGraph(g, x);
                    el.addElement(eng);
                }
            }
            x.addTriple(q.asTriple());
        }
        return el;
    }

    private static Pair<List<Quad>, List<Quad>> split(Collection<Quad> quads) {
        ArrayList constQuads = new ArrayList(quads.size());
        ArrayList templateQuads = new ArrayList();
        quads.forEach(q -> {
            if (UpdateEngineWorker.constQuad(q)) {
                constQuads.add(q);
            } else {
                templateQuads.add(q);
            }
        });
        return Pair.create(constQuads, templateQuads);
    }

    private static boolean constQuad(Quad quad) {
        return UpdateEngineWorker.constTerm(quad.getGraph()) && UpdateEngineWorker.constTerm(quad.getSubject()) && UpdateEngineWorker.constTerm(quad.getPredicate()) && UpdateEngineWorker.constTerm(quad.getObject());
    }

    private static boolean constTerm(Node n) {
        return n.isURI() || n.isLiteral();
    }

    protected static void execDelete(DatasetGraph dsg, List<Quad> quads, Node dftGraph, Iterator<Binding> bindings) {
        Pair<List<Quad>, List<Quad>> p = UpdateEngineWorker.split(quads);
        UpdateEngineWorker.execDelete(dsg, (List)p.getLeft(), (List)p.getRight(), dftGraph, bindings);
    }

    protected static void execDelete(DatasetGraph dsg, List<Quad> onceQuads, List<Quad> templateQuads, Node dftGraph, Iterator<Binding> bindings) {
        Iterator<Quad> it;
        if (onceQuads != null && bindings.hasNext()) {
            onceQuads = TemplateLib.remapDefaultGraph(onceQuads, dftGraph);
            onceQuads.forEach(q -> UpdateEngineWorker.deleteFromDatasetGraph(dsg, q));
        }
        if ((it = TemplateLib.template(templateQuads, dftGraph, bindings)) == null) {
            return;
        }
        it.forEachRemaining(q -> UpdateEngineWorker.deleteFromDatasetGraph(dsg, q));
    }

    protected static void execInsert(DatasetGraph dsg, List<Quad> quads, Node dftGraph, Iterator<Binding> bindings) {
        Pair<List<Quad>, List<Quad>> p = UpdateEngineWorker.split(quads);
        UpdateEngineWorker.execInsert(dsg, (List)p.getLeft(), (List)p.getRight(), dftGraph, bindings);
    }

    protected static void execInsert(DatasetGraph dsg, List<Quad> onceQuads, List<Quad> templateQuads, Node dftGraph, Iterator<Binding> bindings) {
        Iterator<Quad> it;
        if (onceQuads != null && bindings.hasNext()) {
            onceQuads = TemplateLib.remapDefaultGraph(onceQuads, dftGraph);
            onceQuads.forEach(q -> UpdateEngineWorker.addToDatasetGraph(dsg, q));
        }
        if ((it = TemplateLib.template(templateQuads, dftGraph, bindings)) == null) {
            return;
        }
        it.forEachRemaining(q -> UpdateEngineWorker.addToDatasetGraph(dsg, q));
    }

    private static void addToDatasetGraph(DatasetGraph datasetGraph, Quad quad) {
        if (quad.isLegalAsData()) {
            datasetGraph.add(quad);
        }
    }

    private static void deleteFromDatasetGraph(DatasetGraph datasetGraph, Quad quad) {
        if (datasetGraph instanceof DatasetGraphReadOnly) {
            System.err.println("READ ONLY");
        }
        datasetGraph.delete(quad);
    }

    protected Query elementToQuery(Element pattern) {
        if (pattern == null) {
            return null;
        }
        Query query = new Query();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        query.setResultVars();
        return query;
    }

    protected Iterator<Binding> evalBindings(Element pattern) {
        Query query = this.elementToQuery(pattern);
        return UpdateEngineWorker.evalBindings(query, this.datasetGraph, this.inputBinding, this.context);
    }

    protected static Iterator<Binding> evalBindings(Query query, DatasetGraph dsg, Binding inputBinding, Context context) {
        Iterator toReturn;
        if (query != null) {
            Plan plan = QueryExecutionFactory.createPlan(query, dsg, inputBinding, context);
            toReturn = plan.iterator();
        } else {
            toReturn = Iter.singleton((Object)(null != inputBinding ? inputBinding : BindingRoot.create()));
        }
        return toReturn;
    }

    protected static Graph graph(DatasetGraph datasetGraph, Node gn) {
        if (gn == null || gn == Quad.defaultGraphNodeGenerated) {
            return datasetGraph.getDefaultGraph();
        }
        return datasetGraph.getGraph(gn);
    }

    protected static Graph graph(DatasetGraph datasetGraph, Target target) {
        if (target.isDefault()) {
            return datasetGraph.getDefaultGraph();
        }
        if (target.isOneNamedGraph()) {
            return UpdateEngineWorker.graph(datasetGraph, target.getGraph());
        }
        UpdateEngineWorker.error("Target does not name one graph: " + target);
        return null;
    }

    protected static void error(String msg) {
        throw new UpdateException(msg);
    }
}

