/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.powermock.core.MockGateway;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.AbstractJavaAssistMockTransformer;
import org.powermock.core.transformers.javassist.support.TransformerHelper;

abstract class MethodMockTransformer
extends AbstractJavaAssistMockTransformer {
    private Class<?> mockGetawayClass = MockGateway.class;

    MethodMockTransformer(TransformStrategy strategy) {
        super(strategy);
    }

    void modifyMethod(CtMethod method) throws NotFoundException, CannotCompileException {
        if (!TransformerHelper.shouldSkipMethod(method)) {
            CtClass returnTypeAsCtClass = method.getReturnType();
            String returnTypeAsString = TransformerHelper.getReturnTypeAsString(method);
            if (Modifier.isNative((int)method.getModifiers())) {
                this.modifyNativeMethod(method, returnTypeAsCtClass, returnTypeAsString);
            } else {
                this.modifyMethod(method, returnTypeAsCtClass, returnTypeAsString);
            }
        }
    }

    private void modifyNativeMethod(CtMethod method, CtClass returnTypeAsCtClass, String returnTypeAsString) throws CannotCompileException {
        String methodName = method.getName();
        String returnValue = "($r)value";
        if (returnTypeAsCtClass.equals(CtClass.voidType)) {
            returnValue = "";
        }
        String classOrInstance = this.classOrInstance(method);
        method.setModifiers(method.getModifiers() - 256);
        String code = "Object value = " + this.mockGetawayClass.getName() + ".methodCall(" + classOrInstance + ", \"" + method.getName() + "\", $args, $sig, \"" + returnTypeAsString + "\");if (value != " + MockGateway.class.getName() + ".PROCEED) return " + returnValue + "; throw new java.lang.UnsupportedOperationException(\"" + methodName + " is native\");";
        method.setBody("{" + code + "}");
    }

    private String classOrInstance(CtMethod method) {
        String classOrInstance = "this";
        if (Modifier.isStatic((int)method.getModifiers())) {
            classOrInstance = "$class";
        }
        return classOrInstance;
    }

    private void modifyMethod(CtMethod method, CtClass returnTypeAsCtClass, String returnTypeAsString) throws CannotCompileException {
        String returnValue = TransformerHelper.getCorrectReturnValueType(returnTypeAsCtClass);
        String classOrInstance = this.classOrInstance(method);
        String code = "Object value = " + this.mockGetawayClass.getName() + ".methodCall(" + classOrInstance + ", \"" + method.getName() + "\", $args, $sig, \"" + returnTypeAsString + "\");if (value != " + MockGateway.class.getName() + ".PROCEED) return " + returnValue + "; ";
        method.insertBefore("{ " + code + "}");
    }
}

