/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ButterflyClassLoaderWatcher
extends TimerTask {
    private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.classloader.watcher");
    private Set<File> files;
    private Map<File, Long> lastModifieds;
    private Runnable trigger;

    ButterflyClassLoaderWatcher(Runnable t) {
        this.trigger = t;
        this.files = new LinkedHashSet<File>();
        this.lastModifieds = new HashMap<File, Long>();
    }

    protected void addFile(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.addFile(files[i]);
            }
        } else if (f.getName().endsWith(".jar") || f.getName().endsWith(".class")) {
            this.watch(f);
        } else {
            _logger.debug("Not watching '{}' since it's not java bytecode.", (Object)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void watch(File f) {
        _logger.trace("Watching {}", (Object)f);
        ButterflyClassLoaderWatcher butterflyClassLoaderWatcher = this;
        synchronized (butterflyClassLoaderWatcher) {
            this.files.add(f);
            this.lastModifieds.put(f, f.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int counter = 0;
            ButterflyClassLoaderWatcher butterflyClassLoaderWatcher = this;
            synchronized (butterflyClassLoaderWatcher) {
                for (File f : this.files) {
                    if (f.lastModified() <= this.lastModifieds.get(f)) continue;
                    _logger.debug(f + " has changed");
                    this.lastModifieds.put(f, f.lastModified());
                    ++counter;
                }
            }
            if (counter > 0) {
                _logger.debug("Classloading space has changed. Triggering the signal...");
                this.trigger.run();
                _logger.debug("..done");
            }
        }
        catch (Exception e) {
            _logger.error("Error in ButterflyClassLoaderWatcher", (Throwable)e);
        }
    }
}

