/*
 * Decompiled with CFR 0.152.
 */
package com.metaweb.lessen;

import com.metaweb.lessen.BlockParser;
import com.metaweb.lessen.LessFunctionDefinitionParser;
import com.metaweb.lessen.LessParser;
import com.metaweb.lessen.ResourceFinder;
import com.metaweb.lessen.Scope;
import com.metaweb.lessen.expr.Evaluable;
import com.metaweb.lessen.expr.FixedTokenEvaluable;
import com.metaweb.lessen.expr.LessMixinFunction;
import com.metaweb.lessen.expr.OperatorCall;
import com.metaweb.lessen.expr.VariableAccessEvaluable;
import com.metaweb.lessen.tokenizers.BufferedTokenizer;
import com.metaweb.lessen.tokenizers.Tokenizer;
import com.metaweb.lessen.tokens.Token;
import com.metaweb.lessen.tokens.UriToken;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParserBase {
    protected final BufferedTokenizer _tokenizer;
    protected final ResourceFinder _resourceFinder;
    protected final Scope _scope;
    protected final boolean _topLevel;

    protected ParserBase(BufferedTokenizer tokenizer, ResourceFinder resourceFinder, Scope scope, boolean topLevel) {
        this._tokenizer = tokenizer;
        this._resourceFinder = resourceFinder;
        this._scope = scope;
        this._topLevel = topLevel;
    }

    protected LessFunctionDefinitionParser createLessFunctionDefinitionParser() {
        return new LessFunctionDefinitionParser(this._tokenizer, this._resourceFinder, this._scope);
    }

    protected Tokenizer createCssBlockParser(boolean nestChildren) {
        return new BlockParser(this._tokenizer, this._resourceFinder, new Scope(this._scope), null, nestChildren);
    }

    protected abstract void outputToken(Token var1);

    protected void outputEvaluable(Evaluable e) {
        Token t = e.eval(this._scope);
        if (t != null) {
            this.outputToken(t);
        } else {
            this.outputToken(new Token(Token.Type.Invalid, -1, -1, "ERROR"));
        }
    }

    protected abstract void passInnerBlockTokenThrough(Token var1);

    protected void parseBody() {
        Token t;
        while (!((t = this._tokenizer.getToken()) == null || t.type == Token.Type.Delimiter && t.text.equals("}"))) {
            this.parseStatement();
        }
    }

    protected void parseStatement() {
        Token t;
        while ((t = this._tokenizer.getToken()) != null && (t.type == Token.Type.Whitespace || t.type == Token.Type.Comment || t.type == Token.Type.CDataOpen || t.type == Token.Type.CDataClose)) {
            this.outputToken(t);
            this._tokenizer.next();
        }
        if (t != null) {
            Token t2;
            if (t.type == Token.Type.Delimiter && t.text.equals("}")) {
                return;
            }
            int lookahead = 1;
            while ((t2 = this._tokenizer.getToken(lookahead)) != null) {
                if (t2.type == Token.Type.Delimiter) {
                    if (t2.text.equals(";") || t2.text.equals("}")) break;
                    if (t2.text.equals("{")) {
                        this.parseBlockStatement();
                        return;
                    }
                }
                ++lookahead;
            }
            this.parseFlatStatement();
        }
    }

    protected void parseFlatStatement() {
        Token t2;
        int lookahead;
        Token t22;
        Token t = this._tokenizer.getToken();
        if (t.type == Token.Type.AtIdentifier && (t22 = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(1))) != null) {
            String where;
            Tokenizer subTokenizer;
            if (t22.type == Token.Type.Delimiter && t22.text.equals(":")) {
                this._tokenizer.next(lookahead + 1);
                this.parseVariableDeclaration(t);
                return;
            }
            if (this._resourceFinder != null && t22.type == Token.Type.Uri && (t.text.equals("@import") || t.text.equals("@import-less")) && (subTokenizer = this._resourceFinder.open(where = ((UriToken)t22).unquotedText)) != null) {
                subTokenizer = new LessParser(subTokenizer, this._resourceFinder.rebase(where), this._scope);
                if (t.text.equals("@import")) {
                    while (lookahead > 0) {
                        this.outputToken(this._tokenizer.getToken());
                        this._tokenizer.next();
                        --lookahead;
                    }
                    this.outputToken(t22);
                    this._tokenizer.next();
                    t22 = this._tokenizer.getToken(lookahead);
                    if (t22 != null && t22.type == Token.Type.Delimiter && t22.text.equals(";")) {
                        for (lookahead = this.lookOverWhitespaceAndComment(0); lookahead > 0; --lookahead) {
                            this.outputToken(this._tokenizer.getToken());
                            this._tokenizer.next();
                        }
                        this.outputToken(t22);
                        this._tokenizer.next();
                    }
                } else if (t.text.equals("@import-less")) {
                    this._tokenizer.next(lookahead + 1);
                    lookahead = this.lookOverWhitespaceAndComment(0);
                    t22 = this._tokenizer.getToken(lookahead);
                    if (t22 != null && t22.type == Token.Type.Delimiter && t22.text.equals(";")) {
                        this._tokenizer.next(lookahead + 1);
                    }
                }
                while (subTokenizer.getToken() != null) {
                    subTokenizer.next();
                }
                return;
            }
        }
        if (t.type == Token.Type.Operator && t.text.equals(".") && (t2 = this._tokenizer.getToken(1)) != null) {
            int lookahead2;
            Token t3;
            if (t2.type == Token.Type.Function) {
                this._tokenizer.next(2);
                this.parseRestOfMixinFunctionInvocation(t2);
                return;
            }
            if (t2.type == Token.Type.Identifier && (t3 = this._tokenizer.getToken(lookahead2 = this.lookOverWhitespaceAndComment(2))) != null && t3.type == Token.Type.Delimiter) {
                if (t3.text.equals(";")) {
                    this._tokenizer.next(lookahead2 + 1);
                    this.invokeMixinFunction(t2, null);
                    return;
                }
                if (t3.text.equals("}")) {
                    this._tokenizer.next(lookahead2);
                    this.invokeMixinFunction(t2, null);
                    return;
                }
                if (t3.text.equals("(")) {
                    this._tokenizer.next(lookahead2 + 1);
                    this.parseRestOfMixinFunctionInvocation(t2);
                    return;
                }
            }
        }
        while ((t = this._tokenizer.getToken()) != null) {
            Object o;
            if (t.type == Token.Type.Delimiter) {
                if (t.text.equals("}")) break;
                if (t.text.equals(";")) {
                    this._tokenizer.next();
                    this.outputToken(t);
                    break;
                }
            }
            if ((o = this.parseExpression(true)) instanceof Token) {
                this.outputToken(t);
                continue;
            }
            this.outputEvaluable((Evaluable)o);
        }
    }

    protected void parseBlockStatement() {
        Token t2;
        Token t = this._tokenizer.getToken();
        if (t.type == Token.Type.Operator && t.text.equals(".") && (t2 = this._tokenizer.getToken(1)) != null) {
            if (t2.type == Token.Type.Identifier) {
                int lookahead = this.lookOverWhitespaceAndComment(2);
                Token t3 = this._tokenizer.getToken(lookahead);
                if (t3 != null && t3.type == Token.Type.Delimiter && t3.text.equals("(")) {
                    LessFunctionDefinitionParser tokenizer = this.createLessFunctionDefinitionParser();
                    this._scope.put(tokenizer.getIdentifier(), tokenizer.getFunction());
                    return;
                }
            } else if (t2.type == Token.Type.Function) {
                LessFunctionDefinitionParser tokenizer = this.createLessFunctionDefinitionParser();
                this._scope.put(tokenizer.getIdentifier(), tokenizer.getFunction());
                return;
            }
        }
        Tokenizer tokenizer = this.createCssBlockParser(t.type == Token.Type.AtIdentifier);
        while ((t = tokenizer.getToken()) != null) {
            this.passInnerBlockTokenThrough(t);
            tokenizer.next();
        }
    }

    protected int lookOverWhitespaceAndComment(int lookahead) {
        return this._tokenizer.lookOverWhitespaceAndComment(lookahead);
    }

    protected void parseVariableDeclaration(Token atIdentifier) {
        this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
        Object expr = this.parseExpression(true);
        int lookahead = this.lookOverWhitespaceAndComment(0);
        Token t = this._tokenizer.getToken(lookahead);
        if (t != null && t.type == Token.Type.Delimiter && t.text.equals(";")) {
            this._tokenizer.next(lookahead + 1);
        }
        if (expr != null) {
            if (expr instanceof Evaluable) {
                expr = ((Evaluable)expr).eval(this._scope);
            }
            this._scope.put(atIdentifier.text, expr);
        }
    }

    protected Object parseExpression(boolean bareTokenOK) {
        int lookahead;
        Token t2;
        Object term = this.parseTerm(bareTokenOK);
        if (term == null || LessParser.canBeIntermediateValue(term)) {
            return term;
        }
        Evaluable expr = (Evaluable)term;
        while ((t2 = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) != null && t2.type.equals((Object)Token.Type.Operator) && (t2.text.equals("+") || t2.text.equals("-"))) {
            this._tokenizer.next(lookahead + 1);
            this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
            Object term2 = this.parseTerm(false);
            if (term2 == null) break;
            expr = new OperatorCall(t2.text, expr, (Evaluable)term2);
        }
        return expr;
    }

    protected Object parseTerm(boolean bareTokenOK) {
        int lookahead;
        Token t2;
        Object factor = this.parseFactor(bareTokenOK);
        if (factor == null || !(factor instanceof Evaluable)) {
            return factor;
        }
        Evaluable term = (Evaluable)factor;
        while ((t2 = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) != null && t2.type.equals((Object)Token.Type.Operator) && (t2.text.equals("*") || t2.text.equals("/"))) {
            this._tokenizer.next(lookahead + 1);
            this._tokenizer.next(this.lookOverWhitespaceAndComment(0));
            Object factor2 = this.parseFactor(false);
            if (factor2 == null) break;
            term = new OperatorCall(t2.text, term, (Evaluable)factor2);
        }
        return term;
    }

    protected Object parseFactor(boolean bareTokenOK) {
        Token t = this._tokenizer.getToken();
        if (t == null) {
            return null;
        }
        if (t.type == Token.Type.Number || t.type == Token.Type.Percentage || t.type == Token.Type.Dimension || t.type == Token.Type.Color || t.type == Token.Type.HashName || t.type == Token.Type.Identifier) {
            this._tokenizer.next();
            return new FixedTokenEvaluable(t);
        }
        if (t.type == Token.Type.AtIdentifier) {
            this._tokenizer.next();
            return new VariableAccessEvaluable(t, t.text);
        }
        if (t.type == Token.Type.Delimiter && t.text.equals("(")) {
            this._tokenizer.next();
            Object expr = null;
            int lookahead = this.lookOverWhitespaceAndComment(0);
            Token t2 = this._tokenizer.getToken(lookahead);
            if (t2 != null) {
                this._tokenizer.next(lookahead);
                expr = this.parseExpression(false);
            }
            if ((t2 = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) != null && t2.type == Token.Type.Delimiter && t2.text.equals(")")) {
                this._tokenizer.next(lookahead + 1);
            }
            return expr;
        }
        if (bareTokenOK) {
            this._tokenizer.next();
            return t;
        }
        return null;
    }

    protected void parseRestOfMixinFunctionInvocation(Token functionNameToken) {
        int lookahead;
        Token t;
        LinkedList<Token> arguments = new LinkedList<Token>();
        while (!((t = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) == null || t.type == Token.Type.Delimiter && t.text.equals(")"))) {
            this._tokenizer.next(lookahead);
            Object o = this.parseExpression(true);
            if (o == null) break;
            if (o instanceof Token) {
                arguments.add((Token)o);
            } else {
                arguments.add(((Evaluable)o).eval(this._scope));
            }
            if ((t = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) == null || t.type != Token.Type.Delimiter || !t.text.equals(",")) continue;
            this._tokenizer.next(lookahead + 1);
        }
        if ((t = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) != null && t.type == Token.Type.Delimiter && t.text.equals(")")) {
            this._tokenizer.next(lookahead + 1);
        }
        if ((t = this._tokenizer.getToken(lookahead = this.lookOverWhitespaceAndComment(0))) != null && t.type == Token.Type.Delimiter && t.text.equals(";")) {
            this._tokenizer.next(lookahead + 1);
        }
        this.invokeMixinFunction(functionNameToken, arguments);
    }

    protected void invokeMixinFunction(Token functionNameToken, List<Token> arguments) {
        String name = functionNameToken.type == Token.Type.Function ? functionNameToken.text.substring(0, functionNameToken.text.length() - 1) : functionNameToken.text;
        Object o = this._scope.get(name);
        if (o != null && o instanceof LessMixinFunction) {
            List<Token> results = ((LessMixinFunction)o).invoke(arguments, this._scope);
            for (Token t : results) {
                this.outputToken(t);
            }
        }
    }
}

