/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.ArithCoder;
import com.colloquial.arithcode.BitInput;
import java.io.IOException;
import java.io.InputStream;

public final class ArithDecoder
extends ArithCoder {
    private final BitInput _in;
    private long _value;
    private boolean _endOfStream = false;
    private int _bufferedBits;

    public ArithDecoder(BitInput in) throws IOException {
        this._in = in;
        for (int i = 1; i <= 27; ++i) {
            this.bufferBit();
            ++this._bufferedBits;
        }
    }

    public ArithDecoder(InputStream in) throws IOException {
        this(new BitInput(in));
    }

    public boolean endOfStream() {
        return this._endOfStream;
    }

    public int getCurrentSymbolCount(int totalCount) {
        return (int)(((this._value - this._low + 1L) * (long)totalCount - 1L) / (this._high - this._low + 1L));
    }

    public void removeSymbolFromStream(int[] counts) throws IOException {
        this.removeSymbolFromStream(counts[0], counts[1], counts[2]);
    }

    public void removeSymbolFromStream(long lowCount, long highCount, long totalCount) throws IOException {
        long range = this._high - this._low + 1L;
        this._high = this._low + range * highCount / totalCount - 1L;
        this._low += range * lowCount / totalCount;
        while (true) {
            if (this._high >= 0x4000000L) {
                if (this._low >= 0x4000000L) {
                    this._value -= 0x4000000L;
                    this._low -= 0x4000000L;
                    this._high -= 0x4000000L;
                } else if (this._low >= 0x2000000L && this._high <= 0x6000000L) {
                    this._value -= 0x2000000L;
                    this._low -= 0x2000000L;
                    this._high -= 0x2000000L;
                } else {
                    return;
                }
            }
            this._low <<= 1;
            this._high = (this._high << 1) + 1L;
            this.bufferBit();
        }
    }

    public void close() throws IOException {
        this._in.close();
    }

    private void bufferBit() throws IOException {
        if (this._in.endOfStream()) {
            if (this._bufferedBits == 0) {
                this._endOfStream = true;
                return;
            }
            this._value <<= 1;
            --this._bufferedBits;
        } else {
            this._value <<= 1;
            if (this._in.readBit()) {
                ++this._value;
            }
        }
    }
}

