/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.ArithCoder;
import com.colloquial.arithcode.BitOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class ArithEncoder
extends ArithCoder {
    private final BitOutput _out;
    private int _bitsToFollow;

    public ArithEncoder(BitOutput out) {
        this._out = out;
    }

    public ArithEncoder(OutputStream out) {
        this(new BitOutput(out));
    }

    public void close() throws IOException {
        ++this._bitsToFollow;
        if (this._low < 0x2000000L) {
            this.bitPlusFollowFalse();
        } else {
            this.bitPlusFollowTrue();
        }
        this._out.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void encode(int[] counts) throws IOException {
        this.encode(counts[0], counts[1], counts[2]);
    }

    public void encode(int lowCount, int highCount, int totalCount) throws IOException {
        long range = this._high - this._low + 1L;
        this._high = this._low + range * (long)highCount / (long)totalCount - 1L;
        this._low += range * (long)lowCount / (long)totalCount;
        while (true) {
            if (this._high < 0x4000000L) {
                this.bitPlusFollowFalse();
            } else if (this._low >= 0x4000000L) {
                this.bitPlusFollowTrue();
                this._low -= 0x4000000L;
                this._high -= 0x4000000L;
            } else if (this._low >= 0x2000000L && this._high < 0x6000000L) {
                ++this._bitsToFollow;
                this._low -= 0x2000000L;
                this._high -= 0x2000000L;
            } else {
                return;
            }
            this._low <<= 1;
            this._high = (this._high << 1) + 1L;
        }
    }

    private void bitPlusFollowTrue() throws IOException {
        this._out.writeBitTrue();
        while (this._bitsToFollow > 0) {
            this._out.writeBitFalse();
            --this._bitsToFollow;
        }
    }

    private void bitPlusFollowFalse() throws IOException {
        this._out.writeBitFalse();
        while (this._bitsToFollow > 0) {
            this._out.writeBitTrue();
            --this._bitsToFollow;
        }
    }
}

