/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import java.io.IOException;
import java.io.OutputStream;

public final class BitOutput {
    private int _nextByte;
    private int _nextBitIndex;
    private final OutputStream _out;

    public BitOutput(OutputStream out) {
        this._out = out;
        this.reset();
    }

    public void close() throws IOException {
        if (this._nextBitIndex < 7) {
            this._out.write(this._nextByte << this._nextBitIndex);
        }
        this._out.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void writeBit(boolean bit) throws IOException {
        if (bit) {
            this.writeBitTrue();
        } else {
            this.writeBitFalse();
        }
    }

    public void writeBitTrue() throws IOException {
        if (this._nextBitIndex == 0) {
            this._out.write(this._nextByte + 1);
            this.reset();
        } else {
            this._nextByte = this._nextByte + 1 << 1;
            --this._nextBitIndex;
        }
    }

    public void writeBitFalse() throws IOException {
        if (this._nextBitIndex == 0) {
            this._out.write(this._nextByte);
            this.reset();
        } else {
            this._nextByte <<= 1;
            --this._nextBitIndex;
        }
    }

    private void reset() {
        this._nextByte = 0;
        this._nextBitIndex = 7;
    }
}

