/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.Converter;

public final class ByteSet {
    static final ByteSet EMPTY_SET = new ByteSet();
    private long _bits1;
    private long _bits2;
    private long _bits3;
    private long _bits4;

    public void clear() {
        this._bits1 = 0L;
        this._bits2 = 0L;
        this._bits3 = 0L;
        this._bits4 = 0L;
    }

    public void add(int i) {
        this.add(Converter.integerToByte(i));
    }

    public void add(byte b) {
        if (b > 63) {
            this._bits4 |= 1L << -64 + b;
        } else if (b >= 0) {
            this._bits3 |= 1L << b;
        } else if (b > -65) {
            this._bits2 |= 1L << 64 + b;
        } else {
            this._bits1 |= 1L << 128 + b;
        }
    }

    public void remove(int i) {
        this.add(Converter.integerToByte(i));
    }

    public void remove(byte b) {
        if (b > 63) {
            this._bits4 &= 1L << -64 + b ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (b >= 0) {
            this._bits3 &= 1L << b ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (b > -65) {
            this._bits2 &= 1L << 64 + b ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this._bits1 &= 1L << 128 + b ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void add(ByteSet that) {
        this._bits1 |= that._bits1;
        this._bits2 |= that._bits2;
        this._bits3 |= that._bits3;
        this._bits4 |= that._bits4;
    }

    public void remove(ByteSet that) {
        this._bits1 &= that._bits1 ^ 0xFFFFFFFFFFFFFFFFL;
        this._bits2 &= that._bits2 ^ 0xFFFFFFFFFFFFFFFFL;
        this._bits3 &= that._bits3 ^ 0xFFFFFFFFFFFFFFFFL;
        this._bits4 &= that._bits4 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void restrict(ByteSet that) {
        this._bits1 &= that._bits1;
        this._bits2 &= that._bits2;
        this._bits3 &= that._bits3;
        this._bits4 &= that._bits4;
    }

    public boolean contains(int i) {
        return this.contains(Converter.integerToByte(i));
    }

    public boolean contains(byte b) {
        if (b > 63) {
            return 0L != (this._bits4 & 1L << -64 + b);
        }
        if (b >= 0) {
            return 0L != (this._bits3 & 1L << b);
        }
        if (b > -65) {
            return 0L != (this._bits2 & 1L << 64 + b);
        }
        return 0L != (this._bits1 & 1L << 128 + b);
    }

    public int size() {
        int sum = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.contains(i)) continue;
            ++sum;
        }
        return sum;
    }
}

