/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.SyncFailedException;
import java.util.concurrent.atomic.AtomicInteger;

public final class FileDescriptor {
    private int fd;
    private long handle;
    private AtomicInteger useCount;
    public static final FileDescriptor in;
    public static final FileDescriptor out;
    public static final FileDescriptor err;

    public FileDescriptor() {
        this.fd = -1;
        this.handle = -1L;
        this.useCount = new AtomicInteger();
    }

    private FileDescriptor(int n) {
        this.fd = n;
        this.handle = -1L;
        this.useCount = new AtomicInteger();
    }

    public boolean valid() {
        return this.handle != -1L || this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    private static native long set(int var0);

    private static FileDescriptor standardStream(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.handle = FileDescriptor.set(n);
        return fileDescriptor;
    }

    int incrementAndGetUseCount() {
        return this.useCount.incrementAndGet();
    }

    int decrementAndGetUseCount() {
        return this.useCount.decrementAndGet();
    }

    static {
        FileDescriptor.initIDs();
        in = FileDescriptor.standardStream(0);
        out = FileDescriptor.standardStream(1);
        err = FileDescriptor.standardStream(2);
    }
}

