/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        Object object;
        ArrayList<MailcapFile> arrayList = new ArrayList<MailcapFile>(5);
        MailcapFile mailcapFile = null;
        arrayList.add(null);
        LogSupport.log((String)"MailcapCommandMap: load HOME");
        try {
            String string;
            object = System.getProperty("user.home");
            if (object != null && (mailcapFile = this.loadFile(string = (String)object + File.separator + ".mailcap")) != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load SYS");
        try {
            object = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            mailcapFile = this.loadFile((String)object);
            if (mailcapFile != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load JAR");
        this.loadAllResources(arrayList, "META-INF/mailcap");
        LogSupport.log((String)"MailcapCommandMap: load DEF");
        object = MailcapCommandMap.class;
        synchronized (MailcapCommandMap.class) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (defDB != null) {
                arrayList.add(defDB);
            }
            this.DB = new MailcapFile[arrayList.size()];
            this.DB = arrayList.toArray(this.DB);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailcapFile loadResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                MailcapFile mailcapFile = new MailcapFile(inputStream);
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file: " + string));
                }
                MailcapFile mailcapFile2 = mailcapFile;
                return mailcapFile2;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: not loading mailcap file: " + string));
            }
        }
        catch (IOException iOException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)iOException);
            }
        }
        catch (SecurityException securityException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(List list, String string) {
        Object object;
        boolean bl;
        block26: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getResources(classLoader, string) : SecuritySupport.getSystemResources(string)) == null) break block26;
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)"MailcapCommandMap: getResources");
                }
                for (int i = 0; i < ((MailcapFile)object).length; ++i) {
                    MailcapFile mailcapFile = object[i];
                    InputStream inputStream = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MailcapCommandMap: URL " + mailcapFile));
                    }
                    try {
                        inputStream = SecuritySupport.openStream((URL)mailcapFile);
                        if (inputStream != null) {
                            list.add(new MailcapFile(inputStream));
                            bl = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file from URL: " + mailcapFile));
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: not loading mailcap file from URL: " + mailcapFile));
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: can't load " + mailcapFile), (Throwable)iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log((String)("MailcapCommandMap: can't load " + mailcapFile), (Throwable)securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block26;
                LogSupport.log((String)("MailcapCommandMap: can't load " + string), (Throwable)exception);
            }
        }
        if (!bl) {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                list.add(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mailcapFile;
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: load PROG from " + string));
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        LogSupport.log((String)"MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Map map;
        int n;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendPrefCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            if (this.checkForVerb(list, string)) continue;
            List list2 = (List)map.get(string);
            String string2 = (String)list2.get(0);
            list.add(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = ((CommandInfo)iterator.next()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Map map;
        int n;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            for (String string2 : list2) {
                list.add(new CommandInfo(string, string2));
            }
        }
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        String string3;
        List list;
        Map map;
        int n;
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        LogSupport.log((String)"MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        String string2;
        DataContentHandler dataContentHandler;
        List list;
        Map map;
        int n;
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: createDataContentHandler for " + string));
        }
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("  search DB #" + n));
            }
            if ((map = this.DB[n].getMailcapList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("  search fallback DB #" + n));
            }
            if ((map = this.DB[n].getMailcapFallbackList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String string) {
        block12: {
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("      class " + string));
            }
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string);
                }
                if (clazz != null) {
                    return (DataContentHandler)clazz.newInstance();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("Can't load DCH " + string), (Throwable)illegalAccessException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)("Can't load DCH " + string), (Throwable)classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!LogSupport.isLoggable()) break block12;
                LogSupport.log((String)("Can't load DCH " + string), (Throwable)instantiationException);
            }
        }
        return null;
    }

    public synchronized String[] getMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.DB.length; ++i) {
            String[] stringArray;
            if (this.DB[i] == null || (stringArray = this.DB[i].getMimeTypes()) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (arrayList.contains(stringArray[j])) continue;
                arrayList.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] getNativeCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String[] stringArray;
            if (this.DB[i] == null || (stringArray = this.DB[i].getNativeCommands(string)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (arrayList.contains(stringArray[j])) continue;
                arrayList.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }
}

