/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.remote.util.EnvHelp;
import com.sun.jmx.trace.Trace;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final long serialVersionUID = 3636148327800330130L;
    private MBeanServer server = null;
    private List<MLetContent> mletList = new ArrayList<MLetContent>();
    private String libraryDirectory;
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private static final String dbgTag = "MLet";
    private transient ClassLoaderRepository currentClr;
    private transient boolean delegateToCLR;
    private Map<String, Class<?>> primitiveClasses = new HashMap(8);

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] uRLArray) {
        this(uRLArray, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader) {
        this(uRLArray, classLoader, true);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        this(uRLArray, classLoader, uRLStreamHandlerFactory, true);
    }

    public MLet(URL[] uRLArray, boolean bl) {
        super(uRLArray);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, boolean bl) {
        super(uRLArray, classLoader);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    public MLet(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory, boolean bl) {
        super(uRLArray, classLoader, uRLStreamHandlerFactory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), Boolean.class);
        this.primitiveClasses.put(Character.TYPE.toString(), Character.class);
        this.primitiveClasses.put(Byte.TYPE.toString(), Byte.class);
        this.primitiveClasses.put(Short.TYPE.toString(), Short.class);
        this.primitiveClasses.put(Integer.TYPE.toString(), Integer.class);
        this.primitiveClasses.put(Long.TYPE.toString(), Long.class);
        this.primitiveClasses.put(Float.TYPE.toString(), Float.class);
        this.primitiveClasses.put(Double.TYPE.toString(), Double.class);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.delegateToCLR = bl;
        try {
            this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
            if (this.libraryDirectory == null) {
                this.libraryDirectory = this.getTmpDir();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void addURL(URL uRL) {
        if (!Arrays.asList(this.getURLs()).contains(uRL)) {
            super.addURL(uRL);
        }
    }

    @Override
    public void addURL(String string) throws ServiceNotFoundException {
        try {
            URL uRL = new URL(string);
            if (!Arrays.asList(this.getURLs()).contains(uRL)) {
                super.addURL(uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.debug("addURL", string + ": Malformed URL. " + malformedURLException);
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    @Override
    public Set<Object> getMBeansFromURL(URL uRL) throws ServiceNotFoundException {
        if (uRL == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(uRL.toString());
    }

    @Override
    public Set<Object> getMBeansFromURL(String string) throws ServiceNotFoundException {
        Object object;
        String string2 = "getMBeansFromURL";
        if (this.server == null) {
            throw new IllegalStateException("This MLet MBean is not registered with an MBeanServer.");
        }
        if (string == null) {
            if (this.isTraceOn()) {
                this.trace(string2, "URL is null");
            }
            throw new ServiceNotFoundException("The specified URL is null");
        }
        string = string.replace(File.separatorChar, '/');
        if (this.isTraceOn()) {
            this.trace(string2, "<URL = " + string + ">");
        }
        try {
            object = new MLetParser();
            this.mletList = ((MLetParser)object).parseURL(string);
        }
        catch (Exception exception) {
            String string3 = "Problems while parsing URL [" + string + "], got exception [" + exception.toString() + "]";
            if (this.isTraceOn()) {
                this.trace(string2, string3);
            }
            throw EnvHelp.initCause(new ServiceNotFoundException(string3), exception);
        }
        if (this.mletList.size() == 0) {
            object = "File " + string + " not found or MLET tag not defined in file";
            if (this.isTraceOn()) {
                this.trace(string2, (String)object);
            }
            throw new ServiceNotFoundException((String)object);
        }
        object = new HashSet();
        for (MLetContent mLetContent : this.mletList) {
            Object object2;
            String string4 = mLetContent.getCode();
            if (string4 != null && string4.endsWith(".class")) {
                string4 = string4.substring(0, string4.length() - 6);
            }
            String string5 = mLetContent.getName();
            URL uRL = mLetContent.getCodeBase();
            String string6 = mLetContent.getVersion();
            String string7 = mLetContent.getSerializedObject();
            String string8 = mLetContent.getJarFiles();
            URL uRL2 = mLetContent.getDocumentBase();
            if (this.isTraceOn()) {
                this.trace(string2, "MLET TAG     = " + mLetContent.getAttributes());
                this.trace(string2, "CODEBASE     = " + uRL);
                this.trace(string2, "ARCHIVE      = " + string8);
                this.trace(string2, "CODE         = " + string4);
                this.trace(string2, "OBJECT       = " + string7);
                this.trace(string2, "NAME         = " + string5);
                this.trace(string2, "VERSION      = " + string6);
                this.trace(string2, "DOCUMENT URL = " + uRL2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string8, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken().trim();
                if (this.isTraceOn()) {
                    this.trace(string2, "Load archive for codebase <" + uRL + ">, file <" + (String)object2 + ">");
                }
                try {
                    uRL = this.check(string6, uRL, (String)object2, mLetContent);
                }
                catch (Exception exception) {
                    if (this.isDebugOn()) {
                        this.debug(string2, "check returned exception: " + exception);
                    }
                    object.add(exception);
                    continue;
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(uRL.toString() + (String)object2))) continue;
                    this.addURL(uRL + (String)object2);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            object2 = null;
            ObjectInstance objectInstance = null;
            if (string4 != null && string7 != null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "CODE and OBJECT parameters cannot be specified at the same time in tag MLET");
                }
                object.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (string4 == null && string7 == null) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Either CODE or OBJECT parameter must be specified in tag MLET");
                }
                object.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (string4 != null) {
                    List<String> list = mLetContent.getParameterTypes();
                    List<String> list2 = mLetContent.getParameterValues();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (int i = 0; i < list.size(); ++i) {
                        arrayList.add(this.constructParameter(list2.get(i), list.get(i)));
                    }
                    if (list.isEmpty()) {
                        objectInstance = string5 == null ? this.server.createMBean(string4, null, this.mletObjectName) : this.server.createMBean(string4, new ObjectName(string5), this.mletObjectName);
                    } else {
                        Object[] objectArray = arrayList.toArray();
                        String[] stringArray = new String[list.size()];
                        list.toArray(stringArray);
                        if (this.isDebugOn()) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                this.debug(string2, "Signature     = " + stringArray[i]);
                                this.debug(string2, "Params     = " + objectArray[i]);
                            }
                        }
                        objectInstance = string5 == null ? this.server.createMBean(string4, null, this.mletObjectName, objectArray, stringArray) : this.server.createMBean(string4, new ObjectName(string5), this.mletObjectName, objectArray, stringArray);
                    }
                } else {
                    object2 = this.loadSerializedObject(uRL, string7);
                    if (string5 == null) {
                        this.server.registerMBean(object2, null);
                    } else {
                        this.server.registerMBean(object2, new ObjectName(string5));
                    }
                    objectInstance = new ObjectInstance(string5, object2.getClass().getName());
                }
            }
            catch (ReflectionException reflectionException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "ReflectionException: " + reflectionException.getMessage());
                }
                object.add(reflectionException);
                continue;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceAlreadyExistsException: " + instanceAlreadyExistsException.getMessage());
                }
                object.add(instanceAlreadyExistsException);
                continue;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanRegistrationException: " + mBeanRegistrationException.getMessage());
                }
                object.add(mBeanRegistrationException);
                continue;
            }
            catch (MBeanException mBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "MBeanException: " + mBeanException.getMessage());
                }
                object.add(mBeanException);
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "NotCompliantMBeanException: " + notCompliantMBeanException.getMessage());
                }
                object.add(notCompliantMBeanException);
                continue;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "InstanceNotFoundException: " + instanceNotFoundException.getMessage());
                }
                object.add(instanceNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "IOException: " + iOException.getMessage());
                }
                object.add(iOException);
                continue;
            }
            catch (SecurityException securityException) {
                if (this.isTraceOn()) {
                    this.trace(string2, "SecurityException: " + securityException.getMessage());
                }
                object.add(securityException);
                continue;
            }
            catch (Exception exception) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Exception: " + exception.getClass().getName() + exception.getMessage());
                }
                object.add(exception);
                continue;
            }
            catch (Error error) {
                if (this.isTraceOn()) {
                    this.trace(string2, "Error: " + error.getMessage());
                }
                object.add(error);
                continue;
            }
            object.add(objectInstance);
        }
        return object;
    }

    @Override
    public synchronized String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    @Override
    public synchronized void setLibraryDirectory(String string) {
        this.libraryDirectory = string;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.setMBeanServer(mBeanServer);
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "type=MLet");
        }
        this.mletObjectName = objectName;
        return this.mletObjectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class<?> loadClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        ClassLoaderRepository classLoaderRepository2 = this.currentClr;
        try {
            this.currentClr = classLoaderRepository;
            Class<?> clazz = this.loadClass(string);
            return clazz;
        }
        finally {
            this.currentClr = classLoaderRepository2;
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, this.currentClr);
    }

    Class<?> findClass(String string, ClassLoaderRepository classLoaderRepository) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.isTraceOn()) {
            this.trace("findClass", string);
        }
        try {
            clazz = super.findClass(string);
            if (this.isTraceOn()) {
                this.trace("findClass", "Class " + string + " loaded through mlet classloader");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debug("findClass", "Class " + string + " not found locally.");
        }
        if (clazz == null && this.delegateToCLR && classLoaderRepository != null) {
            try {
                this.debug("findClass", "Class " + string + ": looking in CLR");
                clazz = classLoaderRepository.loadClassBefore(this, string);
                if (this.isTraceOn()) {
                    this.trace("findClass", "Class " + string + " loaded through the default classloader repository");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.debug("findClass", "Class " + string + " not found in CLR.");
            }
        }
        if (clazz == null) {
            this.debug("findClass", "Failed to load class " + string);
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    @Override
    protected String findLibrary(String string) {
        String string2;
        String string3 = "findLibrary";
        String string4 = System.mapLibraryName(string);
        if (this.isTraceOn()) {
            this.trace(string3, "Search " + string + " in all JAR files.");
        }
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, string4 + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        string4 = this.removeSpace(System.getProperty("os.name")) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + string4;
        if (this.isTraceOn()) {
            this.trace(string3, "loadLibraryAsResource(" + string4 + ")");
        }
        if ((string2 = this.loadLibraryAsResource(string4)) != null) {
            if (this.isTraceOn()) {
                this.trace(string3, string4 + " loaded " + "absolute path = " + string2);
            }
            return string2;
        }
        if (this.isTraceOn()) {
            this.trace(string3, string + " not found in any JAR file.");
            this.trace(string3, "Search " + string + " along the path specified as the java.library.path property.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTmpDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string != null) {
            return string;
        }
        File file = null;
        try {
            file = File.createTempFile("tmp", "jmx");
            if (file == null) {
                String string2 = null;
                return string2;
            }
            File file2 = file.getParentFile();
            if (file2 == null) {
                String string3 = null;
                return string3;
            }
            String string4 = file2.getAbsolutePath();
            return string4;
        }
        catch (Exception exception) {
            this.debug("getTmpDir", "Failed to determine system temporary dir.");
            String string5 = null;
            return string5;
        }
        finally {
            if (file != null) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    this.debug("getTmpDir", "Failed to delete temporary file: " + exception.getMessage());
                }
            }
        }
    }

    private synchronized String loadLibraryAsResource(String string) {
        try {
            InputStream inputStream = this.getResourceAsStream(string.replace(File.separatorChar, '/'));
            if (inputStream != null) {
                int n;
                File file = new File(this.libraryDirectory);
                file.mkdirs();
                File file2 = File.createTempFile(string + ".", null, file);
                file2.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = inputStream.read()) != -1) {
                    fileOutputStream.write(n);
                }
                inputStream.close();
                fileOutputStream.close();
                if (file2.exists()) {
                    return file2.getAbsolutePath();
                }
            }
        }
        catch (Exception exception) {
            this.debug("loadLibraryAsResource", string + ": Failed to load library. " + exception);
            return null;
        }
        return null;
    }

    private String removeSpace(String string) {
        int n = (string = string.trim()).indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        while (n != -1) {
            n = (string = string.substring(n2)).indexOf(32);
            string2 = n != -1 ? string2 + string.substring(0, n) : string2 + string.substring(0);
            n2 = n + 1;
        }
        return string2;
    }

    protected URL check(String string, URL uRL, String string2, MLetContent mLetContent) throws Exception {
        return uRL;
    }

    private Object loadSerializedObject(URL uRL, String string) throws IOException, ClassNotFoundException {
        InputStream inputStream;
        if (string != null) {
            string = string.replace(File.separatorChar, '/');
        }
        if (this.isTraceOn()) {
            this.trace("loadSerializedObject", uRL.toString() + string);
        }
        if ((inputStream = this.getResourceAsStream(string)) != null) {
            try {
                MLetObjectInputStream mLetObjectInputStream = new MLetObjectInputStream(inputStream, this);
                Object object = mLetObjectInputStream.readObject();
                mLetObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + iOException.getMessage());
                }
                throw iOException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("loadSerializedObject", "Exception while deserializing " + string + ", " + classNotFoundException.getMessage());
                }
                throw classNotFoundException;
            }
        }
        if (this.isDebugOn()) {
            this.debug("loadSerializedObject", "Error: File " + string + " containing serialized object not found");
        }
        throw new Error("File " + string + " containing serialized object not found");
    }

    private Object constructParameter(String string, String string2) {
        block11: {
            Class<?> clazz = this.primitiveClasses.get(string2);
            if (clazz != null) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object[] objectArray = new Object[]{string};
                    return constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    if (!this.isDebugOn()) break block11;
                    this.debug(dbgTag, "constructParameter", "Unexpected Exception" + exception.getClass().getName() + " occurred");
                }
            }
        }
        if (string2.compareTo("java.lang.Boolean") == 0) {
            return new Boolean(string);
        }
        if (string2.compareTo("java.lang.Byte") == 0) {
            return new Byte(string);
        }
        if (string2.compareTo("java.lang.Short") == 0) {
            return new Short(string);
        }
        if (string2.compareTo("java.lang.Long") == 0) {
            return new Long(string);
        }
        if (string2.compareTo("java.lang.Integer") == 0) {
            return new Integer(string);
        }
        if (string2.compareTo("java.lang.Float") == 0) {
            return new Float(string);
        }
        if (string2.compareTo("java.lang.Double") == 0) {
            return new Double(string);
        }
        if (string2.compareTo("java.lang.String") == 0) {
            return string;
        }
        return string;
    }

    private synchronized void setMBeanServer(final MBeanServer mBeanServer) {
        this.server = mBeanServer;
        PrivilegedAction<ClassLoaderRepository> privilegedAction = new PrivilegedAction<ClassLoaderRepository>(){

            @Override
            public ClassLoaderRepository run() {
                return mBeanServer.getClassLoaderRepository();
            }
        };
        this.currentClr = AccessController.doPrivileged(privilegedAction);
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)2, (String)string, (String)string2, (String)string3);
    }

    private void trace(String string, String string2) {
        this.trace(dbgTag, string, string2);
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)2, (String)string, (String)string2, (String)string3);
    }

    private void debug(String string, String string2) {
        this.debug(dbgTag, string, string2);
    }
}

