/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIIIOPServerImpl;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import org.omg.CORBA.BAD_OPERATION;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIConnectorServer
extends JMXConnectorServer {
    public static final String JNDI_REBIND_ATTRIBUTE = "jmx.remote.jndi.rebind";
    public static final String RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.client.socket.factory";
    public static final String RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.server.socket.factory";
    private static final char[] intToAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectorServer");
    private JMXServiceURL address;
    private RMIServerImpl rmiServerImpl;
    private final Map attributes;
    private ClassLoader defaultClassLoader = null;
    private String boundJndiUrl;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private static final Set openedServers = new HashSet();

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        this(jMXServiceURL, map, (MBeanServer)null);
    }

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map, MBeanServer mBeanServer) throws IOException {
        this(jMXServiceURL, map, (RMIServerImpl)null, mBeanServer);
    }

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map, RMIServerImpl rMIServerImpl, MBeanServer mBeanServer) throws IOException {
        super(mBeanServer);
        if (jMXServiceURL == null) {
            throw new IllegalArgumentException("Null JMXServiceURL");
        }
        if (rMIServerImpl == null) {
            String string = jMXServiceURL.getProtocol();
            if (string == null || !string.equals("rmi") && !string.equals("iiop")) {
                String string2 = "Invalid protocol type: " + string;
                throw new MalformedURLException(string2);
            }
            String string3 = jMXServiceURL.getURLPath();
            if (!(string3.equals("") || string3.equals("/") || string3.startsWith("/jndi/"))) {
                throw new MalformedURLException("URL path must be empty or start with /jndi/");
            }
        }
        if (map == null) {
            this.attributes = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(map);
            this.attributes = Collections.unmodifiableMap(map);
        }
        this.address = jMXServiceURL;
        this.rmiServerImpl = rMIServerImpl;
    }

    @Override
    public JMXConnector toJMXConnector(Map<String, ?> map) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        Map<String, Object> map2 = new HashMap(this.attributes == null ? Collections.EMPTY_MAP : this.attributes);
        if (map != null) {
            EnvHelp.checkAttributes(map);
            map2.putAll(map);
        }
        map2 = EnvHelp.filterAttributes(map2);
        RMIServer rMIServer = (RMIServer)this.rmiServerImpl.toStub();
        return new RMIConnector(rMIServer, map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws IOException {
        Object object;
        Object object2;
        boolean bl;
        block31: {
            bl = logger.traceOn();
            if (this.state == 1) {
                if (bl) {
                    logger.trace("start", "already started");
                }
                return;
            }
            if (this.state == 2) {
                if (bl) {
                    logger.trace("start", "already stopped");
                }
                throw new IOException("The server has been stopped.");
            }
            if (this.getMBeanServer() == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.attributes != null && (object2 = (String)this.attributes.get("jmx.remote.x.access.file")) != null) {
                object = null;
                try {
                    object = new MBeanServerFileAccessController((String)object2);
                }
                catch (IOException iOException) {
                    throw EnvHelp.initCause(new IllegalArgumentException(iOException.getMessage()), iOException);
                }
                this.setMBeanServerForwarder((MBeanServerForwarder)object);
            }
            try {
                if (bl) {
                    logger.trace("start", "setting default class loader");
                }
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.attributes, this.getMBeanServer());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                object = new IllegalArgumentException("ClassLoader not found: " + instanceNotFoundException);
                throw (IllegalArgumentException)EnvHelp.initCause(object, instanceNotFoundException);
            }
            if (bl) {
                logger.trace("start", "setting RMIServer object");
            }
            object2 = this.rmiServerImpl != null ? this.rmiServerImpl : this.newServer();
            ((RMIServerImpl)object2).setMBeanServer(this.getMBeanServer());
            ((RMIServerImpl)object2).setDefaultClassLoader(this.defaultClassLoader);
            ((RMIServerImpl)object2).setRMIConnectorServer(this);
            ((RMIServerImpl)object2).export();
            try {
                if (bl) {
                    logger.trace("start", "getting RMIServer object to export");
                }
                object = RMIConnectorServer.objectToBind((RMIServerImpl)object2, this.attributes);
                if (this.address != null && this.address.getURLPath().startsWith("/jndi/")) {
                    String string = this.address.getURLPath().substring(6);
                    if (bl) {
                        logger.trace("start", "Using external directory: " + string);
                    }
                    boolean bl2 = EnvHelp.computeBooleanFromString((Map)this.attributes, (String)JNDI_REBIND_ATTRIBUTE);
                    if (bl) {
                        logger.trace("start", "jmx.remote.jndi.rebind=" + bl2);
                    }
                    try {
                        if (bl) {
                            logger.trace("start", "binding to " + string);
                        }
                        Hashtable hashtable = EnvHelp.mapToHashtable(this.attributes);
                        this.bind(string, hashtable, (RMIServer)object, bl2);
                        this.boundJndiUrl = string;
                        break block31;
                    }
                    catch (NamingException namingException) {
                        throw RMIConnectorServer.newIOException("Cannot bind to URL [" + string + "]: " + namingException, namingException);
                    }
                }
                if (bl) {
                    logger.trace("start", "Encoding URL");
                }
                this.encodeStubInAddress((RMIServer)object, this.attributes);
                if (bl) {
                    logger.trace("start", "Encoded URL: " + this.address);
                }
            }
            catch (Exception exception) {
                try {
                    ((RMIServerImpl)object2).close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw RMIConnectorServer.newIOException("Got unexpected exception while starting the connector server: " + exception, exception);
            }
        }
        this.rmiServerImpl = object2;
        object = openedServers;
        synchronized (object) {
            openedServers.add(this);
        }
        this.state = 1;
        if (bl) {
            logger.trace("start", "Connector Server Address = " + this.address);
            logger.trace("start", "started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        Object object;
        boolean bl;
        block24: {
            bl = logger.traceOn();
            object = this;
            synchronized (object) {
                if (this.state == 2) {
                    if (bl) {
                        logger.trace("stop", "already stopped.");
                    }
                    return;
                }
                if (this.state == 0 && bl) {
                    logger.trace("stop", "not started yet.");
                }
                if (bl) {
                    logger.trace("stop", "stopping.");
                }
                this.state = 2;
            }
            object = openedServers;
            synchronized (object) {
                openedServers.remove(this);
            }
            object = null;
            if (this.rmiServerImpl != null) {
                try {
                    if (bl) {
                        logger.trace("stop", "closing RMI server.");
                    }
                    this.rmiServerImpl.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        logger.trace("stop", "failed to close RMI server: " + iOException);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", iOException);
                    }
                    object = iOException;
                }
            }
            if (this.boundJndiUrl != null) {
                try {
                    if (bl) {
                        logger.trace("stop", "unbind from external directory: " + this.boundJndiUrl);
                    }
                    Hashtable hashtable = EnvHelp.mapToHashtable(this.attributes);
                    InitialContext initialContext = new InitialContext(hashtable);
                    initialContext.unbind(this.boundJndiUrl);
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    if (bl) {
                        logger.trace("stop", "failed to unbind RMI server: " + namingException);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", namingException);
                    }
                    if (object != null) break block24;
                    object = RMIConnectorServer.newIOException("Cannot bind to URL: " + namingException, namingException);
                }
            }
        }
        if (object != null) {
            throw object;
        }
        if (bl) {
            logger.trace("stop", "stopped");
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.state == 1;
    }

    @Override
    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.address;
    }

    @Override
    public Map<String, ?> getAttributes() {
        Map map = EnvHelp.filterAttributes(this.attributes);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public synchronized void setMBeanServerForwarder(MBeanServerForwarder mBeanServerForwarder) {
        super.setMBeanServerForwarder(mBeanServerForwarder);
        if (this.rmiServerImpl != null) {
            this.rmiServerImpl.setMBeanServer(this.getMBeanServer());
        }
    }

    @Override
    protected void connectionOpened(String string, String string2, Object object) {
        super.connectionOpened(string, string2, object);
    }

    @Override
    protected void connectionClosed(String string, String string2, Object object) {
        super.connectionClosed(string, string2, object);
    }

    @Override
    protected void connectionFailed(String string, String string2, Object object) {
        super.connectionFailed(string, string2, object);
    }

    void bind(String string, Hashtable hashtable, RMIServer rMIServer, boolean bl) throws NamingException, MalformedURLException {
        InitialContext initialContext = new InitialContext(hashtable);
        if (bl) {
            initialContext.rebind(string, (Object)rMIServer);
        } else {
            initialContext.bind(string, (Object)rMIServer);
        }
        initialContext.close();
    }

    RMIServerImpl newServer() throws IOException {
        boolean bl = RMIConnectorServer.isIiopURL(this.address, true);
        int n = this.address == null ? 0 : this.address.getPort();
        if (bl) {
            return RMIConnectorServer.newIIOPServer(this.attributes);
        }
        return RMIConnectorServer.newJRMPServer(this.attributes, n);
    }

    private void encodeStubInAddress(RMIServer rMIServer, Map map) throws IOException {
        int n;
        String string;
        String string2;
        if (this.address == null) {
            string2 = rMIServer instanceof Stub ? "iiop" : "rmi";
            string = null;
            n = 0;
        } else {
            string2 = this.address.getProtocol();
            string = this.address.getHost().equals("") ? null : this.address.getHost();
            n = this.address.getPort();
        }
        String string3 = RMIConnectorServer.encodeStub(rMIServer, map);
        this.address = new JMXServiceURL(string2, string, n, string3);
    }

    static boolean isIiopURL(JMXServiceURL jMXServiceURL, boolean bl) throws MalformedURLException {
        String string = jMXServiceURL.getProtocol();
        if (string.equals("rmi")) {
            return false;
        }
        if (string.equals("iiop")) {
            return true;
        }
        if (bl) {
            throw new MalformedURLException("URL must have protocol \"rmi\" or \"iiop\": \"" + string + "\"");
        }
        return false;
    }

    static String encodeStub(RMIServer rMIServer, Map map) throws IOException {
        if (rMIServer instanceof Stub) {
            return "/ior/" + RMIConnectorServer.encodeIIOPStub(rMIServer, map);
        }
        return "/stub/" + RMIConnectorServer.encodeJRMPStub(rMIServer, map);
    }

    static String encodeJRMPStub(RMIServer rMIServer, Map map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(rMIServer);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return RMIConnectorServer.byteArrayToBase64(byArray);
    }

    static String encodeIIOPStub(RMIServer rMIServer, Map map) throws IOException {
        try {
            Stub stub = (Stub)((Object)rMIServer);
            return stub._orb().object_to_string(stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw RMIConnectorServer.newIOException(bAD_OPERATION.getMessage(), bAD_OPERATION);
        }
    }

    private static RMIServer objectToBind(RMIServerImpl rMIServerImpl, Map map) throws IOException {
        return RMIConnector.connectStub((RMIServer)rMIServerImpl.toStub(), map);
    }

    private static RMIServerImpl newJRMPServer(Map map, int n) throws IOException {
        RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)map.get(RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE);
        RMIServerSocketFactory rMIServerSocketFactory = (RMIServerSocketFactory)map.get(RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE);
        return new RMIJRMPServerImpl(n, rMIClientSocketFactory, rMIServerSocketFactory, map);
    }

    private static RMIServerImpl newIIOPServer(Map map) throws IOException {
        return new RMIIIOPServerImpl(map);
    }

    private static String byteArrayToBase64(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = n3 / 3;
        int n5 = n3 - 3 * n4;
        int n6 = 4 * ((n3 + 2) / 3);
        StringBuffer stringBuffer = new StringBuffer(n6);
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = byArray[n7++] & 0xFF;
            int n8 = byArray[n7++] & 0xFF;
            int n9 = byArray[n7++] & 0xFF;
            stringBuffer.append(intToAlpha[n >> 2]);
            stringBuffer.append(intToAlpha[n << 4 & 0x3F | n8 >> 4]);
            stringBuffer.append(intToAlpha[n8 << 2 & 0x3F | n9 >> 6]);
            stringBuffer.append(intToAlpha[n9 & 0x3F]);
        }
        if (n5 != 0) {
            n2 = byArray[n7++] & 0xFF;
            stringBuffer.append(intToAlpha[n2 >> 2]);
            if (n5 == 1) {
                stringBuffer.append(intToAlpha[n2 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n = byArray[n7++] & 0xFF;
                stringBuffer.append(intToAlpha[n2 << 4 & 0x3F | n >> 4]);
                stringBuffer.append(intToAlpha[n << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    private static IOException newIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        return EnvHelp.initCause(iOException, throwable);
    }
}

