/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.swing.SwingUtilities2;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final String uiClassID = "InternalFrameUI";
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected boolean closable;
    protected boolean isClosed;
    protected boolean maximizable;
    protected boolean isMaximum;
    protected boolean iconable;
    protected boolean isIcon;
    protected boolean resizable;
    protected boolean isSelected;
    protected Icon frameIcon;
    protected String title;
    protected JDesktopIcon desktopIcon;
    private Cursor lastCursor;
    private boolean opened;
    private Rectangle normalBounds = null;
    private int defaultCloseOperation = 2;
    private Component lastFocusOwner;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String TITLE_PROPERTY = "title";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_ICON_PROPERTY = "icon";
    private static final Object PROPERTY_CHANGE_LISTENER_KEY = new Object();
    boolean isDragging = false;
    boolean danger = false;

    private static void addPropertyChangeListenerIfNecessary() {
        if (AppContext.getAppContext().get(PROPERTY_CHANGE_LISTENER_KEY) == null) {
            FocusPropertyChangeListener focusPropertyChangeListener = new FocusPropertyChangeListener();
            AppContext.getAppContext().put(PROPERTY_CHANGE_LISTENER_KEY, focusPropertyChangeListener);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(focusPropertyChangeListener);
        }
    }

    private static void updateLastFocusOwner(Component component) {
        if (component != null) {
            for (Component component2 = component; component2 != null && !(component2 instanceof Window); component2 = component2.getParent()) {
                if (!(component2 instanceof JInternalFrame)) continue;
                ((JInternalFrame)component2).setLastFocusOwner(component);
            }
        }
    }

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl, bl2, bl3, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setRootPane(this.createRootPane());
        this.setLayout(new BorderLayout());
        this.title = string;
        this.resizable = bl;
        this.closable = bl2;
        this.maximizable = bl3;
        this.isMaximum = false;
        this.iconable = bl4;
        this.isIcon = false;
        this.setVisible(false);
        this.setRootPaneCheckingEnabled(true);
        this.desktopIcon = new JDesktopIcon(this);
        this.updateUI();
        SunToolkit.checkAndSetPolicy(this, true);
        JInternalFrame.addPropertyChangeListenerIfNecessary();
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(internalFrameUI);
            Object var4_3 = null;
            this.setRootPaneCheckingEnabled(bl);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setRootPaneCheckingEnabled(bl);
            throw throwable;
        }
    }

    public void updateUI() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        if (this.desktopIcon != null) {
            this.desktopIcon.updateUIWhenHidden();
        }
    }

    void updateUIWhenHidden() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.invalidate();
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtilities.updateComponentTreeUI(componentArray[i]);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void remove(Component component) {
        int n = this.getComponentCount();
        super.remove(component);
        if (n == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    @Deprecated
    public JMenuBar getMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    @Deprecated
    public void setMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.getMenuBar();
        this.getRootPane().setJMenuBar(jMenuBar);
        this.firePropertyChange(MENU_BAR_PROPERTY, jMenuBar2, jMenuBar);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        Container container2 = this.getContentPane();
        this.getRootPane().setContentPane(container);
        this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        JLayeredPane jLayeredPane2 = this.getLayeredPane();
        this.getRootPane().setLayeredPane(jLayeredPane);
        this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        Component component2 = this.getGlassPane();
        this.getRootPane().setGlassPane(component);
        this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane jRootPane2 = this.getRootPane();
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
                Object var5_4 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setRootPaneCheckingEnabled(bl);
                throw throwable;
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, jRootPane2, jRootPane);
    }

    public void setClosable(boolean bl) {
        Boolean bl2 = this.closable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.closable = bl;
        this.firePropertyChange("closable", bl2, bl3);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean bl) throws PropertyVetoException {
        Boolean bl2;
        if (this.isClosed == bl) {
            return;
        }
        Boolean bl3 = this.isClosed ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl4 = bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        if (bl) {
            this.fireInternalFrameEvent(25550);
        }
        this.fireVetoableChange(IS_CLOSED_PROPERTY, bl3, bl2);
        this.isClosed = bl;
        if (this.isClosed) {
            this.setVisible(false);
        }
        this.firePropertyChange(IS_CLOSED_PROPERTY, bl3, bl2);
        if (this.isClosed) {
            this.dispose();
        } else if (!this.opened) {
            // empty if block
        }
    }

    public void setResizable(boolean bl) {
        Boolean bl2 = this.resizable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.resizable = bl;
        this.firePropertyChange("resizable", bl2, bl3);
    }

    public boolean isResizable() {
        return this.isMaximum ? false : this.resizable;
    }

    public void setIconifiable(boolean bl) {
        Boolean bl2 = this.iconable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.iconable = bl;
        this.firePropertyChange("iconable", bl2, bl3);
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        if (this.isIcon == bl) {
            return;
        }
        this.firePropertyChange("ancestor", null, this.getParent());
        Boolean bl2 = this.isIcon ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_ICON_PROPERTY, bl2, bl3);
        this.isIcon = bl;
        this.firePropertyChange(IS_ICON_PROPERTY, bl2, bl3);
        if (bl) {
            this.fireInternalFrameEvent(25552);
        } else {
            this.fireInternalFrameEvent(25553);
        }
    }

    public void setMaximizable(boolean bl) {
        Boolean bl2 = this.maximizable ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.maximizable = bl;
        this.firePropertyChange("maximizable", bl2, bl3);
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public void setMaximum(boolean bl) throws PropertyVetoException {
        if (this.isMaximum == bl) {
            return;
        }
        Boolean bl2 = this.isMaximum ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
        this.isMaximum = bl;
        this.firePropertyChange(IS_MAXIMUM_PROPERTY, bl2, bl3);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, string);
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (bl && this.isSelected) {
            this.restoreSubcomponentFocus();
            return;
        }
        if (this.isSelected == bl || bl && (this.isIcon ? !this.desktopIcon.isShowing() : !this.isShowing())) {
            return;
        }
        Boolean bl2 = this.isSelected ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(IS_SELECTED_PROPERTY, bl2, bl3);
        if (bl) {
            this.restoreSubcomponentFocus();
        }
        this.isSelected = bl;
        this.firePropertyChange(IS_SELECTED_PROPERTY, bl2, bl3);
        if (this.isSelected) {
            this.fireInternalFrameEvent(25554);
        } else {
            this.fireInternalFrameEvent(25555);
        }
        this.repaint();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setFrameIcon(Icon icon) {
        Icon icon2 = this.frameIcon;
        this.frameIcon = icon;
        this.firePropertyChange(FRAME_ICON_PROPERTY, icon2, icon);
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public void moveToFront() {
        if (this.isIcon()) {
            if (this.getDesktopIcon().getParent() instanceof JLayeredPane) {
                ((JLayeredPane)this.getDesktopIcon().getParent()).moveToFront(this.getDesktopIcon());
            }
        } else if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToFront(this);
        }
    }

    public void moveToBack() {
        if (this.isIcon()) {
            if (this.getDesktopIcon().getParent() instanceof JLayeredPane) {
                ((JLayeredPane)this.getDesktopIcon().getParent()).moveToBack(this.getDesktopIcon());
            }
        } else if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToBack(this);
        }
    }

    public Cursor getLastCursor() {
        return this.lastCursor;
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            this.lastCursor = null;
            super.setCursor(cursor);
            return;
        }
        int n = cursor.getType();
        if (n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 9 && n != 10 && n != 11) {
            this.lastCursor = cursor;
        }
        super.setCursor(cursor);
    }

    public void setLayer(Integer n) {
        if (this.getParent() != null && this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.setLayer(this, n, jLayeredPane.getPosition(this));
        } else {
            JLayeredPane.putLayer(this, n);
            if (this.getParent() != null) {
                this.getParent().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    public void setLayer(int n) {
        this.setLayer(new Integer(n));
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JDesktopPane getDesktopPane() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JDesktopPane); container = container.getParent()) {
        }
        if (container == null) {
            for (container = this.getDesktopIcon().getParent(); container != null && !(container instanceof JDesktopPane); container = container.getParent()) {
            }
        }
        return (JDesktopPane)container;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        JDesktopIcon jDesktopIcon2 = this.getDesktopIcon();
        this.desktopIcon = jDesktopIcon;
        this.firePropertyChange("desktopIcon", jDesktopIcon2, jDesktopIcon);
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    public Rectangle getNormalBounds() {
        if (this.normalBounds != null) {
            return this.normalBounds;
        }
        return this.getBounds();
    }

    public void setNormalBounds(Rectangle rectangle) {
        this.normalBounds = rectangle;
    }

    public Component getFocusOwner() {
        if (this.isSelected()) {
            return this.lastFocusOwner;
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        if (this.lastFocusOwner != null) {
            return this.lastFocusOwner;
        }
        FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof InternalFrameFocusTraversalPolicy) {
            return ((InternalFrameFocusTraversalPolicy)focusTraversalPolicy).getInitialComponent(this);
        }
        Component component = focusTraversalPolicy.getDefaultComponent(this);
        if (component != null) {
            return component;
        }
        return this.getContentPane();
    }

    public void restoreSubcomponentFocus() {
        if (this.isIcon()) {
            SwingUtilities2.compositeRequestFocus(this.getDesktopIcon());
        } else {
            this.lastFocusOwner = this.getMostRecentFocusOwner();
            if (this.lastFocusOwner == null) {
                this.lastFocusOwner = this.getContentPane();
            }
            this.lastFocusOwner.requestFocus();
        }
    }

    private void setLastFocusOwner(Component component) {
        this.lastFocusOwner = component;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.validate();
        this.repaint();
    }

    public void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.add(InternalFrameListener.class, internalFrameListener);
        this.enableEvents(0L);
    }

    public void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.remove(InternalFrameListener.class, internalFrameListener);
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(InternalFrameListener.class);
    }

    protected void fireInternalFrameEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        AWTEvent aWTEvent = null;
        block9: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InternalFrameListener.class) continue;
            if (aWTEvent == null) {
                aWTEvent = new InternalFrameEvent(this, n);
            }
            switch (aWTEvent.getID()) {
                case 25549: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameOpened((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25550: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosing((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25551: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosed((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25552: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameIconified((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25553: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeiconified((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25554: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameActivated((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
                case 25555: {
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeactivated((InternalFrameEvent)aWTEvent);
                    continue block9;
                }
            }
        }
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.defaultCloseOperation) {
            case 0: {
                break;
            }
            case 1: {
                this.setVisible(false);
                if (!this.isSelected()) break;
                try {
                    this.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                try {
                    this.fireVetoableChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.isClosed = true;
                    this.setVisible(false);
                    this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.dispose();
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        if (!this.opened) {
            this.fireInternalFrameEvent(25549);
            this.opened = true;
        }
        this.getDesktopIcon().setVisible(true);
        this.toFront();
        super.show();
        if (this.isIcon) {
            return;
        }
        if (!this.isSelected()) {
            try {
                this.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void hide() {
        if (this.isIcon()) {
            this.getDesktopIcon().setVisible(false);
        }
        super.hide();
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!this.isClosed) {
            this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            this.isClosed = true;
        }
        this.fireInternalFrameEvent(25551);
    }

    public void toFront() {
        this.moveToFront();
    }

    public void toBack() {
        this.moveToBack();
    }

    public final void setFocusCycleRoot(boolean bl) {
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public final String getWarningString() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                boolean bl = this.isRootPaneCheckingEnabled();
                try {
                    this.setRootPaneCheckingEnabled(false);
                    this.ui.installUI(this);
                    Object var5_4 = null;
                    this.setRootPaneCheckingEnabled(bl);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.setRootPaneCheckingEnabled(bl);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compWriteObjectNotify() {
        boolean bl = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.compWriteObjectNotify();
            Object var3_2 = null;
            this.setRootPaneCheckingEnabled(bl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setRootPaneCheckingEnabled(bl);
            throw throwable;
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        String string4 = this.closable ? "true" : "false";
        String string5 = this.isClosed ? "true" : "false";
        String string6 = this.maximizable ? "true" : "false";
        String string7 = this.isMaximum ? "true" : "false";
        String string8 = this.iconable ? "true" : "false";
        String string9 = this.isIcon ? "true" : "false";
        String string10 = this.resizable ? "true" : "false";
        String string11 = this.isSelected ? "true" : "false";
        String string12 = this.frameIcon != null ? this.frameIcon.toString() : "";
        String string13 = this.title != null ? this.title : "";
        String string14 = this.desktopIcon != null ? this.desktopIcon.toString() : "";
        String string15 = string = this.opened ? "true" : "false";
        String string16 = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        return super.paramString() + ",closable=" + string4 + ",defaultCloseOperation=" + string16 + ",desktopIcon=" + string14 + ",frameIcon=" + string12 + ",iconable=" + string8 + ",isClosed=" + string5 + ",isIcon=" + string9 + ",isMaximum=" + string7 + ",isSelected=" + string11 + ",maximizable=" + string6 + ",opened=" + string + ",resizable=" + string10 + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3 + ",title=" + string13;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isDragging) {
            this.danger = true;
        }
        super.paintComponent(graphics);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleJInternalFrame() {
        }

        public String getAccessibleName() {
            String string = this.accessibleName;
            if (string == null) {
                string = (String)JInternalFrame.this.getClientProperty("AccessibleName");
            }
            if (string == null) {
                string = JInternalFrame.this.getTitle();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JInternalFrame.this.getLayer());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            JInternalFrame.this.setLayer(new Integer(number.intValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }
    }

    private static class FocusPropertyChangeListener
    implements PropertyChangeListener {
        private FocusPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "permanentFocusOwner") {
                JInternalFrame.updateLastFocusOwner((Component)propertyChangeEvent.getNewValue());
            }
        }
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        JInternalFrame internalFrame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.setVisible(false);
            this.setInternalFrame(jInternalFrame);
            this.updateUI();
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public JInternalFrame getInternalFrame() {
            return this.internalFrame;
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.internalFrame = jInternalFrame;
        }

        public JDesktopPane getDesktopPane() {
            if (this.getInternalFrame() != null) {
                return this.getInternalFrame().getDesktopPane();
            }
            return null;
        }

        public void updateUI() {
            boolean bl = this.ui != null;
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            this.invalidate();
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            if (this.internalFrame != null && this.internalFrame.getUI() != null) {
                SwingUtilities.updateComponentTreeUI(this.internalFrame);
            }
        }

        void updateUIWhenHidden() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
            Dimension dimension = this.getPreferredSize();
            this.setSize(dimension.width, dimension.height);
            this.invalidate();
            Component[] componentArray = this.getComponents();
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    SwingUtilities.updateComponentTreeUI(componentArray[i]);
                }
            }
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.getUIClassID().equals("DesktopIconUI")) {
                byte by = JComponent.getWriteObjCounter(this);
                by = (byte)(by - 1);
                JComponent.setWriteObjCounter(this, by);
                if (by == 0 && this.ui != null) {
                    this.ui.installUI(this);
                }
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon();
            }
            return this.accessibleContext;
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            protected AccessibleJDesktopIcon() {
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.getCurrentAccessibleValue();
                }
                return null;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                if (number == null) {
                    return false;
                }
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
                if (accessibleValue != null) {
                    return accessibleValue.setCurrentAccessibleValue(number);
                }
                return false;
            }

            public Number getMinimumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMinimumAccessibleValue();
                }
                return null;
            }

            public Number getMaximumAccessibleValue() {
                AccessibleContext accessibleContext = JDesktopIcon.this.getInternalFrame().getAccessibleContext();
                if (accessibleContext instanceof AccessibleValue) {
                    return ((AccessibleValue)((Object)accessibleContext)).getMaximumAccessibleValue();
                }
                return null;
            }
        }
    }
}

