/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax.Lexer;

import com.Ostermiller.Syntax.Lexer.Token;

public class SQLToken
extends Token {
    public static final int RESERVED_WORD = 256;
    public static final int IDENTIFIER = 512;
    public static final int LITERAL_STRING = 768;
    public static final int LITERAL_BIT_STRING = 784;
    public static final int LITERAL_INTEGER = 800;
    public static final int LITERAL_FLOAT = 816;
    public static final int SEPARATOR = 1024;
    public static final int OPERATOR = 1280;
    public static final int COMMENT_TRADITIONAL = 3328;
    public static final int COMMENT_END_OF_LINE = 3344;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR = 3840;
    public static final int ERROR_UNCLOSED_COMMENT = 3842;
    public static final int ERROR_UNCLOSED_STRING = 3843;
    public static final int ERROR_UNCLOSED_BIT_STRING = 3844;
    public static final int ERROR_BAD_BIT_STRING = 3845;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public SQLToken(int n2, String string, int n3, int n4, int n5) {
        this(n2, string, n3, n4, n5, -1);
    }

    public SQLToken(int n2, String string, int n3, int n4, int n5, int n6) {
        this.ID = n2;
        this.contents = new String(string);
        this.lineNumber = n3;
        this.charBegin = n4;
        this.charEnd = n5;
        this.state = n6;
    }

    public int getState() {
        return this.state;
    }

    public int getID() {
        return this.ID;
    }

    public String getContents() {
        return new String(this.contents);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharBegin() {
        return this.charBegin;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isReservedWord() {
        return this.ID >> 8 == 1;
    }

    public boolean isIdentifier() {
        return this.ID >> 8 == 2;
    }

    public boolean isLiteral() {
        return this.ID >> 8 == 3;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 4;
    }

    public boolean isOperator() {
        return this.ID >> 8 == 5;
    }

    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    public String getDescription() {
        if (this.isReservedWord()) {
            return "reservedWord";
        }
        if (this.isIdentifier()) {
            return "identifier";
        }
        if (this.isLiteral()) {
            return "literal";
        }
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isOperator()) {
            return "operator";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    public String errorString() {
        String string;
        if (this.isError()) {
            string = "Error on line " + this.lineNumber + ": ";
            switch (this.ID) {
                case 3840: {
                    string = string + "Unexpected token: " + this.contents;
                    break;
                }
                case 3842: {
                    string = string + "Unclosed comment: " + this.contents;
                    break;
                }
                case 3843: {
                    string = string + "Unclosed string literal: " + this.contents;
                    break;
                }
                case 3844: {
                    string = string + "Unclosed bit-string literal: " + this.contents;
                    break;
                }
                case 3845: {
                    string = string + "Bit-strings can only contain 0 and 1: " + this.contents;
                }
            }
        } else {
            string = null;
        }
        return string;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

