/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax;

import com.Ostermiller.Syntax.Lexer.CLexer;
import com.Ostermiller.Syntax.Lexer.HTMLLexer;
import com.Ostermiller.Syntax.Lexer.HTMLLexer1;
import com.Ostermiller.Syntax.Lexer.JavaLexer;
import com.Ostermiller.Syntax.Lexer.Lexer;
import com.Ostermiller.Syntax.Lexer.PlainLexer;
import com.Ostermiller.Syntax.Lexer.Token;
import com.Ostermiller.bte.CompileException;
import com.Ostermiller.bte.Compiler;
import com.Ostermiller.util.CircularCharBuffer;
import com.Ostermiller.util.StringHelper;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ToHTML {
    private static ToHTML defaultToHTML = new ToHTML();
    private PrintWriter out;
    private Reader in;
    private String fileExt;
    private String mimeType;
    private Lexer lexer;
    private String lexerType;
    private String styleSheet;
    private HashSet ignoreStyles = new HashSet();
    private HashMap translateStyles = new HashMap();
    private String bteSuper;
    private String title;
    private String docName;
    private HashMap lexers = new HashMap();
    private static HashMap registeredMimeTypes = new HashMap();
    private static HashMap registeredFileExtensions = new HashMap();
    private static SimpleDateFormat dateFormat;
    private CircularCharBuffer circularBuffer = null;
    private Compiler compiler = null;
    private static String version;
    protected static ResourceBundle labels;

    public static void register(String string, String[] stringArray, String[] stringArray2) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            registeredMimeTypes.put(stringArray[n2], string);
            ++n2;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            registeredFileExtensions.put(stringArray2[n3].toLowerCase(), string);
            ++n3;
        }
    }

    private void openSpan(String string, PrintWriter printWriter) throws IOException {
        if (this.translateStyles.containsKey(string)) {
            string = (String)this.translateStyles.get(string);
        }
        if (!this.ignoreStyles.contains(string)) {
            printWriter.print("<span class=" + string + ">");
        }
    }

    private void closeSpan(String string, PrintWriter printWriter) throws IOException {
        if (this.translateStyles.containsKey(string)) {
            string = (String)this.translateStyles.get(string);
        }
        if (!this.ignoreStyles.contains(string)) {
            printWriter.print("</span>");
        }
    }

    private void writeHTMLFragment(Lexer lexer, PrintWriter printWriter) throws IOException {
        Token token;
        String string = null;
        printWriter.println();
        printWriter.print("<pre>");
        while ((token = lexer.getNextToken()) != null) {
            if (token.isWhiteSpace() && this.ignoreStyles.contains("whitespace") || string != null && token.getDescription().equals(string)) {
                ToHTML.writeEscapedHTML(token.getContents(), printWriter);
                continue;
            }
            if (string != null) {
                this.closeSpan(string, printWriter);
            }
            string = token.getDescription();
            this.openSpan(string, printWriter);
            ToHTML.writeEscapedHTML(token.getContents(), printWriter);
        }
        if (string != null) {
            this.closeSpan(string, printWriter);
        }
        printWriter.println("</pre>");
    }

    public void writeHTMLFragment() throws IOException, InvocationTargetException {
        Lexer lexer = this.lexer;
        if (lexer == null) {
            lexer = this.getLexerFromClass(this.lexerType);
        }
        if (lexer == null) {
            lexer = this.getLexerFromMime();
        }
        if (lexer == null) {
            lexer = this.getLexerFromExt();
        }
        this.writeHTMLFragment(lexer, this.out);
        this.out.flush();
    }

    public void writeFullHTML() throws IOException, InvocationTargetException, CompileException {
        PrintWriter printWriter;
        Lexer lexer = this.lexer;
        if (lexer == null) {
            lexer = this.getLexerFromClass(this.lexerType);
        }
        if (lexer == null) {
            lexer = this.getLexerFromMime();
        }
        if (lexer == null) {
            lexer = this.getLexerFromExt();
        }
        boolean bl = false;
        try {
            if (this.bteSuper == null) {
                bl = true;
            } else {
                if (this.compiler == null) {
                    this.compiler = new Compiler();
                }
                if (this.circularBuffer == null) {
                    this.circularBuffer = new CircularCharBuffer(-1);
                } else {
                    this.circularBuffer.clear();
                }
                printWriter = new PrintWriter(this.circularBuffer.getWriter());
                printWriter.print("<%bte.doc super='" + this.bteSuper + "' %>\n");
                printWriter.print("<%bte.tpl name=date %>" + dateFormat.format(new Date()) + "<%/bte.tpl%>\n");
                if (this.title != null) {
                    printWriter.print("<%bte.tpl name=title %>" + this.title + "<%/bte.tpl%>\n");
                }
                if (this.fileExt != null) {
                    printWriter.print("<%bte.tpl name=fileExtension %>" + this.fileExt + "<%/bte.tpl%>\n");
                }
                if (this.docName != null) {
                    printWriter.print("<%bte.tpl name=fileName %>" + this.docName + "<%/bte.tpl%>\n");
                }
                if (this.styleSheet != null) {
                    printWriter.print("<%bte.tpl name=styleSheet %>" + this.styleSheet + "<%/bte.tpl%>\n");
                }
                printWriter.print("<%bte.tpl name=highlightedDocument %>");
                this.writeHTMLFragment(lexer, printWriter);
                printWriter.print("<%/bte.tpl%>\n");
                printWriter.print("<%/bte.doc%>\n");
                printWriter.close();
                Reader reader = this.circularBuffer.getReader();
                this.compiler.compile(reader, this.out);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = true;
        }
        if (bl) {
            printWriter = this.out;
            printWriter.println("<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>");
            printWriter.println("<html>");
            printWriter.println("<head>");
            if (this.title != null) {
                printWriter.println("<title>" + this.title + "</title>");
            }
            printWriter.println("<meta http-equiv='content-type' content='text/html;charset=ISO-8859-1'>");
            if (this.styleSheet != null) {
                printWriter.println("<link rel='stylesheet' title='Syntax Highlighting' href='" + this.styleSheet + "' type='text/css'>");
            }
            printWriter.println("</head>");
            printWriter.println("<body>");
            this.writeHTMLFragment(lexer, printWriter);
            printWriter.println("<div style='border: thin black ridge;padding:1cm;'>");
            printWriter.println("<!--");
            printWriter.println("To customize the appearance of the html that is emitted you must install");
            printWriter.println("the BTE template system from:");
            printWriter.println("http://ostermiller.org/bte/");
            printWriter.println("-->");
            printWriter.println("Syntax Highlighting created using the ");
            printWriter.println("<a href='http://ostermiller.org/syntax/'>com.Ostermiller.Syntax</a> package.<br>");
            printWriter.println(dateFormat.format(new Date()));
            printWriter.println("</div>");
            printWriter.println("</body>");
            printWriter.println("</html>");
        }
        this.out.flush();
    }

    public void setTemplate(String string) {
        this.bteSuper = string;
    }

    public void setFileExt(String string) {
        this.fileExt = string;
    }

    public void setDocName(String string) {
        this.docName = string;
    }

    public void setLexerType(String string) {
        this.lexerType = string;
    }

    private void setLexer(Lexer lexer) {
        this.saveLexer(lexer);
        this.lexer = lexer;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setOutput(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void setOutput(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void setOutput(File file) throws IOException {
        this.setOutput(new FileWriter(file));
    }

    public void setInput(File file) throws IOException {
        this.setInput(new FileReader(file));
    }

    public void setInput(Reader reader) {
        this.in = reader;
    }

    public void setStyleSheet(String string) {
        this.styleSheet = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean addIgnoreStyle(String string) {
        return this.ignoreStyles.add(string);
    }

    public boolean removeIgnoreStyle(String string) {
        return this.ignoreStyles.remove(string);
    }

    public String translateStyle(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        String string3 = this.translateStyles.put(string, string2);
        if (string3 == null) {
            return string;
        }
        return string3;
    }

    public String removeTranslation(String string) {
        String string2 = (String)this.translateStyles.remove(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        block30: {
            int n2;
            LongOpt[] longOptArray = new LongOpt[]{new LongOpt(labels.getString("help.option"), 0, null, 1), new LongOpt(labels.getString("version.option"), 0, null, 2), new LongOpt(labels.getString("about.option"), 0, null, 3), new LongOpt(labels.getString("m.option"), 1, null, 109), new LongOpt(labels.getString("l.option"), 1, null, 108), new LongOpt(labels.getString("T.option"), 1, null, 84), new LongOpt(labels.getString("i.option"), 1, null, 105), new LongOpt(labels.getString("t.option"), 1, null, 116), new LongOpt(labels.getString("s.option"), 1, null, 115), new LongOpt(labels.getString("o.option"), 1, null, 111), new LongOpt(labels.getString("f.option"), 0, null, 102), new LongOpt(labels.getString("r.option"), 1, null, 114)};
            String string = "m:l:T:i:t:s:o:fr:";
            Getopt getopt = new Getopt(labels.getString("tohtml"), stringArray, string, longOptArray);
            ToHTML toHTML = new ToHTML();
            toHTML.setTemplate(ClassLoader.getSystemResource("com/Ostermiller/Syntax/page.bte").toString());
            toHTML.setStyleSheet("syntax.css");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            block23: while ((n2 = getopt.getopt()) != -1) {
                switch (n2) {
                    case 1: {
                        String[] stringArray2 = new String[]{"--" + labels.getString("help.option"), "--" + labels.getString("version.option"), "--" + labels.getString("about.option"), "-m --" + labels.getString("m.option") + " <" + labels.getString("type") + ">", "-l --" + labels.getString("l.option") + " <" + labels.getString("class") + ">", "-T --" + labels.getString("T.option") + " <" + labels.getString("title") + ">", "-i --" + labels.getString("i.option") + " <" + labels.getString("class") + ">", "-t --" + labels.getString("t.option") + " <" + labels.getString("url") + "|" + labels.getString("file") + ">", "-s --" + labels.getString("s.option") + " <" + labels.getString("url") + ">", "-o --" + labels.getString("o.option") + " <" + labels.getString("file") + ">", "-f --" + labels.getString("f.option"), "-r --" + labels.getString("r.option") + " <" + labels.getString("translate") + ">"};
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            n3 = Math.max(n3, stringArray2[n4].length());
                            ++n4;
                        }
                        System.out.println(labels.getString("tohtml") + " [-" + StringHelper.replace(string, ":", "") + "] <" + labels.getString("files") + ">\n" + labels.getString("purpose.message") + "\n" + labels.getString("stdin.message") + "\n" + " " + StringHelper.postpad(stringArray2[0], ++n3, ' ') + labels.getString("help.message") + "\n" + " " + StringHelper.postpad(stringArray2[1], n3, ' ') + labels.getString("version.message") + "\n" + " " + StringHelper.postpad(stringArray2[2], n3, ' ') + labels.getString("about.message") + "\n" + " " + StringHelper.postpad(stringArray2[3], n3, ' ') + labels.getString("m.message") + "\n" + " " + StringHelper.postpad(stringArray2[4], n3, ' ') + labels.getString("l.message") + "\n" + " " + StringHelper.postpad(stringArray2[5], n3, ' ') + labels.getString("T.message") + "\n" + " " + StringHelper.postpad(stringArray2[6], n3, ' ') + labels.getString("i.message") + "\n" + " " + StringHelper.postpad(stringArray2[7], n3, ' ') + labels.getString("t.message") + "\n" + " " + StringHelper.postpad(stringArray2[8], n3, ' ') + labels.getString("s.message") + "\n" + " " + StringHelper.postpad(stringArray2[9], n3, ' ') + labels.getString("o.message") + "\n" + " " + StringHelper.postpad(stringArray2[10], n3, ' ') + labels.getString("f.message") + "\n" + " " + StringHelper.postpad(stringArray2[11], n3, ' ') + labels.getString("r.message") + "\n");
                        System.exit(0);
                        break;
                    }
                    case 2: {
                        System.out.println(MessageFormat.format(labels.getString("version"), version));
                        System.exit(0);
                        break;
                    }
                    case 3: {
                        System.out.println(labels.getString("tohtml") + " -- " + labels.getString("purpose.message") + "\n" + MessageFormat.format(labels.getString("copyright"), "1999-2002", "Stephen Ostermiller (http://ostermiller.org/contact.pl?regarding=Syntax+Highlighting)") + "\n\n" + labels.getString("license"));
                        System.exit(0);
                        break;
                    }
                    case 109: {
                        toHTML.setMimeType(getopt.getOptarg());
                        break;
                    }
                    case 108: {
                        toHTML.setLexerType(getopt.getOptarg());
                        break;
                    }
                    case 84: {
                        string3 = getopt.getOptarg();
                        break;
                    }
                    case 105: {
                        toHTML.addIgnoreStyle(getopt.getOptarg());
                        break;
                    }
                    case 116: {
                        String[] stringArray2 = getopt.getOptarg();
                        File file = new File(getopt.getOptarg());
                        if (file.exists()) {
                            try {
                                toHTML.setTemplate(file.toURL().toString());
                            }
                            catch (MalformedURLException malformedURLException) {
                                toHTML.setTemplate((String)stringArray2);
                            }
                            continue block23;
                        }
                        toHTML.setTemplate((String)stringArray2);
                        break;
                    }
                    case 115: {
                        toHTML.setStyleSheet(getopt.getOptarg());
                        break;
                    }
                    case 111: {
                        string2 = getopt.getOptarg();
                        break;
                    }
                    case 102: {
                        bl = true;
                        break;
                    }
                    case 114: {
                        String[] stringArray2 = new StringTokenizer(getopt.getOptarg(), "=", false);
                        if (stringArray2.countTokens() != 2) {
                            System.err.println(labels.getString("unexpectedTranslation"));
                            System.exit(1);
                        }
                        toHTML.translateStyle(stringArray2.nextToken().trim(), stringArray2.nextToken().trim());
                        break;
                    }
                    default: {
                        System.err.println(labels.getString("unexpectedArgument"));
                        System.exit(1);
                    }
                }
            }
            try {
                if (stringArray.length <= getopt.getOptind()) {
                    try {
                        if (string2 == null) {
                            string2 = "--";
                        }
                        toHTML.setOutput(string2, "out.html", bl);
                        toHTML.setInput(new InputStreamReader(System.in));
                        toHTML.setTitle(string3 != null ? string3 : "HTML of System.in" + (toHTML.getMimeType() == null ? "" : " (" + toHTML.getMimeType() + ")"));
                        toHTML.writeFullHTML();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                    break block30;
                }
                int n5 = getopt.getOptind();
                while (n5 < stringArray.length) {
                    try {
                        String string4 = stringArray[n5] + ".html";
                        String string5 = null;
                        string5 = string2 == null ? string4 : string2;
                        toHTML.setOutput(string5, string4, bl);
                        toHTML.setExtFromFileName(stringArray[n5]);
                        toHTML.setDocNameFromFileName(stringArray[n5]);
                        toHTML.setInput(new FileReader(stringArray[n5]));
                        toHTML.setTitle(string3 != null ? string3 : "HTML of " + ToHTML.getDocName(stringArray[n5]) + (toHTML.getMimeType() == null ? "" : " (" + toHTML.getMimeType() + ")"));
                        toHTML.writeFullHTML();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                    ++n5;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(invocationTargetException.getMessage());
            }
            catch (CompileException compileException) {
                System.err.println(compileException.getMessage());
            }
        }
    }

    private static String getDocName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = "";
            int n2 = string.lastIndexOf(".");
            int n3 = string.lastIndexOf(System.getProperty("file.separator"));
            int n4 = n3 + 1;
            if (n3 == -1) {
                n4 = 0;
            }
            int n5 = n2;
            if (n2 == -1 || n2 < n3) {
                n5 = string.length();
            }
            string2 = string.substring(n4, n5);
        }
        return string2;
    }

    public void setDocNameFromFileName(String string) {
        this.setDocName(ToHTML.getDocName(string));
    }

    public void setExtFromFileName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = "";
            int n2 = string.lastIndexOf(".");
            int n3 = string.lastIndexOf(System.getProperty("file.separator"));
            if (n2 != -1 && n2 > n3) {
                string2 = string.substring(n2 + 1, string.length());
            }
        }
        this.setFileExt(string2);
    }

    private void setOutput(String string, String string2, boolean bl) throws IOException {
        if (string.equals("--")) {
            this.setOutput(new PrintWriter(System.out, true));
        } else {
            File file = new File(string2);
            if (string != null && (file = new File(string)).isDirectory()) {
                int n2 = string2.lastIndexOf(System.getProperty("file.separator"));
                if (n2 != -1) {
                    string2 = string2.substring(n2 + 1, string2.length());
                }
                file = new File(file, string2);
            }
            if (!bl && file.exists()) {
                throw new IOException(MessageFormat.format(labels.getString("fileExists"), file.toString()));
            }
            this.setOutput(file);
            if (this.getStyleSheet().equals("syntax.css")) {
                ToHTML.putSyntaxCSS(file.getParentFile());
            }
        }
    }

    private static boolean putSyntaxCSS(File file) throws IOException {
        int n2;
        File file2 = file == null ? new File("syntax.css") : new File(file, "syntax.css");
        if (file2.exists()) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("com/Ostermiller/Syntax/doc/syntax.css");
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        fileOutputStream.close();
        return true;
    }

    public static void htmlifyJava(Reader reader, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer((Lexer)new JavaLexer(reader));
            toHTML.setOutput(printWriter);
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlifyC(Reader reader, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer(new CLexer(reader));
            toHTML.setOutput(printWriter);
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlifySimpleHTML(Reader reader, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer((Lexer)new HTMLLexer(reader));
            toHTML.setOutput(printWriter);
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlifyComplexHTML(Reader reader, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer((Lexer)new HTMLLexer1(reader));
            toHTML.setOutput(printWriter);
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlifyPlain(Reader reader, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer(new PlainLexer(reader));
            toHTML.setOutput(printWriter);
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlify(Reader reader, PrintWriter printWriter, String string) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setInput(reader);
            toHTML.setOutput(printWriter);
            toHTML.setMimeType(string);
            toHTML.writeFullHTML();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (CompileException compileException) {}
    }

    private void saveLexer(Lexer lexer) {
        if (!this.lexers.containsKey(this.lexerType)) {
            this.lexers.put(lexer.getClass().getName(), lexer);
        }
    }

    private Lexer getLexerFromClass(String string) throws IOException, InvocationTargetException {
        Lexer lexer = null;
        if (string != null) {
            if (this.lexers.containsKey(string)) {
                lexer = (Lexer)this.lexers.get(string);
                lexer.reset(this.in, 0, 0, 0);
            } else {
                try {
                    lexer = (Lexer)Class.forName(string).getDeclaredConstructor(Class.forName("java.io.Reader")).newInstance(this.in);
                    this.saveLexer(lexer);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InvocationTargetException(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InvocationTargetException(noSuchMethodException);
                }
                catch (InstantiationException instantiationException) {
                    throw new InvocationTargetException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InvocationTargetException(illegalAccessException);
                }
            }
        }
        return lexer;
    }

    private Lexer getLexerFromMime() throws IOException, InvocationTargetException {
        String string = null;
        if (this.mimeType != null) {
            if (registeredMimeTypes.containsKey(this.mimeType)) {
                string = (String)registeredMimeTypes.get(this.mimeType);
            } else {
                String string2;
                int n2 = this.mimeType.indexOf("/");
                if (n2 > 0 && registeredMimeTypes.containsKey(string2 = this.mimeType.substring(0, n2))) {
                    string = (String)registeredMimeTypes.get(string2);
                }
            }
        }
        return this.getLexerFromClass(string);
    }

    private Lexer getLexerFromExt() throws IOException, InvocationTargetException {
        String string = null;
        if (this.fileExt != null && registeredFileExtensions.containsKey(this.fileExt.toLowerCase())) {
            string = (String)registeredFileExtensions.get(this.fileExt.toLowerCase());
        }
        if (string == null) {
            string = "com.Ostermiller.Syntax.Lexer.PlainLexer";
        }
        return this.getLexerFromClass(string);
    }

    public static void htmlify(Reader reader, PrintWriter printWriter, String string, String string2) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setInput(reader);
            toHTML.setOutput(printWriter);
            toHTML.setTitle(string);
            toHTML.setMimeType(string2);
            toHTML.writeFullHTML();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (CompileException compileException) {}
    }

    public static void htmlify(InputStream inputStream, PrintStream printStream, String string) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setInput(new InputStreamReader(inputStream));
            toHTML.setOutput(new PrintWriter(printStream));
            toHTML.setMimeType(string);
            toHTML.writeFullHTML();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (CompileException compileException) {}
    }

    public static void htmlify(Lexer lexer, PrintWriter printWriter) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer(lexer);
            toHTML.setOutput(new PrintWriter(printWriter));
            toHTML.writeHTMLFragment();
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public static void htmlify(Lexer lexer, PrintStream printStream) throws IOException {
        ToHTML.htmlify(lexer, new PrintWriter(printStream));
    }

    public static void htmlify(Lexer lexer, PrintWriter printWriter, String string) throws IOException {
        try {
            ToHTML toHTML = new ToHTML();
            toHTML.setLexer(lexer);
            toHTML.setOutput(printWriter);
            toHTML.setTitle(string);
            toHTML.writeFullHTML();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (CompileException compileException) {}
    }

    public static void htmlify(Lexer lexer, PrintStream printStream, String string) throws IOException {
        ToHTML.htmlify(lexer, new PrintWriter(printStream), string);
    }

    public static void writeEscapedHTML(String string, PrintWriter printWriter) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    printWriter.print("&lt;");
                    bl = false;
                    break;
                }
                case '>': {
                    printWriter.print("&gt;");
                    bl = false;
                    break;
                }
                case '&': {
                    printWriter.print("&amp;");
                    bl = false;
                    break;
                }
                case '\"': {
                    printWriter.print("&quot;");
                    bl = false;
                    break;
                }
                default: {
                    printWriter.print(c2);
                    bl = false;
                }
            }
            ++n2;
        }
    }

    public static void writeEscapedHTML(String string, PrintStream printStream) {
        ToHTML.writeEscapedHTML(string, new PrintWriter(printStream));
    }

    static {
        ToHTML.register("com.Ostermiller.Syntax.Lexer.HTMLLexer1", new String[]{"text/html"}, new String[]{"htm", "html"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.JavaLexer", new String[]{"text/x-java", "text/java"}, new String[]{"jav", "java"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.SQLLexer", new String[]{"text/x-sql", "application/x-sql"}, new String[]{"sql"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.CLexer", new String[]{"text/x-c++hdr", "text/x-csrc", "text/x-chdr", "text/x-csrc", "text/c"}, new String[]{"c", "h", "cc", "cpp", "cxx", "c++", "hpp", "hxx", "hh"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.PropertiesLexer", new String[]{"text/x-properties"}, new String[]{"props", "properties"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.LatexLexer", new String[]{"application/x-latex", "text/x-latex", "application/x-tex", "text/x-tex"}, new String[]{"tex", "sty", "cls", "dtx", "ins", "latex"});
        ToHTML.register("com.Ostermiller.Syntax.Lexer.PlainLexer", new String[]{"text/plain", "text"}, new String[]{"txt", "text"});
        dateFormat = new SimpleDateFormat("EEEE, MMMM dd yyyy 'at' HH:mm");
        version = "1.1.1";
        labels = ResourceBundle.getBundle("com.Ostermiller.Syntax.ToHTML", Locale.getDefault());
    }
}

