/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CircularCharBuffer;
import java.io.Reader;
import java.io.Writer;

public class CircularCharBuffer {
    private static final int DEFAULT_SIZE = 1024;
    public static final int INFINITE_SIZE = -1;
    protected char[] buffer;
    protected volatile int readPosition = 0;
    protected volatile int writePosition = 0;
    protected volatile int markPosition = 0;
    protected volatile int markSize = 0;
    protected volatile boolean infinite = false;
    protected boolean blockingWrite = true;
    protected Reader reader = new CircularCharBufferReader(this);
    protected boolean readerClosed = false;
    protected Writer writer = new CircularCharBufferWriter(this);
    protected boolean writerClosed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            this.readPosition = 0;
            this.writePosition = 0;
            this.markPosition = 0;
            this.readerClosed = false;
            this.writerClosed = false;
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpaceLeft() {
        CircularCharBuffer circularCharBuffer = this;
        synchronized (circularCharBuffer) {
            return this.spaceLeft();
        }
    }

    public int getSize() {
        return this.buffer.length;
    }

    String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer(this.buffer.length);
        int n2 = 0;
        while (n2 < this.buffer.length) {
            if (n2 == this.writePosition) {
                stringBuffer.append('$');
            }
            if (n2 == this.readPosition) {
                stringBuffer.append('#');
            }
            if (n2 == this.markPosition) {
                stringBuffer.append('!');
            }
            if (this.buffer[n2] >= '%' && this.buffer[n2] <= '~') {
                stringBuffer.append(this.buffer[n2]);
            } else {
                stringBuffer.append(' ');
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private void resize() {
        char[] cArray = new char[this.buffer.length * 2];
        int n2 = this.marked();
        int n3 = this.available();
        if (this.markPosition <= this.writePosition) {
            int n4 = this.writePosition - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, cArray, 0, n4);
        } else {
            int n5 = this.buffer.length - this.markPosition;
            System.arraycopy(this.buffer, this.markPosition, cArray, 0, n5);
            int n6 = this.writePosition;
            System.arraycopy(this.buffer, 0, cArray, n5, n6);
        }
        this.buffer = cArray;
        this.markPosition = 0;
        this.readPosition = n2;
        this.writePosition = n2 + n3;
    }

    private int spaceLeft() {
        if (this.writePosition < this.markPosition) {
            return this.markPosition - this.writePosition - 1;
        }
        return this.buffer.length - 1 - (this.writePosition - this.markPosition);
    }

    private int available() {
        if (this.readPosition <= this.writePosition) {
            return this.writePosition - this.readPosition;
        }
        return this.buffer.length - (this.readPosition - this.writePosition);
    }

    private int marked() {
        if (this.markPosition <= this.readPosition) {
            return this.readPosition - this.markPosition;
        }
        return this.buffer.length - (this.markPosition - this.readPosition);
    }

    private void ensureMark() {
        if (this.marked() >= this.markSize) {
            this.markPosition = this.readPosition;
            this.markSize = 0;
        }
    }

    public CircularCharBuffer() {
        this(1024, true);
    }

    public CircularCharBuffer(int n2) {
        this(n2, true);
    }

    public CircularCharBuffer(boolean bl) {
        this(1024, bl);
    }

    public CircularCharBuffer(int n2, boolean bl) {
        if (n2 == -1) {
            this.buffer = new char[1024];
            this.infinite = true;
        } else {
            this.buffer = new char[n2];
            this.infinite = false;
        }
        this.blockingWrite = bl;
    }

    static /* synthetic */ int access$000(CircularCharBuffer circularCharBuffer) {
        return circularCharBuffer.available();
    }

    static /* synthetic */ void access$100(CircularCharBuffer circularCharBuffer) {
        circularCharBuffer.ensureMark();
    }

    static /* synthetic */ int access$200(CircularCharBuffer circularCharBuffer) {
        return circularCharBuffer.spaceLeft();
    }

    static /* synthetic */ void access$300(CircularCharBuffer circularCharBuffer) {
        circularCharBuffer.resize();
    }
}

