/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;

class Opt
extends EscherAtom {
    private byte[] data;
    private int numProperties;
    private ArrayList properties;

    public Opt(EscherRecordData erd) {
        super(erd);
        this.numProperties = this.getInstance();
        this.readProperties();
    }

    private void readProperties() {
        this.properties = new ArrayList();
        int pos = 0;
        byte[] bytes = this.getBytes();
        for (int i2 = 0; i2 < this.numProperties; ++i2) {
            int val = IntegerHelper.getInt(bytes[pos], bytes[pos + 1]);
            int id = val & 0x3FFF;
            int value = IntegerHelper.getInt(bytes[pos + 2], bytes[pos + 3], bytes[pos + 4], bytes[pos + 5]);
            Property p2 = new Property(id, (val & 0x4000) != 0, (val & 0x8000) != 0, value);
            pos += 6;
            this.properties.add(p2);
        }
        Iterator i3 = this.properties.iterator();
        while (i3.hasNext()) {
            Property p3 = (Property)i3.next();
            if (!p3.complex) continue;
            p3.stringValue = StringHelper.getUnicodeString(bytes, p3.value / 2, pos);
            pos += p3.value;
        }
    }

    public Opt() {
        super(EscherRecordType.OPT);
        this.properties = new ArrayList();
        this.setVersion(3);
    }

    byte[] getData() {
        Property p2;
        this.numProperties = this.properties.size();
        this.setInstance(this.numProperties);
        this.data = new byte[this.numProperties * 6];
        int pos = 0;
        Iterator i2 = this.properties.iterator();
        while (i2.hasNext()) {
            p2 = (Property)i2.next();
            int val = p2.id & 0x3FFF;
            if (p2.blipId) {
                val |= 0x4000;
            }
            if (p2.complex) {
                val |= 0x8000;
            }
            IntegerHelper.getTwoBytes(val, this.data, pos);
            IntegerHelper.getFourBytes(p2.value, this.data, pos + 2);
            pos += 6;
        }
        i2 = this.properties.iterator();
        while (i2.hasNext()) {
            p2 = (Property)i2.next();
            if (!p2.complex || p2.stringValue == null) continue;
            byte[] newData = new byte[this.data.length + p2.stringValue.length() * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            StringHelper.getUnicodeBytes(p2.stringValue, newData, this.data.length);
            this.data = newData;
        }
        return this.setHeaderData(this.data);
    }

    void addProperty(int id, boolean blip, boolean complex, int val) {
        Property p2 = new Property(id, blip, complex, val);
        this.properties.add(p2);
    }

    void addProperty(int id, boolean blip, boolean complex, int val, String s2) {
        Property p2 = new Property(id, blip, complex, val, s2);
        this.properties.add(p2);
    }

    Property getProperty(int id) {
        boolean found = false;
        Property p2 = null;
        Iterator i2 = this.properties.iterator();
        while (i2.hasNext() && !found) {
            p2 = (Property)i2.next();
            if (p2.id != id) continue;
            found = true;
        }
        return found ? p2 : null;
    }

    static final class Property {
        int id;
        boolean blipId;
        boolean complex;
        int value;
        String stringValue;

        public Property(int i2, boolean bl, boolean co, int v) {
            this.id = i2;
            this.blipId = bl;
            this.complex = co;
            this.value = v;
        }

        public Property(int i2, boolean bl, boolean co, int v, String s2) {
            this.id = i2;
            this.blipId = bl;
            this.complex = co;
            this.value = v;
            this.stringValue = s2;
        }
    }
}

