/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

public class RowRecord
extends RecordData {
    private int rowNumber;
    private int rowHeight;
    private boolean collapsed;
    private boolean zeroHeight;
    private static final int defaultHeightIndicator = 255;

    RowRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.rowNumber = IntegerHelper.getInt(data[0], data[1]);
        this.rowHeight = IntegerHelper.getInt(data[6], data[7]);
        byte opts = data[12];
        this.collapsed = (opts & 0x20) != 0;
    }

    boolean isDefaultHeight() {
        return this.rowHeight == 255;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isZeroHeight() {
        return this.zeroHeight;
    }
}

