/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.NameRecord;

class NameRecord
extends WritableRecordData {
    private byte[] data;
    private String name;
    private int index;
    private NameRange[] ranges;

    public NameRecord(jxl.read.biff.NameRecord sr, int ind) {
        super(Type.NAME);
        this.data = sr.getData();
        this.name = sr.getName();
        this.index = ind;
        NameRecord.NameRange[] r2 = sr.getRanges();
        this.ranges = new NameRange[r2.length];
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            this.ranges[i2] = new NameRange(r2[i2]);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public NameRange[] getRanges() {
        return this.ranges;
    }

    class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int sheetFirst;
        private int sheetLast;

        NameRange(NameRecord.NameRange nr) {
            this.columnFirst = nr.getFirstColumn();
            this.rowFirst = nr.getFirstRow();
            this.columnLast = nr.getLastColumn();
            this.rowLast = nr.getLastRow();
            this.sheetFirst = nr.getFirstSheet();
            this.sheetLast = nr.getLastSheet();
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getFirstSheet() {
            return this.sheetFirst;
        }

        int getLastSheet() {
            return this.sheetLast;
        }
    }
}

