/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.RangeImpl;
import jxl.biff.WorkbookMethods;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.formula.ExternalSheet;
import jxl.format.Colour;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BackupRecord;
import jxl.write.biff.BookboolRecord;
import jxl.write.biff.BoundsheetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.CodepageRecord;
import jxl.write.biff.CountryRecord;
import jxl.write.biff.DSFRecord;
import jxl.write.biff.DateRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.ExternalSheetRecord;
import jxl.write.biff.File;
import jxl.write.biff.FunctionGroupCountRecord;
import jxl.write.biff.HideobjRecord;
import jxl.write.biff.InterfaceEndRecord;
import jxl.write.biff.InterfaceHeaderRecord;
import jxl.write.biff.MMSRecord;
import jxl.write.biff.NameRecord;
import jxl.write.biff.NineteenFourRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrecisionRecord;
import jxl.write.biff.Prot4RevPassRecord;
import jxl.write.biff.Prot4RevRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefreshAllRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SupbookRecord;
import jxl.write.biff.TabIdRecord;
import jxl.write.biff.UsesElfsRecord;
import jxl.write.biff.Window1Record;
import jxl.write.biff.WindowProtectRecord;
import jxl.write.biff.WritableFonts;
import jxl.write.biff.WritableFormattingRecords;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WriteAccessRecord;

public class WritableWorkbookImpl
extends WritableWorkbook
implements ExternalSheet,
WorkbookMethods {
    private FormattingRecords formatRecords;
    private File outputFile;
    private ArrayList sheets;
    private Fonts fonts;
    private ExternalSheetRecord externSheet;
    private SupbookRecord[] supbooks;
    private NameRecord[] names;
    private HashMap nameRecords;
    private SharedStrings sharedStrings;
    private boolean closeStream;
    private boolean wbProtected;
    private WorkbookSettings settings;
    private ArrayList rcirCells;
    private DrawingGroup drawingGroup;

    public WritableWorkbookImpl(OutputStream os, boolean cs, WorkbookSettings ws) throws IOException {
        this.outputFile = new File(os, ws);
        this.sheets = new ArrayList();
        this.sharedStrings = new SharedStrings();
        this.nameRecords = new HashMap();
        this.closeStream = cs;
        this.wbProtected = false;
        this.settings = ws;
        this.rcirCells = new ArrayList();
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.HYPERLINK_FONT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        WritableWorkbook.HYPERLINK_STYLE.uninitialize();
        DateRecord.defaultDateFormat.uninitialize();
        WritableFonts wf = new WritableFonts();
        this.fonts = wf;
        WritableFormattingRecords wfr = new WritableFormattingRecords(this.fonts);
        this.formatRecords = wfr;
    }

    public WritableWorkbookImpl(OutputStream os, Workbook w, boolean cs, WorkbookSettings ws) throws IOException {
        int i2;
        WorkbookParser wp = (WorkbookParser)w;
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.HYPERLINK_FONT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        WritableWorkbook.HYPERLINK_STYLE.uninitialize();
        DateRecord.defaultDateFormat.uninitialize();
        this.outputFile = new File(os, ws);
        this.closeStream = cs;
        this.sheets = new ArrayList();
        this.sharedStrings = new SharedStrings();
        this.nameRecords = new HashMap();
        this.fonts = wp.getFonts();
        this.formatRecords = wp.getFormattingRecords();
        this.wbProtected = false;
        this.settings = ws;
        this.rcirCells = new ArrayList();
        if (wp.getExternalSheetRecord() != null) {
            this.externSheet = new ExternalSheetRecord(wp.getExternalSheetRecord());
            jxl.read.biff.SupbookRecord[] readsr = wp.getSupbookRecords();
            this.supbooks = new SupbookRecord[readsr.length];
            for (i2 = 0; i2 < this.supbooks.length; ++i2) {
                this.supbooks[i2] = new SupbookRecord(readsr[i2]);
            }
        }
        this.drawingGroup = wp.getDrawingGroup();
        if (!this.settings.getNamesDisabled()) {
            jxl.read.biff.NameRecord[] na = wp.getNameRecords();
            this.names = new NameRecord[na.length];
            for (i2 = 0; i2 < na.length; ++i2) {
                this.names[i2] = new NameRecord(na[i2], i2);
                String name = this.names[i2].getName();
                this.nameRecords.put(name, this.names[i2]);
            }
        }
        this.copyWorkbook(w);
    }

    public WritableSheet[] getSheets() {
        WritableSheet[] sheetArray = new WritableSheet[this.getNumberOfSheets()];
        for (int i2 = 0; i2 < this.getNumberOfSheets(); ++i2) {
            sheetArray[i2] = this.getSheet(i2);
        }
        return sheetArray;
    }

    public Sheet getReadSheet(int index) {
        return this.getSheet(index);
    }

    public WritableSheet getSheet(int index) {
        return (WritableSheet)this.sheets.get(index);
    }

    public WritableSheet getSheet(String name) {
        boolean found = false;
        Iterator i2 = this.sheets.iterator();
        WritableSheet s2 = null;
        while (i2.hasNext() && !found) {
            s2 = (WritableSheet)i2.next();
            if (!s2.getName().equals(name)) continue;
            found = true;
        }
        return found ? s2 : null;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() throws IOException {
        this.outputFile.close(this.closeStream);
    }

    private WritableSheet createSheet(String name, int index, boolean handleRefs) {
        WritableSheetImpl w = new WritableSheetImpl(name, this.outputFile, this.formatRecords, this.sharedStrings, this.settings, this);
        int pos = index;
        if (index <= 0) {
            pos = 0;
            this.sheets.add(0, w);
        } else if (index > this.sheets.size()) {
            pos = this.sheets.size();
            this.sheets.add(w);
        } else {
            this.sheets.add(index, w);
        }
        if (handleRefs && this.externSheet != null) {
            this.externSheet.sheetInserted(pos);
        }
        return w;
    }

    public WritableSheet createSheet(String name, int index) {
        return this.createSheet(name, index, true);
    }

    public void removeSheet(int index) {
        int pos = index;
        if (index <= 0) {
            pos = 0;
            this.sheets.remove(0);
        } else if (index >= this.sheets.size()) {
            pos = this.sheets.size() - 1;
            this.sheets.remove(this.sheets.size() - 1);
        } else {
            this.sheets.remove(index);
        }
        if (this.externSheet != null) {
            this.externSheet.sheetRemoved(pos);
        }
    }

    public WritableSheet moveSheet(int fromIndex, int toIndex) {
        fromIndex = Math.max(fromIndex, 0);
        fromIndex = Math.min(fromIndex, this.sheets.size() - 1);
        toIndex = Math.max(toIndex, 0);
        toIndex = Math.min(toIndex, this.sheets.size() - 1);
        WritableSheet sheet = (WritableSheet)this.sheets.remove(fromIndex);
        this.sheets.add(toIndex, sheet);
        return sheet;
    }

    public void write() throws IOException {
        WritableSheetImpl wsi = null;
        for (int i2 = 0; i2 < this.getNumberOfSheets(); ++i2) {
            wsi = (WritableSheetImpl)this.getSheet(i2);
            wsi.checkMergedBorders();
        }
        if (!this.settings.getRationalizationDisabled()) {
            this.rationalize();
        }
        BOFRecord bof = new BOFRecord(BOFRecord.workbookGlobals);
        this.outputFile.write(bof);
        InterfaceHeaderRecord ihr = new InterfaceHeaderRecord();
        this.outputFile.write(ihr);
        MMSRecord mms = new MMSRecord(0, 0);
        this.outputFile.write(mms);
        InterfaceEndRecord ier = new InterfaceEndRecord();
        this.outputFile.write(ier);
        WriteAccessRecord wr = new WriteAccessRecord();
        this.outputFile.write(wr);
        CodepageRecord cp = new CodepageRecord();
        this.outputFile.write(cp);
        DSFRecord dsf = new DSFRecord();
        this.outputFile.write(dsf);
        TabIdRecord tabid = new TabIdRecord(this.getNumberOfSheets());
        this.outputFile.write(tabid);
        FunctionGroupCountRecord fgcr = new FunctionGroupCountRecord();
        this.outputFile.write(fgcr);
        WindowProtectRecord wpr = new WindowProtectRecord(false);
        this.outputFile.write(wpr);
        ProtectRecord pr = new ProtectRecord(this.wbProtected);
        this.outputFile.write(pr);
        PasswordRecord pw = new PasswordRecord(null);
        this.outputFile.write(pw);
        Prot4RevRecord p4r = new Prot4RevRecord(false);
        this.outputFile.write(p4r);
        Prot4RevPassRecord p4rp = new Prot4RevPassRecord();
        this.outputFile.write(p4rp);
        Window1Record w1r = new Window1Record();
        this.outputFile.write(w1r);
        BackupRecord bkr = new BackupRecord(false);
        this.outputFile.write(bkr);
        HideobjRecord ho = new HideobjRecord(false);
        this.outputFile.write(ho);
        NineteenFourRecord nf = new NineteenFourRecord(false);
        this.outputFile.write(nf);
        PrecisionRecord pc = new PrecisionRecord(false);
        this.outputFile.write(pc);
        RefreshAllRecord rar = new RefreshAllRecord(false);
        this.outputFile.write(rar);
        BookboolRecord bb = new BookboolRecord(true);
        this.outputFile.write(bb);
        this.fonts.write(this.outputFile);
        this.formatRecords.write(this.outputFile);
        if (this.formatRecords.getPalette() != null) {
            this.outputFile.write(this.formatRecords.getPalette());
        }
        UsesElfsRecord uer = new UsesElfsRecord();
        this.outputFile.write(uer);
        int[] boundsheetPos = new int[this.getNumberOfSheets()];
        WritableSheet sheet = null;
        for (int i3 = 0; i3 < this.getNumberOfSheets(); ++i3) {
            boundsheetPos[i3] = this.outputFile.getPos();
            sheet = this.getSheet(i3);
            BoundsheetRecord br = new BoundsheetRecord(sheet.getName());
            if (sheet.getSettings().isHidden()) {
                br.setHidden();
            }
            if (((WritableSheetImpl)this.sheets.get(i3)).isChartOnly()) {
                br.setChartOnly();
            }
            this.outputFile.write(br);
        }
        CountryRecord cr = new CountryRecord();
        this.outputFile.write(cr);
        if (this.externSheet != null) {
            for (int i4 = 0; i4 < this.supbooks.length; ++i4) {
                this.outputFile.write(this.supbooks[i4]);
            }
            this.outputFile.write(this.externSheet);
        }
        if (this.names != null) {
            for (int i5 = 0; i5 < this.names.length; ++i5) {
                this.outputFile.write(this.names[i5]);
            }
        }
        if (this.drawingGroup != null) {
            this.drawingGroup.write(this.outputFile);
        }
        this.sharedStrings.write(this.outputFile);
        EOFRecord eof = new EOFRecord();
        this.outputFile.write(eof);
        WritableSheetImpl wsheet = null;
        for (int i6 = 0; i6 < this.getNumberOfSheets(); ++i6) {
            this.outputFile.setData(IntegerHelper.getFourBytes(this.outputFile.getPos()), boundsheetPos[i6] + 4);
            wsheet = (WritableSheetImpl)this.getSheet(i6);
            if (i6 == 0) {
                wsheet.getSettings().setSelected();
            }
            wsheet.write();
        }
    }

    private void copyWorkbook(Workbook w) {
        int numSheets = w.getNumberOfSheets();
        this.wbProtected = w.isProtected();
        Sheet s2 = null;
        WritableSheetImpl ws = null;
        for (int i2 = 0; i2 < numSheets; ++i2) {
            s2 = w.getSheet(i2);
            ws = (WritableSheetImpl)this.createSheet(s2.getName(), i2, false);
            ws.copy(s2);
        }
    }

    public void copySheet(int s2, String name, int index) {
        WritableSheet sheet = this.getSheet(s2);
        WritableSheetImpl ws = (WritableSheetImpl)this.createSheet(name, index);
        ws.copy(sheet);
    }

    public void copySheet(String s2, String name, int index) {
        WritableSheet sheet = this.getSheet(s2);
        WritableSheetImpl ws = (WritableSheetImpl)this.createSheet(name, index);
        ws.copy(sheet);
    }

    public void setProtected(boolean prot) {
        this.wbProtected = prot;
    }

    private void rationalize() {
        IndexMapping fontMapping = this.formatRecords.rationalizeFonts();
        IndexMapping formatMapping = this.formatRecords.rationalizeDisplayFormats();
        IndexMapping xfMapping = this.formatRecords.rationalize(fontMapping, formatMapping);
        WritableSheetImpl wsi = null;
        for (int i2 = 0; i2 < this.sheets.size(); ++i2) {
            wsi = (WritableSheetImpl)this.sheets.get(i2);
            wsi.rationalize(xfMapping, fontMapping, formatMapping);
        }
    }

    public String getExternalSheetName(int index) {
        int lastTab;
        int supbookIndex = this.externSheet.getSupbookIndex(index);
        SupbookRecord sr = this.supbooks[supbookIndex];
        int firstTab = this.externSheet.getFirstTabIndex(index);
        Assert.verify(firstTab == (lastTab = this.externSheet.getLastTabIndex(index)));
        if (sr.getType() == SupbookRecord.INTERNAL) {
            WritableSheet ws = this.getSheet(firstTab);
            return ws.getName();
        }
        if (sr.getType() == SupbookRecord.EXTERNAL) {
            Assert.verify(false);
        }
        return "[UNKNOWN]";
    }

    public jxl.read.biff.BOFRecord getWorkbookBof() {
        return null;
    }

    public int getExternalSheetIndex(int index) {
        if (this.externSheet == null) {
            return index;
        }
        Assert.verify(this.externSheet != null);
        int firstTab = this.externSheet.getFirstTabIndex(index);
        int lastTab = this.externSheet.getLastTabIndex(index);
        Assert.verify(firstTab == lastTab);
        return firstTab;
    }

    public int getExternalSheetIndex(String sheetName) {
        if (this.externSheet == null) {
            this.externSheet = new ExternalSheetRecord();
            this.supbooks = new SupbookRecord[1];
            this.supbooks[0] = new SupbookRecord(this.getNumberOfSheets());
        }
        boolean found = false;
        Iterator i2 = this.sheets.iterator();
        int sheetpos = 0;
        WritableSheetImpl s2 = null;
        while (i2.hasNext() && !found) {
            s2 = (WritableSheetImpl)i2.next();
            if (s2.getName().equals(sheetName)) {
                found = true;
                continue;
            }
            ++sheetpos;
        }
        if (!found) {
            return -1;
        }
        Assert.verify(this.supbooks[0].getType() == SupbookRecord.INTERNAL && this.supbooks[0].getNumberOfSheets() == this.getNumberOfSheets());
        return this.externSheet.getIndex(0, sheetpos);
    }

    public void setColourRGB(Colour c2, int r2, int g2, int b2) {
        this.formatRecords.setColourRGB(c2, r2, g2, b2);
    }

    public String getName(int index) {
        Assert.verify(index >= 0 && index < this.names.length);
        return this.names[index].getName();
    }

    public int getNameIndex(String name) {
        NameRecord nr = (NameRecord)this.nameRecords.get(name);
        return nr != null ? nr.getIndex() : -1;
    }

    void addRCIRCell(CellValue cv) {
        this.rcirCells.add(cv);
    }

    void columnInserted(WritableSheetImpl s2, int col) {
        int externalSheetIndex = this.getExternalSheetIndex(s2.getName());
        Iterator i2 = this.rcirCells.iterator();
        while (i2.hasNext()) {
            CellValue cv = (CellValue)i2.next();
            cv.columnInserted(s2, externalSheetIndex, col);
        }
    }

    void columnRemoved(WritableSheetImpl s2, int col) {
        int externalSheetIndex = this.getExternalSheetIndex(s2.getName());
        Iterator i2 = this.rcirCells.iterator();
        while (i2.hasNext()) {
            CellValue cv = (CellValue)i2.next();
            cv.columnRemoved(s2, externalSheetIndex, col);
        }
    }

    void rowInserted(WritableSheetImpl s2, int row) {
        int externalSheetIndex = this.getExternalSheetIndex(s2.getName());
        Iterator i2 = this.rcirCells.iterator();
        while (i2.hasNext()) {
            CellValue cv = (CellValue)i2.next();
            cv.rowInserted(s2, externalSheetIndex, row);
        }
    }

    void rowRemoved(WritableSheetImpl s2, int row) {
        int externalSheetIndex = this.getExternalSheetIndex(s2.getName());
        Iterator i2 = this.rcirCells.iterator();
        while (i2.hasNext()) {
            CellValue cv = (CellValue)i2.next();
            cv.rowRemoved(s2, externalSheetIndex, row);
        }
    }

    public WritableCell findCellByName(String name) {
        NameRecord nr = (NameRecord)this.nameRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        int sheetIndex = this.getExternalSheetIndex(ranges[0].getFirstSheet());
        WritableSheet s2 = this.getSheet(sheetIndex);
        WritableCell cell = s2.getWritableCell(ranges[0].getFirstColumn(), ranges[0].getFirstRow());
        return cell;
    }

    public Range[] findByName(String name) {
        NameRecord nr = (NameRecord)this.nameRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        Range[] cellRanges = new Range[ranges.length];
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            cellRanges[i2] = new RangeImpl(this, this, ranges[i2].getFirstSheet(), ranges[i2].getFirstColumn(), ranges[i2].getFirstRow(), ranges[i2].getLastSheet(), ranges[i2].getLastColumn(), ranges[i2].getLastRow());
        }
        return cellRanges;
    }

    void addDrawing(Drawing d2) {
        if (this.drawingGroup == null) {
            this.drawingGroup = new DrawingGroup(DrawingGroup.WRITE);
        }
        this.drawingGroup.add(d2);
    }

    void removeDrawing(Drawing d2) {
        Assert.verify(this.drawingGroup != null);
        this.drawingGroup.remove(d2);
    }

    DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }
}

