/*
 * Decompiled with CFR 0.152.
 */
package org.zgf.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.zgf.dao.IBaseDao;
import org.zgf.model.ColumnModel;
import org.zgf.util.DbUtil;

public class BaseDao
implements IBaseDao {
    @Override
    public List<String> getUserTableNames() {
        String sql = "select table_name from user_tables order by table_name";
        return DbUtil.queryList(sql, new Object[0]);
    }

    @Override
    public List<String> getUserSequences() {
        String sql = "select t.sequence_name from user_sequences t order by t.sequence_name";
        return DbUtil.queryList(sql, new Object[0]);
    }

    @Override
    public List<ColumnModel> getColumnModelList(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select uc.COLUMN_NAME, uc.DATA_TYPE,uc.DATA_PRECISION, uc.DATA_SCALE, uc.NULLABLE, uc.DATA_DEFAULT, uc.CHAR_LENGTH ,uct.comments ");
        sb.append("from user_tab_columns uc ");
        sb.append("join user_col_comments uct ");
        sb.append("on uc.COLUMN_NAME = uct.column_name and uc.TABLE_NAME = uct.table_name ");
        sb.append("where uc.TABLE_NAME = ? order by uc.COLUMN_ID ");
        ResultSet rs = DbUtil.excuteQuery(sb.toString(), tableName);
        try {
            ArrayList<ColumnModel> columnList = new ArrayList<ColumnModel>();
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                String type = rs.getString("DATA_TYPE");
                String defaultValue = rs.getString("DATA_DEFAULT");
                String comments = rs.getString("comments");
                Integer intLength = rs.getInt("DATA_PRECISION");
                Integer decimalLength = rs.getInt("DATA_SCALE");
                Integer charLength = rs.getInt("CHAR_LENGTH");
                boolean nullAble = "Y".equals(rs.getString("NULLABLE"));
                name = name != null ? name : "";
                type = type != null ? type : "";
                defaultValue = defaultValue != null ? defaultValue : "**";
                comments = comments != null ? comments : "";
                intLength = intLength != null ? intLength : 0;
                decimalLength = decimalLength != null ? decimalLength : 0;
                charLength = charLength != null ? charLength : 0;
                ColumnModel columnModel = new ColumnModel(name, type, nullAble, charLength, intLength, decimalLength, defaultValue, comments, name.toLowerCase());
                columnList.add(columnModel);
            }
            return columnList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getPrimaryKeyName(String tableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ucc.COLUMN_NAME ");
        sb.append("from user_cons_columns ucc, user_constraints uc ");
        sb.append("where ucc.constraint_name = uc.constraint_name  and uc.constraint_type = 'P' ");
        sb.append("and ucc.table_name = ?");
        List<String> results = DbUtil.queryList(sb.toString(), tableName);
        return results;
    }

    @Override
    public String getSequenceIncrementBy(String sequenceName) {
        String sql = "select t.increment_by from user_sequences t where t.sequence_name = ?";
        List<String> list = DbUtil.queryList(sql, sequenceName);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

