/*
 * Decompiled with CFR 0.152.
 */
package org.zgf.jframe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.zgf.dao.BaseDao;
import org.zgf.jframe.PropertyFrame;
import org.zgf.model.DefaultConfig;

public class TableFrame
extends JFrame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private DefaultListModel<String> tableNameLM = new DefaultListModel();
    private DefaultListModel<String> sequenceNameLM = new DefaultListModel();
    private JTextField tableNameEdTxt;
    private JTextField sequenceNameEdTxt;
    private JList tableNameJL;
    private JList sequenceNameJL;

    private void initListModel() {
        BaseDao baseDao = new BaseDao();
        List<String> tableNameList = baseDao.getUserTableNames();
        for (String tableName : tableNameList) {
            this.tableNameLM.addElement(tableName);
        }
        List<String> sequenceNameList = baseDao.getUserSequences();
        for (String sequenceName : sequenceNameList) {
            this.sequenceNameLM.addElement(sequenceName);
        }
        this.tableNameJL.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectTableName = (String)TableFrame.this.tableNameJL.getSelectedValue();
                TableFrame.this.tableNameEdTxt.setText(selectTableName);
            }
        });
        this.sequenceNameJL.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectSequenceName = (String)TableFrame.this.sequenceNameJL.getSelectedValue();
                TableFrame.this.sequenceNameEdTxt.setText(selectSequenceName);
            }
        });
    }

    public TableFrame() {
        this.setTitle("\u9009\u62e9\u8868\u548c\u7d22\u5f15");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 1003, 507);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        this.contentPane.add((Component)splitPane, "Center");
        JScrollPane tableNameSp = new JScrollPane();
        splitPane.setLeftComponent(tableNameSp);
        JLabel lblNewLabel = new JLabel("\u8868\u540d\u79f0\u5217\u8868");
        lblNewLabel.setFont(new Font("\u6977\u4f53", 0, 14));
        lblNewLabel.setForeground(Color.BLUE);
        lblNewLabel.setBackground(Color.GRAY);
        tableNameSp.setColumnHeaderView(lblNewLabel);
        this.tableNameJL = new JList<String>(this.tableNameLM);
        tableNameSp.setViewportView(this.tableNameJL);
        JScrollPane sequenceSp = new JScrollPane();
        splitPane.setRightComponent(sequenceSp);
        JLabel label = new JLabel("\u5e8f\u5217\u540d\u79f0\u5217\u8868");
        label.setFont(new Font("\u6977\u4f53", 0, 14));
        label.setForeground(Color.BLUE);
        label.setBackground(Color.RED);
        sequenceSp.setColumnHeaderView(label);
        this.sequenceNameJL = new JList<String>(this.sequenceNameLM);
        sequenceSp.setViewportView(this.sequenceNameJL);
        JPanel topPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)topPanel.getLayout();
        flowLayout.setVgap(30);
        this.contentPane.add((Component)topPanel, "North");
        JPanel panel = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)panel.getLayout();
        flowLayout_1.setVgap(10);
        flowLayout_1.setHgap(40);
        topPanel.add(panel);
        JLabel label_1 = new JLabel("\u8868\u540d\u79f0:");
        panel.add(label_1);
        this.tableNameEdTxt = new JTextField();
        panel.add(this.tableNameEdTxt);
        this.tableNameEdTxt.setColumns(30);
        JLabel label_2 = new JLabel("\u5e8f\u5217\u540d\u79f0:");
        panel.add(label_2);
        this.sequenceNameEdTxt = new JTextField();
        this.sequenceNameEdTxt.setColumns(30);
        panel.add(this.sequenceNameEdTxt);
        JButton btnNewButton = new JButton("\u751f\u6210POVO");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tableName = TableFrame.this.tableNameEdTxt.getText().trim();
                String sequenceName = TableFrame.this.sequenceNameEdTxt.getText().trim();
                if (tableName == null || "".equals(tableName)) {
                    JOptionPane.showMessageDialog(null, "~\u8bf7\u9009\u62e9\u8868\u540d\u79f0~", "\u6e29\u99a8\u63d0\u9192", 1);
                    return;
                }
                if (sequenceName == null || "".equals(sequenceName)) {
                    JOptionPane.showMessageDialog(null, "~\u8bf7\u9009\u62e9\u5e8f\u5217~", "\u6e29\u99a8\u63d0\u9192", 1);
                    return;
                }
                BaseDao baseDao = new BaseDao();
                List<String> primaryKeys = baseDao.getPrimaryKeyName(tableName);
                if (primaryKeys != null) {
                    if (primaryKeys.size() == 1) {
                        new PropertyFrame(tableName, sequenceName, primaryKeys.get(0)).setVisible(true);
                    } else if (primaryKeys.size() > 1 && DefaultConfig.hasJPA) {
                        JOptionPane.showMessageDialog(null, "\u6b64\u5de5\u5177\u4e0d\u9002\u7528\u4e8e\u5bf9\u8054\u5408\u4e3b\u952e\u7684\u8868\u751f\u6210JPA\u5b9e\u4f53", "\u6e29\u99a8\u63d0\u9192", 0);
                    } else {
                        if (primaryKeys.size() == 0) {
                            JOptionPane.showMessageDialog(null, "\u8868\uff1a" + tableName + " \u76ee\u524d\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5", "\u6e29\u99a8\u63d0\u9192", 1);
                        }
                        new PropertyFrame(tableName, sequenceName, null).setVisible(true);
                    }
                }
            }
        });
        panel.add(btnNewButton);
        this.initListModel();
    }
}

