/*
 * Decompiled with CFR 0.152.
 */
package org.zgf.model;

public class ColumnModel {
    private String name;
    private String type;
    private boolean nullAble;
    private Integer charLength;
    private Integer intLength;
    private Integer decimalLength;
    private String defaultValue;
    private String comment;
    private String javaType = "String";
    private String javaFieldName;
    private boolean timeStamp = false;
    private boolean primaryKey;

    public ColumnModel() {
    }

    public ColumnModel(String name, String type, boolean nullAble, Integer charLength, Integer intLength, Integer decimalLength, String defaultValue, String comment, String javaFieldName) {
        this.name = name;
        this.type = type;
        this.nullAble = nullAble;
        this.charLength = charLength;
        this.intLength = intLength;
        this.decimalLength = decimalLength;
        this.defaultValue = defaultValue;
        this.comment = comment;
        this.javaFieldName = javaFieldName;
        if (this.type != null) {
            if ("DATE".equalsIgnoreCase(this.type)) {
                this.javaType = "Date";
            } else if ("TIMESTAMP(6)".equalsIgnoreCase(this.type)) {
                this.javaType = "Date";
                this.timeStamp = true;
            } else if ("NUMBER".equalsIgnoreCase(this.type)) {
                if (this.decimalLength > 0) {
                    this.javaType = "Double";
                    this.type = "NUMBER(" + this.intLength + ", " + this.decimalLength + ")";
                } else {
                    this.javaType = "Long";
                    this.type = "NUMBER(" + this.intLength + ")";
                }
            } else if ("CHAR".equalsIgnoreCase(this.type) || "VARCHAR2".equalsIgnoreCase(this.type) || "NVARCHAR2".equalsIgnoreCase(this.type)) {
                this.type = String.valueOf(this.type) + "(" + this.charLength + ")";
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean getNullAble() {
        return this.nullAble;
    }

    public void setNullAble(boolean nullAble) {
        this.nullAble = nullAble;
    }

    public Integer getCharLength() {
        return this.charLength;
    }

    public void setCharLength(Integer charLength) {
        this.charLength = charLength;
    }

    public Integer getIntLength() {
        return this.intLength;
    }

    public void setIntLength(Integer intLength) {
        this.intLength = intLength;
    }

    public Integer getDecimalLength() {
        return this.decimalLength;
    }

    public void setDecimalLength(Integer decimalLength) {
        this.decimalLength = decimalLength;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public boolean isTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(boolean timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getJavaFieldName() {
        return this.javaFieldName;
    }

    public void setJavaFieldName(String javaFieldName) {
        this.javaFieldName = javaFieldName;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        return "ColumnModel [name=" + this.name + ", type=" + this.type + ", nullAble=" + this.nullAble + ", charLength=" + this.charLength + ", intLength=" + this.intLength + ", decimalLength=" + this.decimalLength + ", defaultValue=" + this.defaultValue + ", comment=" + this.comment + ", javaType=" + this.javaType + ", javaFieldName=" + this.javaFieldName + "]";
    }
}

