/*
 * Decompiled with CFR 0.152.
 */
package org.zgf.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.zgf.exception.BizException;
import org.zgf.model.DefaultConfig;

public class DbUtil {
    private static Connection conn;

    public static Connection connect(String ipAddress, Integer port, String serviceName, String username, String password) {
        String url = "jdbc:oracle:thin:@" + ipAddress + ":" + port + ":" + serviceName;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            Connection conn = DriverManager.getConnection(url, username, password);
            return conn;
        }
        catch (ClassNotFoundException ex) {
            throw new BizException("", ex);
        }
        catch (SQLException ex) {
            int errorCode = ex.getErrorCode();
            if (errorCode == 1017) {
                throw new BizException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e", ex);
            }
            if (errorCode == 0) {
                throw new BizException("\u670d\u52a1\u540d\u4e0d\u5b58\u5728", ex);
            }
            if (errorCode == 17002) {
                throw new BizException("\u7f51\u8def\u5f02\u5e38\u6216ip\u548c\u7aef\u53e3\u53f7\u4e0d\u6b63\u786e", ex);
            }
            throw new BizException("\u7f51\u8def\u8fde\u63a5\u8d85\u65f6,\u8bf7\u91cd\u65b0\u8fde\u63a5", ex);
        }
    }

    public static void testConnection(String ipAddress, Integer port, String serviceName, String username, String password) {
        Connection conn = null;
        try {
            conn = DbUtil.connect(ipAddress, port, serviceName, username, password);
        }
        catch (Throwable throwable) {
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeConnection(conn);
    }

    public static void doConnection(String ipAddress, Integer port, String serviceName, String username, String password) {
        conn = DbUtil.connect(ipAddress, port, serviceName, username, password);
    }

    public static ResultSet excuteQuery(String sql, Object ... params) {
        try {
            if (conn == null || conn.isClosed()) {
                conn = DbUtil.connect(DefaultConfig.ipAddress, DefaultConfig.port, DefaultConfig.serviceName, DefaultConfig.username, DefaultConfig.password);
            }
            PreparedStatement pstmt = conn.prepareStatement(sql);
            int index = 1;
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object param = objectArray[n2];
                pstmt.setObject(index++, param);
                ++n2;
            }
            return pstmt.executeQuery();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static List<String> queryList(String sql, Object ... params) {
        try {
            ResultSet rs = DbUtil.excuteQuery(sql, params);
            ArrayList<String> rsList = new ArrayList<String>();
            while (rs.next()) {
                rsList.add(rs.getString(1));
            }
            return rsList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

