/*
 * Decompiled with CFR 0.152.
 */
package org.zgf.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.zgf.exception.BizException;
import org.zgf.model.ColumnModel;
import org.zgf.model.ConfigVO;
import org.zgf.model.DefaultConfig;

public class PojoUtil {
    private static Configuration cfgConfig;
    private static String TEMPLATEFILENAME;
    private static Template voTemplate;
    private static Template poTemplate;
    private static String voFtl;
    private static String poFtl;

    static {
        TEMPLATEFILENAME = "lib";
        voFtl = "vo.ftl";
        poFtl = "po.ftl";
        try {
            Configuration cfgConfig = new Configuration(Configuration.VERSION_2_3_22);
            cfgConfig.setDirectoryForTemplateLoading(new File(TEMPLATEFILENAME));
            cfgConfig.setDefaultEncoding("UTF-8");
            cfgConfig.setNumberFormat("####");
            voTemplate = cfgConfig.getTemplate(voFtl);
            poTemplate = cfgConfig.getTemplate(poFtl);
        }
        catch (Exception ex) {
            System.out.println("Freemarker \u5f15\u64ce\u521d\u59cb\u5316\u9519\u8bef  ");
            ex.printStackTrace();
        }
    }

    public static String createPOJO(ConfigVO configVO, List<ColumnModel> dataList, List<String> packageList, String pojoName, Template template) {
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("hasJPA", DefaultConfig.hasJPA);
            root.put("hasValidator", DefaultConfig.hasValidator);
            root.put("hasDocumentHelper", DefaultConfig.hasDocumentHelper);
            root.put("hasToString", DefaultConfig.hasToString);
            root.put("implementSerializabel", DefaultConfig.implementSerializabel);
            root.put("configVO", configVO);
            root.put("packageList", packageList);
            root.put("dataList", dataList);
            pojoName = String.valueOf(pojoName.substring(0, 1).toUpperCase()) + pojoName.substring(1);
            String fileName = String.valueOf(pojoName) + ".java";
            File file = new File(fileName);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            template.process(root, osw);
            osw.flush();
            osw.close();
            return fileName;
        }
        catch (Exception ex) {
            throw new BizException("\u751f\u6210\u6587\u4ef6\u9519\u8bef\uff01", ex);
        }
    }

    public static void createVO(ConfigVO configVO, List<ColumnModel> dataList) {
        HashSet<String> pgSet = new HashSet<String>();
        if (DefaultConfig.implementSerializabel) {
            pgSet.add("java.io.Serializable");
        }
        for (ColumnModel cm : dataList) {
            if (!"Date".equals(cm.getJavaType())) continue;
            pgSet.add("java.util.Date");
        }
        if (DefaultConfig.hasValidator) {
            pgSet.add("javax.validation.Valid");
        }
        if (configVO.getPoPackage() != null && configVO.getVoPackage() != null && !configVO.getPoName().trim().equals(configVO.getVoName().trim())) {
            pgSet.add(String.valueOf(configVO.getPoPackage()) + "." + configVO.getPoName());
        }
        ArrayList<String> packageList = new ArrayList<String>(pgSet);
        Collections.sort(packageList);
        PojoUtil.createPOJO(configVO, dataList, packageList, configVO.getVoName(), voTemplate);
    }

    public static void createPO(ConfigVO configVO, List<ColumnModel> dataList) {
        if (configVO.getPrimaryKeyName() != null && !"".equals(configVO.getPrimaryKeyName())) {
            for (ColumnModel cm : dataList) {
                if (!configVO.getPrimaryKeyName().equalsIgnoreCase(cm.getName())) continue;
                configVO.setPrimaryKeyName(cm.getJavaFieldName());
            }
        }
        HashSet<String> pgSet = new HashSet<String>();
        for (ColumnModel cm : dataList) {
            if (DefaultConfig.implementSerializabel) {
                pgSet.add("java.io.Serializable");
            }
            if (DefaultConfig.hasDocumentHelper) {
                pgSet.add(DefaultConfig.documentHelper);
            }
            if (DefaultConfig.hasJPA) {
                pgSet.add("javax.persistence.Entity");
                pgSet.add("javax.persistence.Table");
                if ("Date".equals(cm.getJavaType())) {
                    pgSet.add("javax.persistence.Temporal");
                    pgSet.add("javax.persistence.TemporalType");
                }
                if (configVO.getPrimaryKeyName() != null && !"".equals(configVO.getPrimaryKeyName().trim())) {
                    pgSet.add("javax.persistence.Id");
                    pgSet.add("javax.persistence.GeneratedValue");
                    pgSet.add("javax.persistence.GenerationType");
                    pgSet.add("javax.persistence.SequenceGenerator");
                }
            }
            if (DefaultConfig.hasValidator) {
                if ("String".equals(cm.getJavaType())) {
                    pgSet.add("org.hibernate.validator.constraints.Length");
                    if (!cm.getNullAble()) {
                        pgSet.add("org.hibernate.validator.constraints.NotEmpty");
                    }
                } else if (configVO.getPrimaryKeyName() != null && !configVO.getPrimaryKeyName().equals(cm.getJavaFieldName()) && !cm.getNullAble()) {
                    System.out.println(!configVO.getPrimaryKeyName().equals(cm.getName()));
                    pgSet.add("javax.validation.constraints.NotNull");
                }
            }
            if (!"Date".equals(cm.getJavaType())) continue;
            pgSet.add("java.util.Date");
        }
        ArrayList<String> packageList = new ArrayList<String>(pgSet);
        Collections.sort(packageList);
        PojoUtil.createPOJO(configVO, dataList, packageList, configVO.getPoName(), poTemplate);
    }

    public static String createPOVO(ConfigVO configVO, List<ColumnModel> dataList) {
        StringBuffer resultBuffer = new StringBuffer();
        try {
            PojoUtil.createPO(configVO, dataList);
            resultBuffer.append("PO \u751f\u6210\u6210\u529f\uff01");
        }
        catch (BizException ex) {
            resultBuffer.append(ex.getMessage());
        }
        if (DefaultConfig.createVO) {
            try {
                PojoUtil.createVO(configVO, dataList);
                resultBuffer.append("VO \u751f\u6210\u6210\u529f\uff01");
            }
            catch (BizException ex) {
                resultBuffer.append("VO \u751f\u6210\u5931\u8d25\uff1a" + ex.getMessage() + "!");
            }
        }
        return resultBuffer.toString();
    }
}

