package ${configVO.voPackage};

<#list packageList as pgName>
import ${pgName};
</#list>

public class ${configVO.voName?cap_first} <#if implementSerializabel>implements Serializable</#if> {
	<#-- 获取主键名称  -->
	<#if configVO.primaryKeyName??>
		<#assign primaryKey = configVO.primaryKeyName>
	<#else>
		<#assign primaryKey = ''>
	</#if>
	<#-- 如果实现了Serializable 接口，那么自动生成 serialVersionUID -->
	<#if implementSerializabel>
	
	private static final long serialVersionUID = 1L;
	</#if>

	@Valid
	private ${configVO.poName?cap_first} ${configVO.poName?uncap_first};
	
	public ${configVO.voName?cap_first}() {
		super();
	}
	
	public ${configVO.voName?cap_first}(${configVO.poName?cap_first} ${configVO.poName?uncap_first}) {
		if (null != ${configVO.poName?uncap_first}) {
			this.${configVO.poName?uncap_first} = ${configVO.poName?uncap_first};
		}
	}
	
	<#-- 生成主键的set/get方法  -->
	<#if primaryKey != '' >
	public void set${primaryKey?cap_first}(Long ${primaryKey?uncap_first}){
		this.${configVO.poName?uncap_first}.set${primaryKey?cap_first}(${primaryKey?uncap_first});
	}
	
	public Long get${primaryKey?cap_first}(){
		return this.${configVO.poName?uncap_first}.get${primaryKey?cap_first}();
	}
	</#if>
	<#-- 自动生成属性的 setter/getter 方法  -->
	<#list dataList as item>
	
		<#if item.javaFieldName != primaryKey>
			<#if item.javaType =="boolean">
	public ${item.javaType} is${item.javaFieldName?cap_first}() {
		return this.${configVO.poName?uncap_first}.is${item.javaFieldName?cap_first}();
	}
			<#else>
	public ${item.javaType} get${item.javaFieldName?cap_first}() {
		return this.${configVO.poName?uncap_first}.get${item.javaFieldName?cap_first}();
	}
			</#if>
	
	public void set${item.javaFieldName?cap_first}(${item.javaType} ${item.javaFieldName?uncap_first}) {
		this.${configVO.poName?uncap_first}.set${item.javaFieldName?cap_first}(${item.javaFieldName?uncap_first});
	}
		</#if>
	</#list>
	
	public ${configVO.poName?cap_first} to${configVO.poName?cap_first}() {
		return this.${configVO.poName?uncap_first};
	}
	
}