package ${configVO.poPackage};

<#list packageList as pgName>
import ${pgName};
</#list>

<#if hasJPA>
@Entity
@Table(name="${configVO.tableName}")
</#if>
public class ${configVO.poName?cap_first} <#if implementSerializabel>implements Serializable</#if> {
	<#-- 获取主键名称  -->
	<#if configVO.primaryKeyName??>
		<#assign primaryKey = configVO.primaryKeyName>
	<#else>
		<#assign primaryKey = ''>
	</#if>
	<#-- 如果实现了Serializable 接口，那么自动生成 serialVersionUID -->
	<#if implementSerializabel>
	
	private static final long serialVersionUID = 1L;
	</#if>
	
	<#-- 判断主键  -->
	<#if primaryKey != '' >
		<#if hasJPA>
	@Id
	@SequenceGenerator(name="${configVO.sequenceName}_GENERATOR",sequenceName="${configVO.sequenceName}",allocationSize=${configVO.sequenceIncrementBy} )
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="${configVO.sequenceName}_GENERATOR")
	@DocumentHelper(documentation="主键ID",example="0")
		</#if>
	private Long ${primaryKey?uncap_first};
	</#if>
	<#-- 遍历非主键字段  -->
	<#list dataList as item>
	
		<#--遍历非主键 字段 -->
		<#if item.javaFieldName != primaryKey>
			<#-- 判断添加 documentHelper 注解 -->
			<#if hasDocumentHelper>
	@DocumentHelper(documentation="${item.comment}",example="")
			</#if>
			<#-- 判断类型，添加合适的validtor 注解 -->
			<#if hasValidator>
				<#if item.javaType == "String">
					<#if !item.nullAble>
	@NotEmpty(message="${item.comment} 不能为空")
					</#if>
	@Length(max=${item.charLength}, message="${item.comment} 长度最多${item.charLength}个字符")
				<#else>
					<#if !item.nullAble>
	@NotNull(message="${item.comment} 不能为空")
					</#if>				
				</#if>
			</#if>
			<#-- 判断添加JPA 注解   -->
			<#if hasJPA>
				<#if item.javaType == "Date">
					<#if item.timeStamp>
	@Temporal(TemporalType.TIMESTAMP)
					<#else>
	@Temporal(TemporalType.DATE)	
					</#if>
				</#if>
			</#if>
	private ${item.javaType} ${item.javaFieldName};	
		</#if>
	</#list>
	
	<#-- 生成主键的set/get方法  -->
	<#if primaryKey != '' >
	public void set${primaryKey?cap_first}(Long ${primaryKey?uncap_first}){
		this.${primaryKey?uncap_first} = ${primaryKey?uncap_first};
	}
	public Long get${primaryKey?cap_first}(){
		return this.${primaryKey?uncap_first};
	}
	</#if>
	
	<#-- 自动生成属性的 setter/getter 方法  -->
	<#list dataList as item>
		<#if item.javaFieldName != primaryKey>
			<#if item.javaType =="boolean">
	public ${item.javaType} is${item.javaFieldName?cap_first}() {
		return this.${item.javaFieldName?uncap_first};
	}
			<#else>
	public ${item.javaType} get${item.javaFieldName?cap_first}() {
		return this.${item.javaFieldName?uncap_first};
	}
			</#if>
	
	public void set${item.javaFieldName?cap_first}(${item.javaType} ${item.javaFieldName?uncap_first}) {
		this.${item.javaFieldName} = ${item.javaFieldName?uncap_first};
	}
		</#if>
	</#list>
	
	<#if hasToString>
	<#-- 自动生成toString()方法  -->
	@Override
	public String toString() {
		return "${configVO.poName?cap_first} [<#if  primaryKey != ''>primary=" + ${primaryKey?uncap_first} + ", </#if><#list dataList as item><#if item.javaFieldName != primaryKey>${item.javaFieldName}=" + ${item.javaFieldName} + ", </#if></#list>]";
	}
	</#if>
}

