﻿using UnityEngine;

public class LevelProperties : MonoBehaviour {
    [Tooltip("Comma-separated list of actions and their priorities. If empty, defaults to \"push,enter,eat,possess\".")]
    public string AttemptOrder;
    public bool ShedEnabled;
    public bool InnerPushEnabled;

    public enum DS {
        normal,
        tui,
        grid,
        oldstyle,
    }
    public DS DrawStyle;

    [Tooltip("-1 for no music")]
    [Range(-1,19)]
    public int CustomLevelMusic = -1;

    [Tooltip("-1 to not apply any palette")]
    [Range(-1,9)]
    public int CustomLevelPalette = -1;
}
