/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.payment;

import java.util.HashMap;

public abstract class PaymentService {
    protected static final int HIGHEST_TIER = 3;
    protected static final String SKU_SILV = "donation_silver";
    protected static final String SKU_GOLD = "donation_gold";
    protected static final String SKU_GOLD_FROM_SILV = "upgrade_donation_gold_from_silver";
    protected static final String SKU_SHATT = "donation_shattered";
    protected static final String SKU_SHATT_FROM_SILV = "upgrade_donation_shattered_from_silver";
    protected static final String SKU_SHATT_FROM_GOLD = "upgrade_donation_shattered_from_gold";
    protected static final HashMap<String, Integer> skuTiers = new HashMap();
    protected final HashMap<Integer, PurchaseState> tierStates = new HashMap();

    public PaymentService() {
        this.clearTierStates();
    }

    protected void clearTierStates() {
        this.tierStates.put(1, PurchaseState.NOT_PURCHASED);
        this.tierStates.put(2, PurchaseState.NOT_PURCHASED);
        this.tierStates.put(3, PurchaseState.NOT_PURCHASED);
    }

    public PurchaseState getPurchaseState(int tier) {
        if (!this.tierStates.containsKey(tier)) {
            return PurchaseState.NOT_PURCHASED;
        }
        return this.tierStates.get(tier);
    }

    public abstract void updatePurchaseStates(RefreshCallback var1);

    public abstract boolean areSKUsLoaded();

    public abstract void loadSKUDetails(RefreshCallback var1);

    public abstract boolean supportsIAP();

    public abstract String getTierPrice(int var1);

    public abstract void initiatePurchase(int var1, RefreshCallback var2);

    static {
        skuTiers.put(SKU_SILV, 1);
        skuTiers.put(SKU_GOLD, 2);
        skuTiers.put(SKU_GOLD_FROM_SILV, 2);
        skuTiers.put(SKU_SHATT, 3);
        skuTiers.put(SKU_SHATT_FROM_SILV, 3);
        skuTiers.put(SKU_SHATT_FROM_GOLD, 3);
    }

    public static abstract class RefreshCallback {
        public abstract void onSuccess();

        public abstract void onFail();
    }

    public static enum PurchaseState {
        NOT_PURCHASED,
        PENDING,
        PURCHASED;

    }
}

