/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

abstract class AbstractController
implements Disposable,
Controller {
    private final Array<ControllerListener> listeners = new Array();
    private boolean connected = true;

    AbstractController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.clear();
        }
        this.connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersButtonUp(int button) {
        ControllerListener listener;
        Array.ArrayIterator arrayIterator;
        Array<ControllerListener> managerListeners;
        Array<ControllerListener> array = managerListeners = Controllers.getListeners();
        synchronized (array) {
            arrayIterator = managerListeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).buttonUp(this, button)) {
            }
        }
        array = this.listeners;
        synchronized (array) {
            arrayIterator = this.listeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).buttonUp(this, button)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersButtonDown(int button) {
        ControllerListener listener;
        Array.ArrayIterator arrayIterator;
        Array<ControllerListener> managerListeners;
        Array<ControllerListener> array = managerListeners = Controllers.getListeners();
        synchronized (array) {
            arrayIterator = managerListeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).buttonDown(this, button)) {
            }
        }
        array = this.listeners;
        synchronized (array) {
            arrayIterator = this.listeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).buttonDown(this, button)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersAxisMoved(int axisNum, float value) {
        ControllerListener listener;
        Array.ArrayIterator arrayIterator;
        Array<ControllerListener> managerListeners;
        Array<ControllerListener> array = managerListeners = Controllers.getListeners();
        synchronized (array) {
            arrayIterator = managerListeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).axisMoved(this, axisNum, value)) {
            }
        }
        array = this.listeners;
        synchronized (array) {
            arrayIterator = this.listeners.iterator();
            while (arrayIterator.hasNext() && !(listener = (ControllerListener)arrayIterator.next()).axisMoved(this, axisNum, value)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ControllerListener controllerListener) {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            if (!this.listeners.contains((Object)controllerListener, true)) {
                this.listeners.add((Object)controllerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ControllerListener controllerListener) {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.removeValue((Object)controllerListener, true);
        }
    }

    @Override
    public boolean canVibrate() {
        return false;
    }

    @Override
    public boolean isVibrating() {
        return false;
    }

    @Override
    public void startVibration(int duration, float strength) {
    }

    @Override
    public void cancelVibration() {
    }

    @Override
    public boolean supportsPlayerIndex() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getPlayerIndex() {
        return -1;
    }

    @Override
    public void setPlayerIndex(int index) {
    }
}

