/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.QuickSlot;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Amok;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Awareness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Light;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicalSight;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MindVision;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.huntress.SpiritHawk;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Blacksmith;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Ghost;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Imp;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Wandmaker;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfRegrowth;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfWarding;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.levels.CavesBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CavesLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.DeadEndLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.HallsBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.HallsLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.LastLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.PrisonBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.PrisonLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.SewerBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.SewerLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret.SecretRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.DungeonSeed;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndResurrect;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import com.watabou.utils.SparseArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class Dungeon {
    public static int challenges;
    public static int mobsToChampion;
    public static Hero hero;
    public static Level level;
    public static QuickSlot quickslot;
    public static int depth;
    public static int gold;
    public static int energy;
    public static HashSet<Integer> chapters;
    public static SparseArray<ArrayList<Item>> droppedItems;
    public static SparseArray<ArrayList<Item>> portedItems;
    public static int version;
    public static long seed;
    private static final String VERSION = "version";
    private static final String SEED = "seed";
    private static final String CHALLENGES = "challenges";
    private static final String MOBS_TO_CHAMPION = "mobs_to_champion";
    private static final String HERO = "hero";
    private static final String DEPTH = "depth";
    private static final String GOLD = "gold";
    private static final String ENERGY = "energy";
    private static final String DROPPED = "dropped%d";
    private static final String PORTED = "ported%d";
    private static final String LEVEL = "level";
    private static final String LIMDROPS = "limited_drops";
    private static final String CHAPTERS = "chapters";
    private static final String QUESTS = "quests";
    private static final String BADGES = "badges";
    private static boolean[] passable;

    public static void init() {
        version = Game.versionCode;
        challenges = SPDSettings.challenges();
        mobsToChampion = -1;
        seed = DungeonSeed.randomSeed();
        Actor.clear();
        Actor.resetNextID();
        Random.pushGenerator((long)seed);
        Scroll.initLabels();
        Potion.initColors();
        Ring.initGems();
        SpecialRoom.initForRun();
        SecretRoom.initForRun();
        Random.resetGenerators();
        Statistics.reset();
        Notes.reset();
        quickslot.reset();
        QuickSlotButton.reset();
        depth = 0;
        gold = 0;
        energy = 0;
        droppedItems = new SparseArray();
        portedItems = new SparseArray();
        LimitedDrops.reset();
        chapters = new HashSet();
        Ghost.Quest.reset();
        Wandmaker.Quest.reset();
        Blacksmith.Quest.reset();
        Imp.Quest.reset();
        Generator.fullReset();
        hero = new Hero();
        hero.live();
        Badges.reset();
        GamesInProgress.selectedClass.initHero(hero);
    }

    public static boolean isChallenged(int mask) {
        return (challenges & mask) != 0;
    }

    public static Level newLevel() {
        Level level;
        Dungeon.level = null;
        Actor.clear();
        if (++depth > Statistics.deepestFloor) {
            Statistics.deepestFloor = depth;
            Statistics.completedWithNoKilling = Statistics.qualifiedForNoKilling;
        }
        switch (depth) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                level = new SewerLevel();
                break;
            }
            case 5: {
                level = new SewerBossLevel();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                level = new PrisonLevel();
                break;
            }
            case 10: {
                level = new PrisonBossLevel();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                level = new CavesLevel();
                break;
            }
            case 15: {
                level = new CavesBossLevel();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                level = new CityLevel();
                break;
            }
            case 20: {
                level = new CityBossLevel();
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                level = new HallsLevel();
                break;
            }
            case 25: {
                level = new HallsBossLevel();
                break;
            }
            case 26: {
                level = new LastLevel();
                break;
            }
            default: {
                level = new DeadEndLevel();
                --Statistics.deepestFloor;
            }
        }
        level.create();
        Statistics.qualifiedForNoKilling = !Dungeon.bossLevel();
        return level;
    }

    public static void resetLevel() {
        Actor.clear();
        level.reset();
        Dungeon.switchLevel(level, Dungeon.level.entrance);
    }

    public static long seedCurDepth() {
        return Dungeon.seedForDepth(depth);
    }

    public static long seedForDepth(int depth) {
        Random.pushGenerator((long)seed);
        for (int i = 0; i < depth; ++i) {
            Random.Long();
        }
        long result = Random.Long();
        Random.popGenerator();
        return result;
    }

    public static boolean shopOnLevel() {
        return depth == 6 || depth == 11 || depth == 16;
    }

    public static boolean bossLevel() {
        return Dungeon.bossLevel(depth);
    }

    public static boolean bossLevel(int depth) {
        return depth == 5 || depth == 10 || depth == 15 || depth == 20 || depth == 25;
    }

    public static void switchLevel(Level level, int pos) {
        if (pos == -2) {
            pos = level.exit;
        } else if (pos < 0 || pos >= level.length() || !level.passable[pos] && !level.avoid[pos]) {
            pos = level.entrance;
        }
        PathFinder.setMapSize((int)level.width(), (int)level.height());
        Dungeon.level = level;
        Mob.restoreAllies(level, pos);
        Actor.init();
        level.addRespawner();
        Dungeon.hero.pos = pos;
        block2: for (Mob m : level.mobs) {
            if (m.pos != Dungeon.hero.pos) continue;
            for (int i : PathFinder.NEIGHBOURS8) {
                if (Actor.findChar(m.pos + i) != null || !level.passable[m.pos + i]) continue;
                m.pos += i;
                continue block2;
            }
        }
        Light light = hero.buff(Light.class);
        Dungeon.hero.viewDistance = light == null ? level.viewDistance : Math.max(6, level.viewDistance);
        Dungeon.hero.lastAction = null;
        Dungeon.hero.curAction = null;
        Dungeon.observe();
        try {
            Dungeon.saveAll();
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException((Throwable)e);
        }
    }

    public static void dropToChasm(Item item) {
        int depth = Dungeon.depth + 1;
        ArrayList<Item> dropped = (ArrayList<Item>)droppedItems.get(depth);
        if (dropped == null) {
            dropped = new ArrayList<Item>();
            droppedItems.put(depth, dropped);
        }
        dropped.add(item);
    }

    public static boolean posNeeded() {
        int posLeftThisSet = 2 - (LimitedDrops.STRENGTH_POTIONS.count - depth / 5 * 2);
        if (posLeftThisSet <= 0) {
            return false;
        }
        int floorThisSet = depth % 5;
        int targetPOSLeft = 2 - floorThisSet / 2;
        if (floorThisSet % 2 == 1 && Random.Int((int)2) == 0) {
            --targetPOSLeft;
        }
        return targetPOSLeft < posLeftThisSet;
    }

    public static boolean souNeeded() {
        int souLeftThisSet = Dungeon.isChallenged(64) ? Math.round(1.5f - ((float)LimitedDrops.UPGRADE_SCROLLS.count - (float)(depth / 5) * 1.5f)) : 3 - (LimitedDrops.UPGRADE_SCROLLS.count - depth / 5 * 3);
        if (souLeftThisSet <= 0) {
            return false;
        }
        int floorThisSet = depth % 5;
        return Random.Int((int)(5 - floorThisSet)) < souLeftThisSet;
    }

    public static boolean asNeeded() {
        int asLeftThisSet = 1 - (LimitedDrops.ARCANE_STYLI.count - depth / 5);
        if (asLeftThisSet <= 0) {
            return false;
        }
        int floorThisSet = depth % 5;
        return Random.Int((int)(5 - floorThisSet)) < asLeftThisSet;
    }

    public static void saveGame(int save) {
        try {
            Bundle bundle = new Bundle();
            version = Game.versionCode;
            bundle.put(VERSION, version);
            bundle.put(SEED, seed);
            bundle.put(CHALLENGES, challenges);
            bundle.put(MOBS_TO_CHAMPION, mobsToChampion);
            bundle.put(HERO, (Bundlable)hero);
            bundle.put(DEPTH, depth);
            bundle.put(GOLD, gold);
            bundle.put(ENERGY, energy);
            for (int d : droppedItems.keyArray()) {
                bundle.put(Messages.format(DROPPED, d), (Collection)droppedItems.get(d));
            }
            for (int p : portedItems.keyArray()) {
                bundle.put(Messages.format(PORTED, p), (Collection)portedItems.get(p));
            }
            quickslot.storePlaceholders(bundle);
            Bundle limDrops = new Bundle();
            LimitedDrops.store(limDrops);
            bundle.put(LIMDROPS, limDrops);
            int count = 0;
            int[] ids = new int[chapters.size()];
            for (Integer id : chapters) {
                ids[count++] = id;
            }
            bundle.put(CHAPTERS, ids);
            Bundle quests = new Bundle();
            Ghost.Quest.storeInBundle(quests);
            Wandmaker.Quest.storeInBundle(quests);
            Blacksmith.Quest.storeInBundle(quests);
            Imp.Quest.storeInBundle(quests);
            bundle.put(QUESTS, quests);
            SpecialRoom.storeRoomsInBundle(bundle);
            SecretRoom.storeRoomsInBundle(bundle);
            Statistics.storeInBundle(bundle);
            Notes.storeInBundle(bundle);
            Generator.storeInBundle(bundle);
            Scroll.save(bundle);
            Potion.save(bundle);
            Ring.save(bundle);
            Actor.storeNextID(bundle);
            Bundle badges = new Bundle();
            Badges.saveLocal(badges);
            bundle.put(BADGES, badges);
            FileUtils.bundleToFile((String)GamesInProgress.gameFile(save), (Bundle)bundle);
        }
        catch (IOException e) {
            GamesInProgress.setUnknown(save);
            ShatteredPixelDungeon.reportException((Throwable)e);
        }
    }

    public static void saveLevel(int save) throws IOException {
        Bundle bundle = new Bundle();
        bundle.put(LEVEL, (Bundlable)level);
        FileUtils.bundleToFile((String)GamesInProgress.depthFile(save, depth), (Bundle)bundle);
    }

    public static void saveAll() throws IOException {
        if (hero != null && (hero.isAlive() || WndResurrect.instance != null)) {
            Actor.fixTime();
            Dungeon.saveGame(GamesInProgress.curSlot);
            Dungeon.saveLevel(GamesInProgress.curSlot);
            GamesInProgress.set(GamesInProgress.curSlot, depth, challenges, hero);
        }
    }

    public static void loadGame(int save) throws IOException {
        Dungeon.loadGame(save, true);
    }

    public static void loadGame(int save, boolean fullLoad) throws IOException {
        Bundle badges;
        Bundle bundle = FileUtils.bundleFromFile((String)GamesInProgress.gameFile(save));
        version = bundle.getInt(VERSION);
        seed = bundle.contains(SEED) ? bundle.getLong(SEED) : DungeonSeed.randomSeed();
        Actor.clear();
        Actor.restoreNextID(bundle);
        quickslot.reset();
        QuickSlotButton.reset();
        challenges = bundle.getInt(CHALLENGES);
        mobsToChampion = bundle.getInt(MOBS_TO_CHAMPION);
        level = null;
        depth = -1;
        Scroll.restore(bundle);
        Potion.restore(bundle);
        Ring.restore(bundle);
        quickslot.restorePlaceholders(bundle);
        if (fullLoad) {
            Bundle quests;
            LimitedDrops.restore(bundle.getBundle(LIMDROPS));
            chapters = new HashSet();
            int[] ids = bundle.getIntArray(CHAPTERS);
            if (ids != null) {
                for (int id : ids) {
                    chapters.add(id);
                }
            }
            if (!(quests = bundle.getBundle(QUESTS)).isNull()) {
                Ghost.Quest.restoreFromBundle(quests);
                Wandmaker.Quest.restoreFromBundle(quests);
                Blacksmith.Quest.restoreFromBundle(quests);
                Imp.Quest.restoreFromBundle(quests);
            } else {
                Ghost.Quest.reset();
                Wandmaker.Quest.reset();
                Blacksmith.Quest.reset();
                Imp.Quest.reset();
            }
            SpecialRoom.restoreRoomsFromBundle(bundle);
            SecretRoom.restoreRoomsFromBundle(bundle);
        }
        if (!(badges = bundle.getBundle(BADGES)).isNull()) {
            Badges.loadLocal(badges);
        } else {
            Badges.reset();
        }
        Notes.restoreFromBundle(bundle);
        hero = null;
        hero = (Hero)bundle.get(HERO);
        depth = bundle.getInt(DEPTH);
        gold = bundle.getInt(GOLD);
        energy = bundle.getInt(ENERGY);
        Statistics.restoreFromBundle(bundle);
        Generator.restoreFromBundle(bundle);
        droppedItems = new SparseArray();
        portedItems = new SparseArray();
        for (int i = 1; i <= 26; ++i) {
            ArrayList<Item> items = new ArrayList<Item>();
            if (bundle.contains(Messages.format(DROPPED, i))) {
                for (Bundlable b : bundle.getCollection(Messages.format(DROPPED, i))) {
                    items.add((Item)b);
                }
            }
            if (!items.isEmpty()) {
                droppedItems.put(i, items);
            }
            items = new ArrayList();
            if (bundle.contains(Messages.format(PORTED, i))) {
                for (Bundlable b : bundle.getCollection(Messages.format(PORTED, i))) {
                    items.add((Item)b);
                }
            }
            if (items.isEmpty()) continue;
            portedItems.put(i, items);
        }
    }

    public static Level loadLevel(int save) throws IOException {
        level = null;
        Actor.clear();
        Bundle bundle = FileUtils.bundleFromFile((String)GamesInProgress.depthFile(save, depth));
        Level level = (Level)bundle.get(LEVEL);
        if (level == null) {
            throw new IOException();
        }
        return level;
    }

    public static void deleteGame(int save, boolean deleteLevels) {
        if (deleteLevels) {
            String folder = GamesInProgress.gameFolder(save);
            for (String file : FileUtils.filesInDir((String)folder)) {
                if (!file.contains(DEPTH)) continue;
                FileUtils.deleteFile((String)(folder + "/" + file));
            }
        }
        FileUtils.zeroFile((String)GamesInProgress.gameFile(save), (int)1);
        GamesInProgress.delete(save);
    }

    public static void preview(GamesInProgress.Info info, Bundle bundle) {
        info.depth = bundle.getInt(DEPTH);
        info.version = bundle.getInt(VERSION);
        info.challenges = bundle.getInt(CHALLENGES);
        Hero.preview(info, bundle.getBundle(HERO));
        Statistics.preview(info, bundle);
    }

    public static void fail(Class cause) {
        if (WndResurrect.instance == null) {
            Rankings.INSTANCE.submit(false, cause);
        }
    }

    public static void win(Class cause) {
        Dungeon.hero.belongings.identify();
        Rankings.INSTANCE.submit(true, cause);
    }

    public static void observe() {
        int dist = Math.max(Dungeon.hero.viewDistance, 8);
        dist = (int)((float)dist * (1.0f + 0.25f * (float)hero.pointsInTalent(Talent.FARSIGHT)));
        if (hero.buff(MagicalSight.class) != null) {
            dist = Math.max(dist, 12);
        }
        Dungeon.observe(dist + 1);
    }

    public static void observe(int dist) {
        if (level == null) {
            return;
        }
        level.updateFieldOfView(hero, Dungeon.level.heroFOV);
        int x = Dungeon.hero.pos % level.width();
        int y = Dungeon.hero.pos / level.width();
        int l = Math.max(0, x - dist);
        int r = Math.min(x + dist, level.width() - 1);
        int t = Math.max(0, y - dist);
        int b = Math.min(y + dist, level.height() - 1);
        int width = r - l + 1;
        int height = b - t + 1;
        int pos = l + t * level.width();
        for (int i = t; i <= b; ++i) {
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, pos, width, Dungeon.level.visited);
            pos += level.width();
        }
        GameScene.updateFog(l, t, width, height);
        if (hero.buff(MindVision.class) != null) {
            for (Mob m : Dungeon.level.mobs.toArray(new Mob[0])) {
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, m.pos - 1 - level.width(), 3, Dungeon.level.visited);
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, m.pos, 3, Dungeon.level.visited);
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, m.pos - 1 + level.width(), 3, Dungeon.level.visited);
                GameScene.updateFog(m.pos, 2);
            }
        }
        if (hero.buff(Awareness.class) != null) {
            for (Heap h : Dungeon.level.heaps.valueList()) {
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1 - level.width(), 3, Dungeon.level.visited);
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1, 3, Dungeon.level.visited);
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1 + level.width(), 3, Dungeon.level.visited);
                GameScene.updateFog(h.pos, 2);
            }
        }
        for (TalismanOfForesight.CharAwareness c : hero.buffs(TalismanOfForesight.CharAwareness.class)) {
            Char ch = (Char)Actor.findById(c.charID);
            if (ch == null) continue;
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, ch.pos - 1 - level.width(), 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, ch.pos - 1, 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, ch.pos - 1 + level.width(), 3, Dungeon.level.visited);
            GameScene.updateFog(ch.pos, 2);
        }
        for (TalismanOfForesight.HeapAwareness h : hero.buffs(TalismanOfForesight.HeapAwareness.class)) {
            if (depth != h.depth) continue;
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1 - level.width(), 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1, 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, h.pos - 1 + level.width(), 3, Dungeon.level.visited);
            GameScene.updateFog(h.pos, 2);
        }
        for (RevealedArea a : hero.buffs(RevealedArea.class)) {
            if (depth != a.depth) continue;
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, a.pos - 1 - level.width(), 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, a.pos - 1, 3, Dungeon.level.visited);
            BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, a.pos - 1 + level.width(), 3, Dungeon.level.visited);
            GameScene.updateFog(a.pos, 2);
        }
        for (Char ch : Actor.chars()) {
            if (!(ch instanceof WandOfWarding.Ward) && !(ch instanceof WandOfRegrowth.Lotus) && !(ch instanceof SpiritHawk.HawkAlly)) continue;
            x = ch.pos % level.width();
            y = ch.pos / level.width();
            dist = ch.viewDistance + 1;
            l = Math.max(0, x - dist);
            r = Math.min(x + dist, level.width() - 1);
            t = Math.max(0, y - dist);
            b = Math.min(y + dist, level.height() - 1);
            width = r - l + 1;
            height = b - t + 1;
            pos = l + t * level.width();
            for (int i = t; i <= b; ++i) {
                BArray.or(Dungeon.level.visited, Dungeon.level.heroFOV, pos, width, Dungeon.level.visited);
                pos += level.width();
            }
            GameScene.updateFog(ch.pos, dist);
        }
        GameScene.afterObserve();
    }

    private static void setupPassable() {
        if (passable == null || passable.length != level.length()) {
            passable = new boolean[level.length()];
        } else {
            BArray.setFalse(passable);
        }
    }

    public static PathFinder.Path findPath(Char ch, int to, boolean[] pass, boolean[] vis, boolean chars) {
        Dungeon.setupPassable();
        if (ch.flying || ch.buff(Amok.class) != null) {
            BArray.or(pass, Dungeon.level.avoid, passable);
        } else {
            System.arraycopy(pass, 0, passable, 0, level.length());
        }
        if (chars && Char.hasProp(ch, Char.Property.LARGE)) {
            BArray.and(passable, Dungeon.level.openSpace, passable);
        }
        if (chars) {
            for (Char c : Actor.chars()) {
                if (!vis[c.pos]) continue;
                Dungeon.passable[c.pos] = false;
            }
        }
        return PathFinder.find((int)ch.pos, (int)to, (boolean[])passable);
    }

    public static int findStep(Char ch, int to, boolean[] pass, boolean[] visible, boolean chars) {
        if (level.adjacent(ch.pos, to)) {
            return Actor.findChar(to) == null && (pass[to] || Dungeon.level.avoid[to]) ? to : -1;
        }
        Dungeon.setupPassable();
        if (ch.flying || ch.buff(Amok.class) != null) {
            BArray.or(pass, Dungeon.level.avoid, passable);
        } else {
            System.arraycopy(pass, 0, passable, 0, level.length());
        }
        if (Char.hasProp(ch, Char.Property.LARGE)) {
            BArray.and(passable, Dungeon.level.openSpace, passable);
        }
        if (chars) {
            for (Char c : Actor.chars()) {
                if (!visible[c.pos]) continue;
                Dungeon.passable[c.pos] = false;
            }
        }
        return PathFinder.getStep((int)ch.pos, (int)to, (boolean[])passable);
    }

    public static int flee(Char ch, int from, boolean[] pass, boolean[] visible, boolean chars) {
        Dungeon.setupPassable();
        if (ch.flying) {
            BArray.or(pass, Dungeon.level.avoid, passable);
        } else {
            System.arraycopy(pass, 0, passable, 0, level.length());
        }
        if (Char.hasProp(ch, Char.Property.LARGE)) {
            BArray.and(passable, Dungeon.level.openSpace, passable);
        }
        Dungeon.passable[ch.pos] = true;
        int step = PathFinder.getStepBack((int)ch.pos, (int)from, (boolean[])passable);
        while (step != -1 && Actor.findChar(step) != null) {
            Dungeon.passable[step] = false;
            step = PathFinder.getStepBack((int)ch.pos, (int)from, (boolean[])passable);
        }
        return step;
    }

    static {
        quickslot = new QuickSlot();
    }

    public static enum LimitedDrops {
        STRENGTH_POTIONS,
        UPGRADE_SCROLLS,
        ARCANE_STYLI,
        SWARM_HP,
        NECRO_HP,
        BAT_HP,
        WARLOCK_HP,
        COOKING_HP,
        BLANDFRUIT_SEED,
        SLIME_WEP,
        SKELE_WEP,
        THEIF_MISC,
        GUARD_ARM,
        SHAMAN_WAND,
        DM200_EQUIP,
        GOLEM_EQUIP,
        VELVET_POUCH,
        SCROLL_HOLDER,
        POTION_BANDOLIER,
        MAGICAL_HOLSTER;

        public int count = 0;

        public boolean dropped() {
            return this.count != 0;
        }

        public void drop() {
            this.count = 1;
        }

        public static void reset() {
            for (LimitedDrops lim : LimitedDrops.values()) {
                lim.count = 0;
            }
        }

        public static void store(Bundle bundle) {
            for (LimitedDrops lim : LimitedDrops.values()) {
                bundle.put(lim.name(), lim.count);
            }
        }

        public static void restore(Bundle bundle) {
            for (LimitedDrops lim : LimitedDrops.values()) {
                lim.count = bundle.contains(lim.name()) ? bundle.getInt(lim.name()) : 0;
            }
        }
    }
}

