/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Belongings;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public enum Rankings {
    INSTANCE;

    public static final int TABLE_SIZE = 11;
    public static final String RANKINGS_FILE = "rankings.dat";
    public static final String HALL_FILE = "hall.dat";
    public ArrayList<Record> records;
    public int lastRecord;
    public int totalNumber;
    public int wonNumber;
    public int syncedTotal;
    public int syncedWon;
    public ArrayList<ArrayList<Record>> hallRecords;
    public long hallLastUpdated;
    public long hallLastSynced;
    public String hallID;
    public static final String HERO = "hero";
    public static final String STATS = "stats";
    public static final String BADGES = "badges";
    public static final String HANDLERS = "handlers";
    public static final String CHALLENGES = "challenges";
    public static final String RECORDS = "records";
    public static final String LATEST = "latest";
    public static final String TOTAL = "total";
    public static final String WON = "won";
    public static final Comparator<Record> scoreComparator;

    public void submit(boolean win, Class cause) {
        this.load();
        Record rec = new Record();
        rec.cause = cause;
        rec.win = win;
        rec.heroClass = Dungeon.hero.heroClass;
        rec.armorTier = Dungeon.hero.tier();
        rec.herolevel = Dungeon.hero.lvl;
        rec.depth = Dungeon.depth;
        rec.score = this.score(win);
        Analytics.trackRunEnd(cause.getSimpleName());
        INSTANCE.saveGameData(rec);
        rec.gameID = UUID.randomUUID().toString();
        this.records.add(rec);
        Collections.sort(this.records, scoreComparator);
        this.lastRecord = this.records.indexOf(rec);
        int size = this.records.size();
        while (size > 11) {
            if (this.lastRecord == size - 1) {
                this.records.remove(size - 2);
                --this.lastRecord;
            } else {
                this.records.remove(size - 1);
            }
            size = this.records.size();
        }
        ++this.totalNumber;
        if (win) {
            ++this.wonNumber;
        }
        Badges.validateGamesPlayed();
        this.save();
        Sync.syncRankings();
    }

    public final void sendToHall(Record record, int page) {
        this.sendToHall(record, page, -1);
    }

    public boolean sendToHall(Record record, int page, int fromPage) {
        this.loadHall();
        if (this.hallRecords.get(page).size() >= 10) {
            return false;
        }
        record.lastUpdatedHOH = this.hallLastUpdated = Game.realTime;
        if (fromPage >= 0) {
            this.hallRecords.get(fromPage).remove(record);
        }
        this.hallRecords.get(page).add(record);
        Collections.sort((List)this.hallRecords.get(page), scoreComparator);
        this.saveHall();
        return true;
    }

    private int score(boolean win) {
        return (Statistics.goldCollected + Dungeon.hero.lvl * (win ? 26 : Dungeon.depth) * 100) * (win ? 2 : 1);
    }

    public void saveGameData(Record rec) {
        rec.gameData = new Bundle();
        Belongings belongings = Dungeon.hero.belongings;
        ArrayList allItems = (ArrayList)belongings.backpack.items.clone();
        for (Item item : belongings.backpack.items.toArray(new Item[0])) {
            if (item instanceof Bag) {
                for (Item bagItem : ((Bag)item).items.toArray(new Item[0])) {
                    if (!Dungeon.quickslot.contains(bagItem)) continue;
                    belongings.backpack.items.add(bagItem);
                }
            }
            if (Dungeon.quickslot.contains(item)) continue;
            belongings.backpack.items.remove(item);
        }
        for (Buff b : Dungeon.hero.buffs()) {
            Dungeon.hero.remove(b);
        }
        rec.gameData.put(HERO, (Bundlable)Dungeon.hero);
        Bundle stats = new Bundle();
        Statistics.storeInBundle(stats);
        rec.gameData.put(STATS, stats);
        Bundle badges = new Bundle();
        Badges.saveLocal(badges);
        rec.gameData.put(BADGES, badges);
        Bundle handler = new Bundle();
        Scroll.saveSelectively(handler, belongings.backpack.items);
        Potion.saveSelectively(handler, belongings.backpack.items);
        if (belongings.misc != null) {
            belongings.backpack.items.add(belongings.misc);
        }
        if (belongings.ring != null) {
            belongings.backpack.items.add(belongings.ring);
        }
        Ring.saveSelectively(handler, belongings.backpack.items);
        rec.gameData.put(HANDLERS, handler);
        belongings.backpack.items = allItems;
        rec.gameData.put(CHALLENGES, Dungeon.challenges);
    }

    public void loadGameData(Record rec) {
        Bundle data = rec.gameData;
        Actor.clear();
        Dungeon.hero = null;
        Dungeon.level = null;
        Generator.fullReset();
        Notes.reset();
        Dungeon.quickslot.reset();
        QuickSlotButton.reset();
        Bundle handler = data.getBundle(HANDLERS);
        Scroll.restore(handler);
        Potion.restore(handler);
        Ring.restore(handler);
        Badges.loadLocal(data.getBundle(BADGES));
        Dungeon.hero = (Hero)data.get(HERO);
        Statistics.restoreFromBundle(data.getBundle(STATS));
        Dungeon.challenges = data.getInt(CHALLENGES);
    }

    public void save() {
        Bundle bundle = new Bundle();
        bundle.put(RECORDS, this.records);
        bundle.put(LATEST, this.lastRecord);
        bundle.put(TOTAL, this.totalNumber);
        bundle.put(WON, this.wonNumber);
        bundle.put("syncedTotal", this.syncedTotal);
        bundle.put("syncedWon", this.syncedWon);
        try {
            FileUtils.bundleToFile((String)RANKINGS_FILE, (Bundle)bundle);
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException((Throwable)e);
        }
    }

    public void load() {
        if (this.records != null) {
            return;
        }
        this.records = new ArrayList();
        try {
            Bundle bundle = FileUtils.bundleFromFile((String)RANKINGS_FILE);
            for (Bundlable record : bundle.getCollection(RECORDS)) {
                this.records.add((Record)record);
            }
            this.lastRecord = bundle.getInt(LATEST);
            this.totalNumber = bundle.getInt(TOTAL);
            if (this.totalNumber == 0) {
                this.totalNumber = this.records.size();
            }
            this.wonNumber = bundle.getInt(WON);
            if (this.wonNumber == 0) {
                for (Record rec : this.records) {
                    if (!rec.win) continue;
                    ++this.wonNumber;
                }
            }
            this.syncedTotal = bundle.getInt("syncedTotal");
            this.syncedWon = bundle.getInt("syncedWon");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveHall() {
        Bundle bundle = new Bundle();
        bundle.put("updated", this.hallLastUpdated);
        bundle.put("synced", this.hallLastSynced);
        bundle.put("id", this.hallID);
        for (int i = 0; i < 4; ++i) {
            bundle.put(RECORDS + i, (Collection)this.hallRecords.get(i));
        }
        try {
            FileUtils.bundleToFile((String)HALL_FILE, (Bundle)bundle);
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException((Throwable)e);
        }
    }

    public void loadHall() {
        if (this.hallRecords != null) {
            return;
        }
        this.hallRecords = new ArrayList(4);
        try {
            Bundle bundle = FileUtils.bundleFromFile((String)HALL_FILE);
            this.hallLastUpdated = bundle.getLong("updated");
            this.hallLastSynced = bundle.getLong("synced");
            this.hallID = bundle.contains("id") ? bundle.getString("id") : UUID.randomUUID().toString();
            while (this.hallRecords.size() < 4) {
                this.hallRecords.add(new ArrayList());
            }
            int i = 0;
            while (bundle.contains(RECORDS + i)) {
                for (Bundlable record : bundle.getCollection(RECORDS + i)) {
                    this.hallRecords.get(i).add((Record)record);
                }
                ++i;
            }
        }
        catch (IOException e) {
            while (this.hallRecords.size() < 4) {
                this.hallRecords.add(new ArrayList());
            }
            this.hallLastUpdated = 0L;
            this.hallID = UUID.randomUUID().toString();
        }
    }

    static {
        scoreComparator = new Comparator<Record>(){

            @Override
            public int compare(Record lhs, Record rhs) {
                int result = (int)Math.signum(rhs.score - lhs.score);
                if (result == 0) {
                    return (int)Math.signum(rhs.gameID.hashCode() - lhs.gameID.hashCode());
                }
                return result;
            }
        };
    }

    public static class Record
    implements Bundlable {
        private static final String CAUSE = "cause";
        private static final String WIN = "win";
        private static final String SCORE = "score";
        private static final String CLASS = "class";
        private static final String TIER = "tier";
        private static final String LEVEL = "level";
        private static final String DEPTH = "depth";
        private static final String DATA = "gameData";
        private static final String ID = "gameID";
        public Class cause;
        public boolean win;
        public HeroClass heroClass;
        public int armorTier;
        public int herolevel;
        public int depth;
        public Bundle gameData;
        public String gameID;
        public String note;
        public long lastUpdatedHOH;
        public int score;

        public String desc() {
            if (this.cause == null) {
                return Messages.get(this, "something", new Object[0]);
            }
            String result = Messages.get(this.cause, "rankings_desc", Messages.get(this.cause, "name", new Object[0]));
            if (result.contains("!!!NO TEXT FOUND!!!")) {
                return Messages.get(this, "something", new Object[0]);
            }
            return result;
        }

        public void restoreFromBundle(Bundle bundle) {
            this.cause = bundle.contains(CAUSE) ? bundle.getClass(CAUSE) : null;
            this.win = bundle.getBoolean(WIN);
            this.score = bundle.getInt(SCORE);
            this.heroClass = (HeroClass)bundle.getEnum(CLASS, HeroClass.class);
            this.armorTier = bundle.getInt(TIER);
            if (bundle.contains(DATA)) {
                this.gameData = bundle.getBundle(DATA);
            }
            if (bundle.contains(ID)) {
                this.gameID = bundle.getString(ID);
            }
            if (this.gameID == null) {
                this.gameID = UUID.randomUUID().toString();
            }
            this.depth = bundle.getInt(DEPTH);
            this.herolevel = bundle.getInt(LEVEL);
            if (bundle.contains("note")) {
                this.note = bundle.getString("note");
            }
            if (bundle.contains("updated")) {
                this.lastUpdatedHOH = bundle.getLong("updated");
            }
        }

        public void storeInBundle(Bundle bundle) {
            if (this.cause != null) {
                bundle.put(CAUSE, this.cause);
            }
            bundle.put(WIN, this.win);
            bundle.put(SCORE, this.score);
            bundle.put(CLASS, (Enum)this.heroClass);
            bundle.put(TIER, this.armorTier);
            bundle.put(LEVEL, this.herolevel);
            bundle.put(DEPTH, this.depth);
            if (this.gameData != null) {
                bundle.put(DATA, this.gameData);
            }
            bundle.put(ID, this.gameID);
            if (this.note != null) {
                bundle.put("note", this.note);
            }
            if (this.lastUpdatedHOH != 0L) {
                bundle.put("updated", this.lastUpdatedHOH);
            }
        }

        public boolean equals(Object o) {
            return o instanceof Record && this.gameID.equals(((Record)o).gameID);
        }
    }
}

