/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Assets;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDAction;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DM300;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Tengu;
import com.shatteredpixel.shatteredpixeldungeon.items.KingsCrown;
import com.shatteredpixel.shatteredpixeldungeon.items.TengusMask;
import com.shatteredpixel.shatteredpixeldungeon.items.Waterskin;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfDivineInspiration;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfMastery;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfChallenge;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfDread;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfMetamorphosis;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfSirensSong;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfDeepSleep;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfFear;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.CleansingDart;
import com.shatteredpixel.shatteredpixeldungeon.levels.CavesBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.CityBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.HallsBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.PrisonBossLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.CrystalVaultRoom;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SupporterScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.WelcomeScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.PaymentService;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.PlatformSupport;

public class ShatteredPixelDungeon
extends Game {
    public static final int v0_9_2b = 531;
    public static final int v0_9_3c = 557;
    public static final int v1_0_3 = 574;
    public static final int v1_1_0 = 583;

    public ShatteredPixelDungeon(PlatformSupport platform) {
        super(sceneClass == null ? WelcomeScene.class : sceneClass, platform);
        Bundle.addAlias(CleansingDart.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.SleepDart");
        Bundle.addAlias(CrystalVaultRoom.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.VaultRoom");
        Bundle.addAlias(ScrollOfDread.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfPetrification");
        Bundle.addAlias(ScrollOfSirensSong.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfAffection");
        Bundle.addAlias(ScrollOfChallenge.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfConfusion");
        Bundle.addAlias(PotionOfDivineInspiration.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfHolyFuror");
        Bundle.addAlias(PotionOfMastery.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.PotionOfAdrenalineSurge");
        Bundle.addAlias(ScrollOfMetamorphosis.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfPolymorph");
        Bundle.addAlias(StoneOfFear.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfAffection");
        Bundle.addAlias(StoneOfDeepSleep.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.stones.StoneOfDeepenedSleep");
        Bundle.addAlias(Tengu.class, (String)"com.shatteredpixel.shatteredpixeldungeon.actors.mobs.NewTengu");
        Bundle.addAlias(PrisonBossLevel.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewPrisonBossLevel");
        Bundle.addAlias(PrisonBossLevel.ExitVisual.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewPrisonBossLevel$exitVisual");
        Bundle.addAlias(PrisonBossLevel.ExitVisualWalls.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewPrisonBossLevel$exitVisualWalls");
        Bundle.addAlias(DM300.class, (String)"com.shatteredpixel.shatteredpixeldungeon.actors.mobs.NewDM300");
        Bundle.addAlias(CavesBossLevel.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCavesBossLevel");
        Bundle.addAlias(CavesBossLevel.PylonEnergy.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCavesBossLevel$PylonEnergy");
        Bundle.addAlias(CavesBossLevel.ArenaVisuals.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCavesBossLevel$ArenaVisuals");
        Bundle.addAlias(CavesBossLevel.CityEntrance.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCavesBossLevel$CityEntrance");
        Bundle.addAlias(CavesBossLevel.EntranceOverhang.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCavesBossLevel$EntranceOverhang");
        Bundle.addAlias(CityBossLevel.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCityBossLevel");
        Bundle.addAlias(CityBossLevel.CustomGroundVisuals.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCityBossLevel$CustomGroundVisuals");
        Bundle.addAlias(CityBossLevel.CustomWallVisuals.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewCityBossLevel$CustomWallVisuals");
        Bundle.addAlias(HallsBossLevel.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewHallsBossLevel");
        Bundle.addAlias(HallsBossLevel.CenterPieceVisuals.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewHallsBossLevel$CenterPieceWalls");
        Bundle.addAlias(HallsBossLevel.CenterPieceWalls.class, (String)"com.shatteredpixel.shatteredpixeldungeon.levels.NewHallsBossLevel$CenterPieceWalls");
        Bundle.addAlias(Waterskin.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.DewVial");
        Bundle.addAlias(TengusMask.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.TomeOfMastery");
        Bundle.addAlias(KingsCrown.class, (String)"com.shatteredpixel.shatteredpixeldungeon.items.ArmorKit");
    }

    public void create() {
        super.create();
        ShatteredPixelDungeon.updateSystemUI();
        SPDAction.loadBindings();
        Music.INSTANCE.enable(SPDSettings.music());
        Music.INSTANCE.volume((float)(SPDSettings.musicVol() * SPDSettings.musicVol()) / 100.0f);
        Sample.INSTANCE.enable(SPDSettings.soundFx());
        Sample.INSTANCE.volume((float)(SPDSettings.SFXVol() * SPDSettings.SFXVol()) / 100.0f);
        Sample.INSTANCE.load(Assets.Sounds.all);
        this.updatePurchases();
    }

    public void finish() {
        if (!DeviceCompat.isiOS()) {
            super.finish();
        } else {
            ShatteredPixelDungeon.switchScene(TitleScene.class);
        }
    }

    public static void switchNoFade(Class<? extends PixelScene> c) {
        ShatteredPixelDungeon.switchNoFade(c, null);
    }

    public static void switchNoFade(Class<? extends PixelScene> c, Game.SceneChangeCallback callback) {
        PixelScene.noFade = true;
        ShatteredPixelDungeon.switchScene(c, (Game.SceneChangeCallback)callback);
    }

    public static void seamlessResetScene(Game.SceneChangeCallback callback) {
        if (ShatteredPixelDungeon.scene() instanceof PixelScene) {
            ((PixelScene)ShatteredPixelDungeon.scene()).saveWindows();
            ShatteredPixelDungeon.switchNoFade(sceneClass, callback);
        } else {
            ShatteredPixelDungeon.resetScene();
        }
    }

    public static void seamlessResetScene() {
        ShatteredPixelDungeon.seamlessResetScene(null);
    }

    protected void switchScene() {
        super.switchScene();
        if (this.scene instanceof PixelScene) {
            ((PixelScene)this.scene).restoreWindows();
        }
        if (sceneClass == GameScene.class) {
            Analytics.trackScreen(Dungeon.level.getClass().getSimpleName());
        } else if (sceneClass != InterlevelScene.class) {
            Analytics.trackScreen(sceneClass.getSimpleName());
        }
    }

    public void resize(int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        if (this.scene instanceof PixelScene && (height != Game.height || width != Game.width)) {
            PixelScene.noFade = true;
            ((PixelScene)this.scene).saveWindows();
        }
        super.resize(width, height);
        this.updateDisplaySize();
    }

    public void destroy() {
        super.destroy();
        GameScene.endActorThread();
    }

    public void updateDisplaySize() {
        platform.updateDisplaySize();
    }

    public static void updateSystemUI() {
        platform.updateSystemUI();
    }

    protected void logException(Throwable tr) {
        super.logException(tr);
        Analytics.trackException(tr);
    }

    public void resume() {
        super.resume();
        this.updatePurchases();
        if (Sync.supportsSync() && this.scene != null && (SPDSettings.googlePlayGames() && this.scene.getClass() != WelcomeScene.class || Sync.alwaysConnected())) {
            Sync.connectSilentOnly();
        }
        if (sceneClass != null) {
            if (sceneClass == GameScene.class) {
                Analytics.trackScreen(Dungeon.level.getClass().getSimpleName());
            } else if (sceneClass != InterlevelScene.class) {
                Analytics.trackScreen(sceneClass.getSimpleName());
            }
        }
    }

    private void updatePurchases() {
        final int oldHighestTier = Payment.getHighestTierUnlocked();
        Payment.updatePurchaseStates(false, new PaymentService.RefreshCallback(){

            public void onSuccess() {
                if (oldHighestTier != Payment.getHighestTierUnlocked() && (sceneClass == TitleScene.class || sceneClass == SupporterScene.class)) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }

            public void onFail() {
                if (oldHighestTier > 0) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        });
    }
}

