/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PinCushion;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;

public abstract class AllyBuff
extends Buff {
    @Override
    public boolean attachTo(Char target) {
        if (super.attachTo(target)) {
            target.alignment = Char.Alignment.ALLY;
            if (target.buff(PinCushion.class) != null) {
                target.buff(PinCushion.class).detach();
            }
            return true;
        }
        return false;
    }

    public static void affectAndLoot(Mob enemy, Hero hero, Class<? extends AllyBuff> buffCls) {
        boolean droppingLoot = enemy.alignment != Char.Alignment.ALLY;
        Buff.affect(enemy, buffCls);
        if (enemy.buff(buffCls) != null) {
            if (droppingLoot) {
                enemy.rollToDropLoot();
            }
            ++Statistics.enemiesSlain;
            Badges.validateMonstersSlain();
            Statistics.qualifiedForNoKilling = false;
            if (enemy.EXP > 0 && hero.lvl <= enemy.maxLvl) {
                hero.sprite.showStatus(65280, Messages.get(enemy, "exp", enemy.EXP), new Object[0]);
                hero.earnExp(enemy.EXP, enemy.getClass());
            } else {
                hero.earnExp(0, enemy.getClass());
            }
        }
    }
}

