/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Bleeding
extends Buff {
    protected float level;
    private static final String LEVEL = "level";

    public Bleeding() {
        this.type = Buff.buffType.NEGATIVE;
        this.announced = true;
    }

    public float level() {
        return this.level;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEVEL, this.level);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.level = bundle.getFloat(LEVEL);
    }

    public void set(float level) {
        this.level = Math.max(this.level, level);
    }

    @Override
    public int icon() {
        return 26;
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString(Math.round(this.level));
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            this.level = Random.NormalFloat((float)(this.level / 2.0f), (float)this.level);
            int dmg = Math.round(this.level);
            if (dmg > 0) {
                this.target.damage(dmg, this);
                if (this.target.sprite.visible) {
                    Splash.at(this.target.sprite.center(), -1.5707963f, 0.52359873f, this.target.sprite.blood(), Math.min(10 * dmg / this.target.HT, 10));
                }
                if (this.target == Dungeon.hero && !this.target.isAlive()) {
                    Dungeon.fail(this.getClass());
                    GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
                }
                this.spend(1.0f);
            } else {
                this.detach();
            }
        } else {
            this.detach();
        }
        return true;
    }

    @Override
    public String heroMessage() {
        return Messages.get(this, "heromsg", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", Math.round(this.level));
    }
}

