/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Image;
import com.watabou.utils.Bundle;

public class Corrosion
extends Buff
implements Hero.Doom {
    private float damage = 1.0f;
    protected float left;
    private static final String DAMAGE = "damage";
    private static final String LEFT = "left";

    public Corrosion() {
        this.type = Buff.buffType.NEGATIVE;
        this.announced = true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(DAMAGE, this.damage);
        bundle.put(LEFT, this.left);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.damage = bundle.getFloat(DAMAGE);
        this.left = bundle.getFloat(LEFT);
    }

    public void set(float duration, int damage) {
        this.left = Math.max(duration, this.left);
        if (this.damage < (float)damage) {
            this.damage = damage;
        }
    }

    @Override
    public int icon() {
        return 3;
    }

    @Override
    public void tintIcon(Image icon) {
        icon.hardlight(1.0f, 0.5f, 0.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.damage);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String heroMessage() {
        return Messages.get(this, "heromsg", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns(this.left), (int)this.damage);
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            float f;
            this.target.damage((int)this.damage, this);
            this.damage = this.damage < (float)(Dungeon.depth / 2 + 2) ? (this.damage += 1.0f) : (this.damage += 0.5f);
            this.spend(1.0f);
            this.left -= 1.0f;
            if (f <= 0.0f) {
                this.detach();
            }
        } else {
            this.detach();
        }
        return true;
    }

    @Override
    public void onDeath() {
        Dungeon.fail(this.getClass());
        GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
    }
}

