/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.buffs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Ooze
extends Buff {
    public static final float DURATION = 20.0f;
    private float left;
    private static final String LEFT = "left";

    public Ooze() {
        this.type = Buff.buffType.NEGATIVE;
        this.announced = true;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEFT, this.left);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.left = bundle.getFloat(LEFT);
    }

    @Override
    public int icon() {
        return 8;
    }

    @Override
    public float iconFadePercent() {
        return Math.max(0.0f, (20.0f - this.left) / 20.0f);
    }

    @Override
    public String iconTextDisplay() {
        return Integer.toString((int)this.left);
    }

    public String toString() {
        return Messages.get(this, "name", new Object[0]);
    }

    @Override
    public String heroMessage() {
        return Messages.get(this, "heromsg", new Object[0]);
    }

    @Override
    public String desc() {
        return Messages.get(this, "desc", this.dispTurns(this.left));
    }

    public void set(float left) {
        this.left = left;
    }

    @Override
    public boolean act() {
        if (this.target.isAlive()) {
            if (Dungeon.depth > 5) {
                this.target.damage(1 + Dungeon.depth / 5, this);
            } else if (Dungeon.depth == 5) {
                this.target.damage(1, this);
            } else if (Random.Int((int)2) == 0) {
                this.target.damage(1, this);
            }
            if (!this.target.isAlive() && this.target == Dungeon.hero) {
                Dungeon.fail(this.getClass());
                GLog.n(Messages.get(this, "ondeath", new Object[0]), new Object[0]);
            }
            this.spend(1.0f);
            this.left -= 1.0f;
            if (this.left <= 0.0f) {
                this.detach();
            }
        } else {
            this.detach();
        }
        if (Dungeon.level.water[this.target.pos]) {
            this.detach();
        }
        return true;
    }
}

