/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.mage;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Invisibility;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LockedFloor;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.effects.Pushing;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class WarpBeacon
extends ArmorAbility {
    public WarpBeacon() {
        this.baseChargeUse = 35.0f;
    }

    @Override
    public String targetingPrompt() {
        if (Dungeon.hero.buff(WarpBeaconTracker.class) == null && Dungeon.hero.hasTalent(Talent.REMOTE_BEACON)) {
            return Messages.get(this, "prompt", new Object[0]);
        }
        return super.targetingPrompt();
    }

    @Override
    protected void activate(final ClassArmor armor, final Hero hero, Integer target) {
        if (target == null) {
            return;
        }
        if (hero.buff(WarpBeaconTracker.class) != null) {
            final WarpBeaconTracker tracker = hero.buff(WarpBeaconTracker.class);
            GameScene.show(new WndOptions(new Image((Image)hero.sprite), Messages.titleCase(this.name()), Messages.get(WarpBeacon.class, "window_desc", tracker.depth), new String[]{Messages.get(WarpBeacon.class, "window_tele", new Object[0]), Messages.get(WarpBeacon.class, "window_clear", new Object[0]), Messages.get(WarpBeacon.class, "window_cancel", new Object[0])}){

                @Override
                protected void onSelect(int index) {
                    if (index == 0) {
                        if (tracker.depth != Dungeon.depth && !hero.hasTalent(Talent.LONGRANGE_WARP)) {
                            GLog.w(Messages.get(WarpBeacon.class, "depths", new Object[0]), new Object[0]);
                            return;
                        }
                        float chargeNeeded = WarpBeacon.this.chargeUse(hero);
                        if (tracker.depth != Dungeon.depth) {
                            chargeNeeded *= 1.833f - 0.333f * (float)Dungeon.hero.pointsInTalent(Talent.LONGRANGE_WARP);
                        }
                        if (armor.charge < chargeNeeded) {
                            GLog.w(Messages.get(ClassArmor.class, "low_charge", new Object[0]), new Object[0]);
                            return;
                        }
                        armor.charge -= chargeNeeded;
                        1 v0 = this;
                        v0.armor.updateQuickslot();
                        if (tracker.depth == Dungeon.depth) {
                            Char existing = Actor.findChar(tracker.pos);
                            ScrollOfTeleportation.appear(hero, tracker.pos);
                            if (existing != null && existing != hero) {
                                if (hero.hasTalent(Talent.TELEFRAG)) {
                                    int heroHP = hero.HP + hero.shielding();
                                    int heroDmg = 5 * hero.pointsInTalent(Talent.TELEFRAG);
                                    hero.damage(Math.min(heroDmg, heroHP - 1), WarpBeacon.this);
                                    int damage = Random.NormalIntRange((int)(10 * hero.pointsInTalent(Talent.TELEFRAG)), (int)(15 * hero.pointsInTalent(Talent.TELEFRAG)));
                                    existing.sprite.flash();
                                    existing.sprite.bloodBurstA(existing.sprite.center(), damage);
                                    existing.damage(damage, WarpBeacon.this);
                                    Sample.INSTANCE.play((Object)"sounds/hit_crush.mp3");
                                    Sample.INSTANCE.play((Object)"sounds/hit_strong.mp3");
                                }
                                if (existing.isAlive()) {
                                    Char toPush = Char.hasProp(existing, Char.Property.IMMOVABLE) ? hero : existing;
                                    ArrayList<Integer> candidates = new ArrayList<Integer>();
                                    for (int n : PathFinder.NEIGHBOURS8) {
                                        int cell = tracker.pos + n;
                                        if (Dungeon.level.solid[cell] || Actor.findChar(cell) != null || Char.hasProp(toPush, Char.Property.LARGE) && !Dungeon.level.openSpace[cell]) continue;
                                        candidates.add(cell);
                                    }
                                    Random.shuffle(candidates);
                                    if (!candidates.isEmpty()) {
                                        Actor.addDelayed(new Pushing(toPush, toPush.pos, (Integer)candidates.get(0)), -1.0f);
                                        toPush.pos = (Integer)candidates.get(0);
                                        Dungeon.level.occupyCell(toPush);
                                        hero.next();
                                    }
                                }
                            }
                            Invisibility.dispel();
                            Dungeon.observe();
                            GameScene.updateFog();
                        } else {
                            Swiftthistle.TimeBubble timeBubble;
                            if (hero.buff(LockedFloor.class) != null) {
                                GLog.w(Messages.get(WarpBeacon.class, "locked_floor", new Object[0]), new Object[0]);
                                return;
                            }
                            TimekeepersHourglass.timeFreeze timeFreeze2 = hero.buff(TimekeepersHourglass.timeFreeze.class);
                            if (timeFreeze2 != null) {
                                timeFreeze2.disarmPressedTraps();
                            }
                            if ((timeBubble = hero.buff(Swiftthistle.TimeBubble.class)) != null) {
                                timeBubble.disarmPressedTraps();
                            }
                            Invisibility.dispel();
                            InterlevelScene.mode = InterlevelScene.Mode.RETURN;
                            InterlevelScene.returnDepth = tracker.depth;
                            InterlevelScene.returnPos = tracker.pos;
                            Game.switchScene(InterlevelScene.class);
                        }
                    } else if (index == 1) {
                        hero.buff(WarpBeaconTracker.class).detach();
                    }
                }
            });
        } else {
            if (!Dungeon.level.mapped[target] && !Dungeon.level.visited[target]) {
                return;
            }
            if (Dungeon.level.distance(hero.pos, target) > 4 * hero.pointsInTalent(Talent.REMOTE_BEACON)) {
                GLog.w(Messages.get(WarpBeacon.class, "too_far", new Object[0]), new Object[0]);
                return;
            }
            PathFinder.buildDistanceMap((int)target, (boolean[])BArray.or(Dungeon.level.passable, Dungeon.level.avoid, null));
            if (Dungeon.level.pit[target] || Dungeon.level.solid[target] && !Dungeon.level.passable[target] || PathFinder.distance[hero.pos] == Integer.MAX_VALUE) {
                GLog.w(Messages.get(WarpBeacon.class, "invalid_beacon", new Object[0]), new Object[0]);
                return;
            }
            WarpBeaconTracker tracker = new WarpBeaconTracker();
            tracker.pos = target;
            tracker.depth = Dungeon.depth;
            tracker.attachTo(hero);
            hero.sprite.operate(target);
            Sample.INSTANCE.play((Object)"sounds/teleport.mp3");
            Invisibility.dispel();
            hero.spendAndNext(1.0f);
        }
    }

    @Override
    public int icon() {
        return 13;
    }

    @Override
    public Talent[] talents() {
        return new Talent[]{Talent.TELEFRAG, Talent.REMOTE_BEACON, Talent.LONGRANGE_WARP, Talent.HEROIC_ENERGY};
    }

    public static class WarpBeaconTracker
    extends Buff {
        int pos;
        int depth;
        Emitter e;
        public static final String POS = "pos";
        public static final String DEPTH = "depth";

        public WarpBeaconTracker() {
            this.revivePersists = true;
        }

        @Override
        public void fx(boolean on) {
            if (on && this.depth == Dungeon.depth) {
                this.e = CellEmitter.center(this.pos);
                this.e.pour(MagicMissile.WardParticle.UP, 0.05f);
            } else if (this.e != null) {
                this.e.on = false;
            }
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(POS, this.pos);
            bundle.put(DEPTH, this.depth);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.pos = bundle.getInt(POS);
            this.depth = bundle.getInt(DEPTH);
        }
    }
}

