/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Brute;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.PlateArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ScaleArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ShieldedSprite;
import com.watabou.utils.Random;

public class ArmoredBrute
extends Brute {
    public ArmoredBrute() {
        this.spriteClass = ShieldedSprite.class;
        this.loot = Generator.Category.ARMOR;
        this.lootChance = 1.0f;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange((int)6, (int)10);
    }

    @Override
    protected void triggerEnrage() {
        Buff.affect(this, ArmoredRage.class).setShield(this.HT / 2 + 1);
        if (Dungeon.level.heroFOV[this.pos]) {
            this.sprite.showStatus(0xFF0000, Messages.get(this, "enraged", new Object[0]), new Object[0]);
        }
        this.spend(1.0f);
        this.hasRaged = true;
    }

    @Override
    public Item createLoot() {
        if (Random.Int((int)4) == 0) {
            return new PlateArmor().random();
        }
        return new ScaleArmor().random();
    }

    public static class ArmoredRage
    extends Brute.BruteRage {
        @Override
        public boolean act() {
            if (this.target.HP > 0) {
                this.detach();
                return true;
            }
            this.absorbDamage(1);
            if (this.shielding() <= 0) {
                this.target.die(null);
            }
            this.spend(3.0f);
            return true;
        }
    }
}

