/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Statue;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.AntiMagic;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.Brimstone;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.StatueSprite;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class ArmoredStatue
extends Statue {
    protected Armor armor;
    private static final String ARMOR = "armor";

    public ArmoredStatue() {
        this.spriteClass = StatueSprite.class;
        do {
            this.armor = Generator.randomArmor();
        } while (this.armor.cursed);
        this.armor.inscribe(Armor.Glyph.random(new Class[0]));
        this.HP = this.HT = 30 + Dungeon.depth * 10;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ARMOR, (Bundlable)this.armor);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.armor = (Armor)bundle.get(ARMOR);
    }

    @Override
    public int drRoll() {
        return super.drRoll() + Random.NormalIntRange((int)this.armor.DRMin(), (int)this.armor.DRMax());
    }

    public Armor armor() {
        return this.armor;
    }

    @Override
    public boolean isImmune(Class effect) {
        if (effect == Burning.class && this.armor != null && this.armor.hasGlyph(Brimstone.class, this)) {
            return true;
        }
        return super.isImmune(effect);
    }

    @Override
    public int defenseProc(Char enemy, int damage) {
        damage = super.defenseProc(enemy, damage);
        return this.armor.proc(enemy, this, damage);
    }

    @Override
    public void damage(int dmg, Object src) {
        if (this.armor != null && this.armor.hasGlyph(AntiMagic.class, this) && AntiMagic.RESISTS.contains(src.getClass())) {
            dmg -= AntiMagic.drRoll(this.armor.buffedLvl());
        }
        super.damage(dmg, src);
        Item.updateQuickslot();
    }

    @Override
    public CharSprite sprite() {
        CharSprite sprite = super.sprite();
        ((StatueSprite)sprite).setArmor(this.armor.tier);
        return sprite;
    }

    @Override
    public float speed() {
        return this.armor.speedFactor(this, super.speed());
    }

    @Override
    public float stealth() {
        return this.armor.stealthFactor(this, super.stealth());
    }

    @Override
    public int defenseSkill(Char enemy) {
        return Math.round(this.armor.evasionFactor(this, super.defenseSkill(enemy)));
    }

    @Override
    public void die(Object cause) {
        this.armor.identify();
        Dungeon.level.drop((Item)this.armor, (int)this.pos).sprite.drop();
        super.die(cause);
    }

    @Override
    public String description() {
        return Messages.get(this, "desc", this.weapon.name(), this.armor.name());
    }
}

