/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Freezing;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Blindness;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Burning;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Chill;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Frost;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.Lightning;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLiquidFlame;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.Embers;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTransmutation;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.CursedWand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Shocking;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ElementalSprite;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public abstract class Elemental
extends Mob {
    private boolean summonedALly;
    protected int rangedCooldown;
    protected ArrayList<Class<? extends Buff>> harmfulBuffs;
    private static final String COOLDOWN = "cooldown";
    private static final String SUMMONED_ALLY = "summoned_ally";

    public Elemental() {
        this.HT = 60;
        this.HP = 60;
        this.defenseSkill = 20;
        this.EXP = 10;
        this.maxLvl = 20;
        this.flying = true;
        this.rangedCooldown = Random.NormalIntRange((int)3, (int)5);
        this.harmfulBuffs = new ArrayList();
    }

    @Override
    public int damageRoll() {
        if (!this.summonedALly) {
            return Random.NormalIntRange((int)20, (int)25);
        }
        int regionScale = Math.max(2, 1 + Dungeon.depth / 5);
        return Random.NormalIntRange((int)(5 * regionScale), (int)(5 + 5 * regionScale));
    }

    @Override
    public int attackSkill(Char target) {
        if (!this.summonedALly) {
            return 25;
        }
        int regionScale = Math.max(2, 1 + Dungeon.depth / 5);
        return 5 + 5 * regionScale;
    }

    public void setSummonedALly() {
        this.summonedALly = true;
        int regionScale = Math.max(2, 1 + Dungeon.depth / 5);
        this.defenseSkill = 5 * regionScale;
        this.HT = 15 * regionScale;
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange((int)0, (int)5);
    }

    @Override
    protected boolean act() {
        if (this.state == this.HUNTING) {
            --this.rangedCooldown;
        }
        return super.act();
    }

    @Override
    protected boolean canAttack(Char enemy) {
        if (this.rangedCooldown <= 0) {
            return new Ballistica((int)this.pos, (int)enemy.pos, (int)6).collisionPos == enemy.pos;
        }
        return super.canAttack(enemy);
    }

    @Override
    protected boolean doAttack(Char enemy) {
        if (Dungeon.level.adjacent(this.pos, enemy.pos) || this.rangedCooldown > 0) {
            return super.doAttack(enemy);
        }
        if (this.sprite != null && (this.sprite.visible || enemy.sprite.visible)) {
            this.sprite.zap(enemy.pos);
            return false;
        }
        this.zap();
        return true;
    }

    @Override
    public int attackProc(Char enemy, int damage) {
        damage = super.attackProc(enemy, damage);
        this.meleeProc(enemy, damage);
        return damage;
    }

    private void zap() {
        this.spend(1.0f);
        if (Elemental.hit((Char)this, this.enemy, true)) {
            this.rangedProc(this.enemy);
        } else {
            this.enemy.sprite.showStatus(0xFFFF00, this.enemy.defenseVerb(), new Object[0]);
        }
        this.rangedCooldown = Random.NormalIntRange((int)3, (int)5);
    }

    public void onZapComplete() {
        this.zap();
        this.next();
    }

    @Override
    public void add(Buff buff) {
        if (this.harmfulBuffs.contains(buff.getClass())) {
            this.damage(Random.NormalIntRange((int)(this.HT / 2), (int)(this.HT * 3 / 5)), buff);
        } else {
            super.add(buff);
        }
    }

    protected abstract void meleeProc(Char var1, int var2);

    protected abstract void rangedProc(Char var1);

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(COOLDOWN, this.rangedCooldown);
        bundle.put(SUMMONED_ALLY, this.summonedALly);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        if (bundle.contains(COOLDOWN)) {
            this.rangedCooldown = bundle.getInt(COOLDOWN);
        }
        this.summonedALly = bundle.getBoolean(SUMMONED_ALLY);
        if (this.summonedALly) {
            this.setSummonedALly();
        }
    }

    public static Class<? extends Elemental> random() {
        if (Random.Int((int)50) == 0) {
            return ChaosElemental.class;
        }
        float roll = Random.Float();
        if (roll < 0.4f) {
            return FireElemental.class;
        }
        if (roll < 0.8f) {
            return FrostElemental.class;
        }
        return ShockElemental.class;
    }

    public static class ChaosElemental
    extends Elemental {
        public ChaosElemental() {
            this.spriteClass = ElementalSprite.Chaos.class;
            this.loot = new ScrollOfTransmutation();
            this.lootChance = 1.0f;
        }

        @Override
        protected void meleeProc(Char enemy, int damage) {
            CursedWand.cursedEffect(null, (Char)this, enemy);
        }

        @Override
        protected void rangedProc(Char enemy) {
            CursedWand.cursedEffect(null, (Char)this, enemy);
        }
    }

    public static class ShockElemental
    extends Elemental {
        public ShockElemental() {
            this.spriteClass = ElementalSprite.Shock.class;
            this.loot = new ScrollOfRecharging();
            this.lootChance = 0.25f;
            this.properties.add(Char.Property.ELECTRIC);
        }

        @Override
        protected void meleeProc(Char enemy, int damage) {
            ArrayList<Char> affected = new ArrayList<Char>();
            ArrayList<Lightning.Arc> arcs = new ArrayList<Lightning.Arc>();
            Shocking.arc(this, enemy, 2, affected, arcs);
            if (!Dungeon.level.water[enemy.pos]) {
                affected.remove(enemy);
            }
            for (Char ch : affected) {
                ch.damage(Math.round((float)damage * 0.4f), this);
            }
            boolean visible = this.sprite.visible || enemy.sprite.visible;
            for (Char ch : affected) {
                if (!ch.sprite.visible) continue;
                visible = true;
            }
            if (visible) {
                this.sprite.parent.addToFront((Gizmo)new Lightning(arcs, null));
                Sample.INSTANCE.play((Object)"sounds/lightning.mp3");
            }
        }

        @Override
        protected void rangedProc(Char enemy) {
            Buff.affect(enemy, Blindness.class, 5.0f);
            if (enemy == Dungeon.hero) {
                GameScene.flash(-2130706433);
            }
        }
    }

    public static class FrostElemental
    extends Elemental {
        public FrostElemental() {
            this.spriteClass = ElementalSprite.Frost.class;
            this.loot = new PotionOfFrost();
            this.lootChance = 0.125f;
            this.properties.add(Char.Property.ICY);
            this.harmfulBuffs.add(Burning.class);
        }

        @Override
        protected void meleeProc(Char enemy, int damage) {
            if (Random.Int((int)3) == 0 || Dungeon.level.water[enemy.pos]) {
                Freezing.freeze(enemy.pos);
                if (enemy.sprite.visible) {
                    Splash.at(enemy.sprite.center(), this.sprite.blood(), 5);
                }
            }
        }

        @Override
        protected void rangedProc(Char enemy) {
            Freezing.freeze(enemy.pos);
            if (enemy.sprite.visible) {
                Splash.at(enemy.sprite.center(), this.sprite.blood(), 5);
            }
        }
    }

    public static class AllyNewBornElemental
    extends NewbornFireElemental {
        public AllyNewBornElemental() {
            this.HP = this.HT;
            this.properties.remove((Object)Char.Property.MINIBOSS);
        }

        @Override
        public boolean reset() {
            return false;
        }
    }

    public static class NewbornFireElemental
    extends FireElemental {
        public NewbornFireElemental() {
            this.spriteClass = ElementalSprite.NewbornFire.class;
            this.HT = 60;
            this.HP = this.HT / 2;
            this.defenseSkill = 12;
            this.EXP = 7;
            this.properties.add(Char.Property.MINIBOSS);
            this.rangedCooldown = Integer.MAX_VALUE;
        }

        @Override
        public void die(Object cause) {
            super.die(cause);
            if (this.alignment == Char.Alignment.ENEMY) {
                Dungeon.level.drop((Item)new Embers(), (int)this.pos).sprite.drop();
            }
        }

        @Override
        public boolean reset() {
            return true;
        }
    }

    public static class FireElemental
    extends Elemental {
        public FireElemental() {
            this.spriteClass = ElementalSprite.Fire.class;
            this.loot = new PotionOfLiquidFlame();
            this.lootChance = 0.125f;
            this.properties.add(Char.Property.FIERY);
            this.harmfulBuffs.add(Frost.class);
            this.harmfulBuffs.add(Chill.class);
        }

        @Override
        protected void meleeProc(Char enemy, int damage) {
            if (Random.Int((int)2) == 0 && !Dungeon.level.water[enemy.pos]) {
                Buff.affect(enemy, Burning.class).reignite(enemy);
                if (enemy.sprite.visible) {
                    Splash.at(enemy.sprite.center(), this.sprite.blood(), 5);
                }
            }
        }

        @Override
        protected void rangedProc(Char enemy) {
            if (!Dungeon.level.water[enemy.pos]) {
                Buff.affect(enemy, Burning.class).reignite(enemy, 4.0f);
            }
            if (enemy.sprite.visible) {
                Splash.at(enemy.sprite.center(), this.sprite.blood(), 5);
            }
        }
    }
}

