/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Adrenaline;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.AllyBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ChampionEnemy;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Skeleton;
import com.shatteredpixel.shatteredpixeldungeon.effects.Beam;
import com.shatteredpixel.shatteredpixeldungeon.effects.Pushing;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.NecromancerSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.SkeletonSprite;
import com.watabou.noosa.Gizmo;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class Necromancer
extends Mob {
    public boolean summoning;
    public int summoningPos;
    protected boolean firstSummon;
    private NecroSkeleton mySkeleton;
    private int storedSkeletonID;
    private static final String SUMMONING = "summoning";
    private static final String FIRST_SUMMON = "first_summon";
    private static final String SUMMONING_POS = "summoning_pos";
    private static final String MY_SKELETON = "my_skeleton";

    public Necromancer() {
        this.spriteClass = NecromancerSprite.class;
        this.HT = 40;
        this.HP = 40;
        this.defenseSkill = 14;
        this.EXP = 7;
        this.maxLvl = 14;
        this.loot = new PotionOfHealing();
        this.lootChance = 0.2f;
        this.properties.add(Char.Property.UNDEAD);
        this.HUNTING = new Hunting();
        this.summoning = false;
        this.summoningPos = -1;
        this.firstSummon = true;
        this.storedSkeletonID = -1;
    }

    @Override
    protected boolean act() {
        if (this.summoning && this.state != this.HUNTING) {
            this.summoning = false;
            if (this.sprite instanceof NecromancerSprite) {
                ((NecromancerSprite)this.sprite).cancelSummoning();
            }
        }
        return super.act();
    }

    @Override
    public int drRoll() {
        return Random.NormalIntRange((int)0, (int)5);
    }

    @Override
    public float lootChance() {
        return super.lootChance() * ((6.0f - (float)Dungeon.LimitedDrops.NECRO_HP.count) / 6.0f);
    }

    @Override
    public Item createLoot() {
        ++Dungeon.LimitedDrops.NECRO_HP.count;
        return super.createLoot();
    }

    @Override
    public void die(Object cause) {
        if (this.storedSkeletonID != -1) {
            Actor ch = Actor.findById(this.storedSkeletonID);
            this.storedSkeletonID = -1;
            if (ch instanceof NecroSkeleton) {
                this.mySkeleton = (NecroSkeleton)ch;
            }
        }
        if (this.mySkeleton != null && this.mySkeleton.isAlive()) {
            this.mySkeleton.die(null);
        }
        super.die(cause);
    }

    @Override
    protected boolean canAttack(Char enemy) {
        return false;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(SUMMONING, this.summoning);
        bundle.put(FIRST_SUMMON, this.firstSummon);
        if (this.summoning) {
            bundle.put(SUMMONING_POS, this.summoningPos);
        }
        if (this.mySkeleton != null) {
            bundle.put(MY_SKELETON, this.mySkeleton.id());
        } else if (this.storedSkeletonID != -1) {
            bundle.put(MY_SKELETON, this.storedSkeletonID);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.summoning = bundle.getBoolean(SUMMONING);
        if (bundle.contains(FIRST_SUMMON)) {
            this.firstSummon = bundle.getBoolean(FIRST_SUMMON);
        }
        if (this.summoning) {
            this.summoningPos = bundle.getInt(SUMMONING_POS);
        }
        if (bundle.contains(MY_SKELETON)) {
            this.storedSkeletonID = bundle.getInt(MY_SKELETON);
        }
    }

    public void onZapComplete() {
        if (this.mySkeleton == null || this.mySkeleton.sprite == null || !this.mySkeleton.isAlive()) {
            return;
        }
        if (this.mySkeleton.HP < this.mySkeleton.HT) {
            if (this.sprite.visible || this.mySkeleton.sprite.visible) {
                this.sprite.parent.add((Gizmo)new Beam.HealthRay(this.sprite.center(), this.mySkeleton.sprite.center()));
            }
            this.mySkeleton.HP = Math.min(this.mySkeleton.HP + 5, this.mySkeleton.HT);
            if (this.mySkeleton.sprite.visible) {
                this.mySkeleton.sprite.emitter().burst(Speck.factory(0), 1);
            }
        } else if (this.mySkeleton.buff(Adrenaline.class) == null) {
            if (this.sprite.visible || this.mySkeleton.sprite.visible) {
                this.sprite.parent.add((Gizmo)new Beam.HealthRay(this.sprite.center(), this.mySkeleton.sprite.center()));
            }
            Buff.affect(this.mySkeleton, Adrenaline.class, 3.0f);
        }
        this.next();
    }

    public void summonMinion() {
        if (Actor.findChar(this.summoningPos) != null) {
            int pushPos = this.pos;
            for (int c : PathFinder.NEIGHBOURS8) {
                if (Actor.findChar(this.summoningPos + c) != null || !Dungeon.level.passable[this.summoningPos + c] || !Dungeon.level.openSpace[this.summoningPos + c] && Necromancer.hasProp(Actor.findChar(this.summoningPos), Char.Property.LARGE) || !(Dungeon.level.trueDistance(this.pos, this.summoningPos + c) > Dungeon.level.trueDistance(this.pos, pushPos))) continue;
                pushPos = this.summoningPos + c;
            }
            if (pushPos != this.pos) {
                Char char_ = Actor.findChar(this.summoningPos);
                Actor.addDelayed(new Pushing(char_, char_.pos, pushPos), -1.0f);
                char_.pos = pushPos;
                Dungeon.level.occupyCell(char_);
            } else {
                Char char_ = Actor.findChar(this.summoningPos);
                if (char_.alignment != this.alignment) {
                    char_.damage(Random.NormalIntRange((int)2, (int)10), this);
                }
                this.spend(1.0f);
                return;
            }
        }
        this.firstSummon = false;
        this.summoning = false;
        this.mySkeleton = new NecroSkeleton();
        this.mySkeleton.pos = this.summoningPos;
        GameScene.add(this.mySkeleton);
        Dungeon.level.occupyCell(this.mySkeleton);
        ((NecromancerSprite)this.sprite).finishSummoning();
        for (Buff buff : this.buffs(AllyBuff.class)) {
            Buff.affect(this.mySkeleton, buff.getClass());
        }
        for (Buff buff : this.buffs(ChampionEnemy.class)) {
            Buff.affect(this.mySkeleton, buff.getClass());
        }
    }

    public static class NecroSkeleton
    extends Skeleton {
        public NecroSkeleton() {
            this.state = this.WANDERING;
            this.spriteClass = NecroSkeletonSprite.class;
            this.maxLvl = -5;
            this.HP = 20;
        }

        @Override
        public float spawningWeight() {
            return 0.0f;
        }

        private void teleportSpend() {
            this.spend(1.0f);
        }

        public static class NecroSkeletonSprite
        extends SkeletonSprite {
            public NecroSkeletonSprite() {
                this.brightness(0.75f);
            }

            @Override
            public void resetColor() {
                super.resetColor();
                this.brightness(0.75f);
            }
        }
    }

    private class Hunting
    extends Mob.Hunting {
        private Hunting() {
        }

        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            Necromancer.this.enemySeen = enemyInFOV;
            if (Necromancer.this.storedSkeletonID != -1) {
                Actor ch = Actor.findById(Necromancer.this.storedSkeletonID);
                Necromancer.this.storedSkeletonID = -1;
                if (ch instanceof NecroSkeleton) {
                    Necromancer.this.mySkeleton = (NecroSkeleton)ch;
                }
            }
            if (Necromancer.this.summoning) {
                Necromancer.this.summonMinion();
                return true;
            }
            if (!(Necromancer.this.mySkeleton == null || Necromancer.this.mySkeleton.isAlive() && Dungeon.level.mobs.contains(Necromancer.this.mySkeleton) && ((Necromancer)Necromancer.this).mySkeleton.alignment == Necromancer.this.alignment)) {
                Necromancer.this.mySkeleton = null;
            }
            if (Necromancer.this.enemySeen && Dungeon.level.distance(Necromancer.this.pos, Necromancer.this.enemy.pos) <= 4 && Necromancer.this.mySkeleton == null) {
                Necromancer.this.summoningPos = -1;
                for (Object c : (Actor)PathFinder.NEIGHBOURS8) {
                    if (Actor.findChar(Necromancer.this.enemy.pos + c) != null || !Dungeon.level.passable[Necromancer.this.enemy.pos + c] || !Necromancer.this.fieldOfView[Necromancer.this.enemy.pos + c] || !(Dungeon.level.trueDistance(Necromancer.this.pos, Necromancer.this.enemy.pos + c) < Dungeon.level.trueDistance(Necromancer.this.pos, Necromancer.this.summoningPos))) continue;
                    Necromancer.this.summoningPos = Necromancer.this.enemy.pos + c;
                }
                if (Necromancer.this.summoningPos != -1) {
                    Necromancer.this.summoning = true;
                    Necromancer.this.sprite.zap(Necromancer.this.summoningPos);
                    Necromancer.this.spend(Necromancer.this.firstSummon ? 1.0f : 2.0f);
                } else {
                    Necromancer.this.spend(1.0f);
                }
                return true;
            }
            if (Necromancer.this.enemySeen && Necromancer.this.mySkeleton != null) {
                Necromancer.this.target = Necromancer.this.enemy.pos;
                Necromancer.this.spend(1.0f);
                if (!Necromancer.this.fieldOfView[((Necromancer)Necromancer.this).mySkeleton.pos]) {
                    if (!Dungeon.level.adjacent(((Necromancer)Necromancer.this).mySkeleton.pos, Necromancer.this.enemy.pos)) {
                        int telePos = -1;
                        for (int c : PathFinder.NEIGHBOURS8) {
                            if (Actor.findChar(Necromancer.this.enemy.pos + c) != null || !Dungeon.level.passable[Necromancer.this.enemy.pos + c] || !Necromancer.this.fieldOfView[Necromancer.this.enemy.pos + c] || !(Dungeon.level.trueDistance(Necromancer.this.pos, Necromancer.this.enemy.pos + c) < Dungeon.level.trueDistance(Necromancer.this.pos, telePos))) continue;
                            telePos = Necromancer.this.enemy.pos + c;
                        }
                        if (telePos != -1) {
                            ScrollOfTeleportation.appear(Necromancer.this.mySkeleton, telePos);
                            Necromancer.this.mySkeleton.teleportSpend();
                            if (Necromancer.this.sprite != null && Necromancer.this.sprite.visible) {
                                Necromancer.this.sprite.zap(telePos);
                                return false;
                            }
                            Necromancer.this.onZapComplete();
                        }
                    }
                    return true;
                }
                if (((Necromancer)Necromancer.this).mySkeleton.HP < ((Necromancer)Necromancer.this).mySkeleton.HT || Necromancer.this.mySkeleton.buff(Adrenaline.class) == null) {
                    if (Necromancer.this.sprite != null && Necromancer.this.sprite.visible) {
                        Necromancer.this.sprite.zap(((Necromancer)Necromancer.this).mySkeleton.pos);
                        return false;
                    }
                    Necromancer.this.onZapComplete();
                }
                return true;
            }
            return super.act(enemyInFOV, justAlerted);
        }
    }
}

