/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.WraithSprite;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Visual;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class Wraith
extends Mob {
    private static final float SPAWN_DELAY = 2.0f;
    private int level;
    private static final String LEVEL = "level";

    public Wraith() {
        this.spriteClass = WraithSprite.class;
        this.HT = 1;
        this.HP = 1;
        this.EXP = 0;
        this.maxLvl = -2;
        this.flying = true;
        this.properties.add(Char.Property.UNDEAD);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(LEVEL, this.level);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.level = bundle.getInt(LEVEL);
        this.adjustStats(this.level);
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange((int)(1 + this.level / 2), (int)(2 + this.level));
    }

    @Override
    public int attackSkill(Char target) {
        return 10 + this.level;
    }

    public void adjustStats(int level) {
        this.level = level;
        this.defenseSkill = this.attackSkill(null) * 5;
        this.enemySeen = true;
    }

    @Override
    public float spawningWeight() {
        return 0.0f;
    }

    @Override
    public boolean reset() {
        this.state = this.WANDERING;
        return true;
    }

    public static void spawnAround(int pos) {
        for (int n : PathFinder.NEIGHBOURS4) {
            Wraith.spawnAt(pos + n);
        }
    }

    public static Wraith spawnAt(int pos) {
        if ((!Dungeon.level.solid[pos] || Dungeon.level.passable[pos]) && Actor.findChar(pos) == null) {
            Wraith w = new Wraith();
            w.adjustStats(Dungeon.depth);
            w.pos = pos;
            w.state = w.HUNTING;
            GameScene.add(w, 2.0f);
            Dungeon.level.occupyCell(w);
            w.sprite.alpha(0.0f);
            w.sprite.parent.add((Gizmo)new AlphaTweener((Visual)w.sprite, 1.0f, 0.5f));
            w.sprite.emitter().burst(ShadowParticle.CURSE, 5);
            return w;
        }
        return null;
    }
}

