/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.effects;

import com.watabou.glwrap.Blending;
import com.watabou.glwrap.Texture;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.ColorMath;
import com.watabou.utils.Random;
import com.watabou.utils.RectF;

public class Fireball
extends Component {
    private static final RectF BLIGHT = new RectF(0.0f, 0.0f, 0.25f, 1.0f);
    private static final RectF FLIGHT = new RectF(0.25f, 0.0f, 0.5f, 1.0f);
    private static final RectF FLAME1 = new RectF(0.5f, 0.0f, 0.75f, 1.0f);
    private static final RectF FLAME2 = new RectF(0.75f, 0.0f, 1.0f, 1.0f);
    private static final int COLOR = 0xFF66FF;
    private Image bLight;
    private Image fLight;
    private Emitter emitter;
    private Group sparks;

    protected void createChildren() {
        this.sparks = new Group();
        this.add((Gizmo)this.sparks);
        this.bLight = new Image((Object)"effects/fireball.png");
        this.bLight.frame(BLIGHT);
        this.bLight.origin.set(this.bLight.width / 2.0f);
        this.bLight.angularSpeed = -90.0f;
        this.add((Gizmo)this.bLight);
        this.emitter = new Emitter();
        this.emitter.pour(new Emitter.Factory(){

            public void emit(Emitter emitter, int index, float x, float y) {
                Flame p = (Flame)emitter.recycle(Flame.class);
                p.reset();
                p.heightLimit(Fireball.this.y - 30.0f);
                p.x = x - p.width / 2.0f;
                p.y = y - p.height / 2.0f;
            }
        }, 0.1f);
        this.add((Gizmo)this.emitter);
        this.fLight = new Image((Object)"effects/fireball.png");
        this.fLight.frame(FLIGHT);
        this.fLight.origin.set(this.fLight.width / 2.0f);
        this.fLight.angularSpeed = 360.0f;
        this.add((Gizmo)this.fLight);
        this.bLight.texture.filter(Texture.LINEAR, Texture.LINEAR);
    }

    protected void layout() {
        this.bLight.x = this.x - this.bLight.width / 2.0f;
        this.bLight.y = this.y - this.bLight.height / 2.0f;
        this.emitter.pos(this.x - this.bLight.width / 4.0f, this.y - this.bLight.height / 4.0f, this.bLight.width / 2.0f, this.bLight.height / 2.0f);
        this.fLight.x = this.x - this.fLight.width / 2.0f;
        this.fLight.y = this.y - this.fLight.height / 2.0f;
    }

    public void update() {
        super.update();
        if (Random.Float() < Game.elapsed) {
            PixelParticle spark = (PixelParticle)this.sparks.recycle(PixelParticle.Shrinking.class);
            spark.reset(this.x, this.y, ColorMath.random((int)0xFF66FF, (int)0x66FF66), 2.0f, Random.Float((float)0.5f, (float)1.0f));
            spark.speed.set(Random.Float((float)-40.0f, (float)40.0f), Random.Float((float)-60.0f, (float)20.0f));
            spark.acc.set(0.0f, 80.0f);
            this.sparks.add((Gizmo)spark);
        }
    }

    public void draw() {
        Blending.setLightMode();
        super.draw();
        Blending.setNormalMode();
    }

    public static class Flame
    extends Image {
        private static float LIFESPAN = 1.0f;
        private static float SPEED = -40.0f;
        private static float ACC = -20.0f;
        private float timeLeft;
        private float heightLimit;

        public Flame() {
            super((Object)"effects/fireball.png");
            this.frame(Random.Int((int)2) == 0 ? FLAME1 : FLAME2);
            this.origin.set(this.width / 2.0f, this.height / 2.0f);
            this.acc.set(0.0f, ACC);
        }

        public void reset() {
            this.revive();
            this.timeLeft = LIFESPAN;
            this.speed.set(0.0f, SPEED);
        }

        public void heightLimit(float limit) {
            this.heightLimit = limit;
        }

        public void update() {
            float f;
            super.update();
            if (this.y < this.heightLimit) {
                this.y = this.heightLimit;
                this.speed.set(Random.Float((float)-20.0f, (float)20.0f), 0.0f);
                this.acc.set(0.0f, 0.0f);
            }
            this.timeLeft -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.timeLeft / LIFESPAN;
                this.scale.set(p);
                this.alpha(p > 0.8f ? (1.0f - p) * 5.0f : p * 1.25f);
            }
        }
    }
}

