/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.effects;

import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.RenderedText;
import com.watabou.utils.Callback;
import com.watabou.utils.SparseArray;
import java.util.ArrayList;

public class FloatingText
extends RenderedTextBlock {
    private static final float LIFESPAN = 1.0f;
    private static final float DISTANCE = 16.0f;
    private float timeLeft;
    private int key = -1;
    private static final SparseArray<ArrayList<FloatingText>> stacks = new SparseArray();

    public FloatingText() {
        super(9 * PixelScene.defaultZoom);
        this.setHightlighting(false);
    }

    public void update() {
        super.update();
        if (this.timeLeft > 0.0f) {
            float f;
            this.timeLeft -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.timeLeft / 1.0f;
                this.alpha(p > 0.5f ? 1.0f : p * 2.0f);
                float yMove = 16.0f * Game.elapsed;
                this.y -= yMove;
                for (RenderedText t : this.words) {
                    t.y -= yMove;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        if (this.key != -1) {
            SparseArray<ArrayList<FloatingText>> sparseArray = stacks;
            synchronized (sparseArray) {
                ((ArrayList)stacks.get(this.key)).remove((Object)this);
            }
            this.key = -1;
        }
        super.kill();
    }

    public void destroy() {
        this.kill();
        super.destroy();
    }

    public void reset(float x, float y, String text, int color) {
        this.revive();
        this.zoom(1.0f / (float)PixelScene.defaultZoom);
        this.text(text);
        this.hardlight(color);
        this.setPos(PixelScene.align(Camera.main, x - this.width() / 2.0f), PixelScene.align(Camera.main, y - this.height()));
        this.timeLeft = 1.0f;
    }

    public static void show(final float x, final float y, final String text, final int color) {
        Game.runOnRenderThread((Callback)new Callback(){

            public void call() {
                FloatingText txt = GameScene.status();
                if (txt != null) {
                    txt.reset(x, y, text, color);
                }
            }
        });
    }

    public static void show(final float x, final float y, final int key, final String text, final int color) {
        Game.runOnRenderThread((Callback)new Callback(){

            public void call() {
                FloatingText txt = GameScene.status();
                if (txt != null) {
                    txt.reset(x, y, text, color);
                    FloatingText.push(txt, key);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void push(FloatingText txt, int key) {
        SparseArray<ArrayList<FloatingText>> sparseArray = stacks;
        synchronized (sparseArray) {
            txt.key = key;
            ArrayList<FloatingText> stack = (ArrayList<FloatingText>)stacks.get(key);
            if (stack == null) {
                stack = new ArrayList<FloatingText>();
                stacks.put(key, stack);
            }
            if (stack.size() > 0) {
                FloatingText above;
                FloatingText below = txt;
                for (int aboveIndex = stack.size() - 1; aboveIndex >= 0 && (above = (FloatingText)((Object)stack.get(aboveIndex))).bottom() + 4.0f > below.top(); --aboveIndex) {
                    above.setPos(above.left(), below.top() - above.height() - 4.0f);
                    below = above;
                }
            }
            stack.add(txt);
        }
    }
}

