/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.armor;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.LockedFloor;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.abilities.ArmorAbility;
import com.shatteredpixel.shatteredpixeldungeon.items.BrokenSeal;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClothArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.HuntressArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.LeatherArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.MageArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.MailArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.PlateArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.RogueArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ScaleArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.WarriorArmor;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndChooseAbility;
import com.watabou.utils.Bundle;
import java.text.DecimalFormat;
import java.util.ArrayList;

public abstract class ClassArmor
extends Armor {
    private static final String AC_ABILITY = "ABILITY";
    private int armorTier;
    private Charger charger;
    public float charge;
    private static final String ARMOR_TIER = "armortier";
    private static final String CHARGE = "charge";

    public ClassArmor() {
        super(5);
        this.levelKnown = true;
        this.cursedKnown = true;
        this.defaultAction = AC_ABILITY;
        this.bones = false;
        this.charge = 0.0f;
    }

    @Override
    public void activate(Char ch) {
        super.activate(ch);
        this.charger = new Charger();
        this.charger.attachTo(ch);
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            if (this.charger != null) {
                this.charger.detach();
                this.charger = null;
            }
            return true;
        }
        return false;
    }

    public static ClassArmor upgrade(Hero owner, Armor armor) {
        ClassArmor classArmor = null;
        switch (owner.heroClass) {
            case WARRIOR: {
                classArmor = new WarriorArmor();
                BrokenSeal seal = armor.checkSeal();
                if (seal == null) break;
                classArmor.affixSeal(seal);
                break;
            }
            case ROGUE: {
                classArmor = new RogueArmor();
                break;
            }
            case MAGE: {
                classArmor = new MageArmor();
                break;
            }
            case HUNTRESS: {
                classArmor = new HuntressArmor();
            }
        }
        classArmor.level(armor.trueLevel());
        classArmor.tier = armor.tier;
        classArmor.augment = armor.augment;
        classArmor.inscribe(armor.glyph);
        classArmor.cursed = armor.cursed;
        classArmor.curseInfusionBonus = armor.curseInfusionBonus;
        classArmor.masteryPotionBonus = armor.masteryPotionBonus;
        classArmor.identify();
        classArmor.charge = 50.0f;
        return classArmor;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ARMOR_TIER, this.tier);
        bundle.put(CHARGE, this.charge);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.tier = bundle.getInt(ARMOR_TIER);
        this.charge = bundle.getFloat(CHARGE);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero)) {
            actions.add(AC_ABILITY);
        }
        return actions;
    }

    @Override
    public String actionName(String action, Hero hero) {
        if (hero.armorAbility != null && action.equals(AC_ABILITY)) {
            return hero.armorAbility.name().toUpperCase();
        }
        return super.actionName(action, hero);
    }

    @Override
    public String status() {
        return Messages.format("%.0f%%", Math.floor(this.charge));
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_ABILITY)) {
            if (hero.armorAbility == null) {
                GameScene.show(new WndChooseAbility(null, this, hero));
            } else if (!this.isEquipped(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "not_equipped", new Object[0]), new Object[0]);
            } else if (this.charge < hero.armorAbility.chargeUse(hero)) {
                this.usesTargeting = false;
                GLog.w(Messages.get(this, "low_charge", new Object[0]), new Object[0]);
            } else {
                this.usesTargeting = hero.armorAbility.useTargeting();
                hero.armorAbility.use(this, hero);
            }
        }
    }

    @Override
    public String desc() {
        String desc = super.desc();
        if (Dungeon.hero.belongings.contains(this)) {
            ArmorAbility ability = Dungeon.hero.armorAbility;
            if (ability != null) {
                desc = desc + "\n\n" + ability.shortDesc();
                float chargeUse = ability.chargeUse(Dungeon.hero);
                desc = desc + " " + Messages.get(this, "charge_use", new DecimalFormat("#.##").format(chargeUse));
            } else {
                desc = desc + "\n\n_" + Messages.get(this, "no_ability", new Object[0]) + "_";
            }
        }
        return desc;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int value() {
        return 0;
    }

    @Override
    public String analyticsName() {
        switch (this.tier) {
            case 1: {
                return ClothArmor.class.getSimpleName();
            }
            case 2: {
                return LeatherArmor.class.getSimpleName();
            }
            case 3: {
                return MailArmor.class.getSimpleName();
            }
            case 4: {
                return ScaleArmor.class.getSimpleName();
            }
        }
        return PlateArmor.class.getSimpleName();
    }

    public class Charger
    extends Buff {
        @Override
        public boolean act() {
            LockedFloor lock = this.target.buff(LockedFloor.class);
            if (lock == null || lock.regenOn()) {
                ClassArmor.this.charge += 0.2f;
                Item.updateQuickslot();
                if (ClassArmor.this.charge > 100.0f) {
                    ClassArmor.this.charge = 100.0f;
                }
            }
            this.spend(1.0f);
            return true;
        }
    }
}

