/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.artifacts;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Roots;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.EarthParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.VelvetPouch;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfEnergy;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Earthroot;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.watabou.noosa.Camera;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import java.util.ArrayList;
import java.util.Collections;

public class SandalsOfNature
extends Artifact {
    public static final String AC_FEED = "FEED";
    public static final String AC_ROOT = "ROOT";
    public ArrayList<Class> seeds;
    private static final String SEEDS = "seeds";
    protected WndBag.ItemSelector itemSelector;

    public SandalsOfNature() {
        this.image = ItemSpriteSheet.ARTIFACT_SANDALS;
        this.levelCap = 3;
        this.charge = 0;
        this.defaultAction = AC_ROOT;
        this.seeds = new ArrayList();
        this.itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(SandalsOfNature.class, "prompt", new Object[0]);
            }

            @Override
            public Class<? extends Bag> preferredBag() {
                return VelvetPouch.class;
            }

            @Override
            public boolean itemSelectable(Item item) {
                return SandalsOfNature.this.canUseSeed(item);
            }

            @Override
            public void onSelect(Item item) {
                if (item != null && item instanceof Plant.Seed) {
                    if (SandalsOfNature.this.seeds.contains(item.getClass())) {
                        GLog.w(Messages.get(SandalsOfNature.class, "already_fed", new Object[0]), new Object[0]);
                    } else {
                        SandalsOfNature.this.seeds.add(item.getClass());
                        Hero hero = Dungeon.hero;
                        hero.sprite.operate(hero.pos);
                        Sample.INSTANCE.play((Object)"sounds/plant.mp3");
                        hero.busy();
                        hero.spend(2.0f);
                        if (SandalsOfNature.this.seeds.size() >= 3 + SandalsOfNature.this.level() * 3) {
                            SandalsOfNature.this.seeds.clear();
                            SandalsOfNature.this.upgrade();
                            Dungeon.hero.trackUpgrade(SandalsOfNature.this, SandalsOfNature.this.level() == 3 ? 4 : 3);
                            if (SandalsOfNature.this.level() >= 1 && SandalsOfNature.this.level() <= 3) {
                                GLog.p(Messages.get(SandalsOfNature.class, "levelup", new Object[0]), new Object[0]);
                            }
                        } else {
                            GLog.i(Messages.get(SandalsOfNature.class, "absorb_seed", new Object[0]), new Object[0]);
                        }
                        item.detach(hero.belongings.backpack);
                    }
                }
            }
        };
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        if (this.isEquipped(hero) && this.level() < 3 && !this.cursed) {
            actions.add(AC_FEED);
        }
        if (this.isEquipped(hero) && this.charge > 0) {
            actions.add(AC_ROOT);
        }
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_FEED)) {
            GameScene.selectItem(this.itemSelector);
        } else if (action.equals(AC_ROOT) && this.level() > 0) {
            if (!this.isEquipped(hero)) {
                GLog.i(Messages.get(Artifact.class, "need_to_equip", new Object[0]), new Object[0]);
            } else if (this.charge == 0) {
                GLog.i(Messages.get(this, "no_charge", new Object[0]), new Object[0]);
            } else {
                Buff.prolong(hero, Roots.class, 5.0f);
                Buff.affect(hero, Earthroot.Armor.class).level(this.charge);
                CellEmitter.bottom(hero.pos).start(EarthParticle.FACTORY, 0.05f, 8);
                Camera.main.shake(1.0f, 0.4f);
                this.charge = 0;
                Talent.onArtifactUsed(Dungeon.hero);
                SandalsOfNature.updateQuickslot();
            }
        }
    }

    @Override
    protected Artifact.ArtifactBuff passiveBuff() {
        return new Naturalism();
    }

    @Override
    public void charge(Hero target, float amount) {
        target.buff(Naturalism.class).charge(amount);
    }

    @Override
    public String name() {
        if (!this.customName.equals("") || this.level() == 0) {
            return super.name();
        }
        return Messages.get(this, "name_" + this.level(), new Object[0]);
    }

    @Override
    public String desc() {
        String desc = Messages.get(this, "desc_" + (this.level() + 1), new Object[0]);
        if (this.isEquipped(Dungeon.hero)) {
            desc = desc + "\n\n";
            desc = !this.cursed ? desc + Messages.get(this, "desc_hint", new Object[0]) : desc + Messages.get(this, "desc_cursed", new Object[0]);
            if (this.level() > 0) {
                desc = desc + "\n\n" + Messages.get(this, "desc_ability", new Object[0]);
            }
        }
        if (!this.seeds.isEmpty()) {
            desc = desc + "\n\n" + Messages.get(this, "desc_seeds", this.seeds.size());
        }
        return desc;
    }

    @Override
    public Item upgrade() {
        if (this.level() < 0) {
            this.image = ItemSpriteSheet.ARTIFACT_SANDALS;
        } else if (this.level() == 0) {
            this.image = ItemSpriteSheet.ARTIFACT_SHOES;
        } else if (this.level() == 1) {
            this.image = ItemSpriteSheet.ARTIFACT_BOOTS;
        } else if (this.level() >= 2) {
            this.image = ItemSpriteSheet.ARTIFACT_GREAVES;
        }
        return super.upgrade();
    }

    public boolean canUseSeed(Item item) {
        return item instanceof Plant.Seed && !this.seeds.contains(item.getClass());
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(SEEDS, this.seeds.toArray(new Class[this.seeds.size()]));
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        if (bundle.contains(SEEDS)) {
            Collections.addAll(this.seeds, bundle.getClassArray(SEEDS));
        }
        if (this.level() == 1) {
            this.image = ItemSpriteSheet.ARTIFACT_SHOES;
        } else if (this.level() == 2) {
            this.image = ItemSpriteSheet.ARTIFACT_BOOTS;
        } else if (this.level() >= 3) {
            this.image = ItemSpriteSheet.ARTIFACT_GREAVES;
        }
    }

    public class Naturalism
    extends Artifact.ArtifactBuff {
        public void charge(float amount) {
            if (SandalsOfNature.this.level() > 0 && SandalsOfNature.this.charge < this.target.HT) {
                float chargeGain = (float)(this.target.HT - SandalsOfNature.this.charge) * (0.01f + (float)SandalsOfNature.this.level() * 0.01f);
                chargeGain *= amount;
                SandalsOfNature.this.partialCharge += Math.max(0.0f, chargeGain *= RingOfEnergy.artifactChargeMultiplier(this.target));
                while (SandalsOfNature.this.partialCharge > 1.0f) {
                    ++SandalsOfNature.this.charge;
                    SandalsOfNature.this.partialCharge -= 1.0f;
                }
                Item.updateQuickslot();
            }
        }
    }
}

