/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.bombs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bombs.Bomb;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;

public class Noisemaker
extends Bomb {
    public Noisemaker() {
        this.image = ItemSpriteSheet.NOISEMAKER;
    }

    public void setTrigger(int cell) {
        Buff.affect(Dungeon.hero, Trigger.class).set(cell);
        CellEmitter.center(cell).start(Speck.factory(5), 0.3f, 3);
        Sample.INSTANCE.play((Object)"sounds/alert.mp3");
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            mob.beckon(cell);
        }
    }

    @Override
    public int value() {
        return this.quantity * 60;
    }

    public static class Trigger
    extends Buff {
        int cell;
        int floor;
        int left;
        private static final String CELL = "cell";
        private static final String FLOOR = "floor";
        private static final String LEFT = "left";

        public Trigger() {
            this.revivePersists = true;
        }

        public void set(int cell) {
            this.floor = Dungeon.depth;
            this.cell = cell;
            this.left = 6;
        }

        @Override
        public boolean act() {
            if (Dungeon.depth != this.floor) {
                this.spend(1.0f);
                return true;
            }
            Noisemaker bomb = null;
            Heap heap = (Heap)Dungeon.level.heaps.get(this.cell);
            if (heap != null) {
                for (Item i : heap.items) {
                    if (!(i instanceof Noisemaker)) continue;
                    bomb = (Noisemaker)i;
                    break;
                }
            }
            if (bomb == null) {
                this.detach();
            } else if (Actor.findChar(this.cell) != null) {
                heap.items.remove(bomb);
                if (heap.items.isEmpty()) {
                    heap.destroy();
                }
                this.detach();
                bomb.explode(this.cell);
            } else {
                this.spend(1.0f);
                --this.left;
                if (this.left <= 0) {
                    CellEmitter.center(this.cell).start(Speck.factory(5), 0.3f, 3);
                    Sample.INSTANCE.play((Object)"sounds/alert.mp3");
                    for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
                        mob.beckon(this.cell);
                    }
                    this.left = 6;
                }
            }
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(CELL, this.cell);
            bundle.put(FLOOR, this.floor);
            bundle.put(LEFT, this.left);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.cell = bundle.getInt(CELL);
            this.floor = bundle.getInt(FLOOR);
            this.left = bundle.getInt(LEFT);
        }
    }
}

