/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.potions;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfExperience;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfFrost;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHaste;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfInvisibility;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLevitation;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLiquidFlame;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfMindVision;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfParalyticGas;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfPurity;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfToxicGas;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.exotic.ExoticPotion;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.Runestone;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.util.ArrayList;
import java.util.HashMap;

public class AlchemicalCatalyst
extends Potion {
    private static HashMap<Class<? extends Potion>, Float> potionChances = new HashMap();

    public AlchemicalCatalyst() {
        this.image = ItemSpriteSheet.POTION_CATALYST;
    }

    @Override
    public void apply(Hero hero) {
        Potion p = (Potion)Reflection.newInstance((Class)((Class)Random.chances(potionChances)));
        while (Dungeon.isChallenged(4) && p instanceof PotionOfHealing) {
            p = (Potion)Reflection.newInstance((Class)((Class)Random.chances(potionChances)));
        }
        p.anonymize();
        p.apply(hero);
    }

    @Override
    public void shatter(int cell) {
        Potion p = (Potion)Reflection.newInstance((Class)((Class)Random.chances(potionChances)));
        p.anonymize();
        curItem = p;
        p.shatter(cell);
    }

    @Override
    public boolean isKnown() {
        return true;
    }

    @Override
    public int value() {
        return 40 * this.quantity;
    }

    @Override
    public int energyVal() {
        return 8 * this.quantity;
    }

    static {
        potionChances.put(PotionOfHealing.class, Float.valueOf(3.0f));
        potionChances.put(PotionOfMindVision.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfFrost.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfLiquidFlame.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfToxicGas.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfHaste.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfInvisibility.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfLevitation.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfParalyticGas.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfPurity.class, Float.valueOf(2.0f));
        potionChances.put(PotionOfExperience.class, Float.valueOf(1.0f));
    }

    public static class Recipe
    extends com.shatteredpixel.shatteredpixeldungeon.items.Recipe {
        @Override
        public boolean testIngredients(ArrayList<Item> ingredients) {
            boolean potion = false;
            boolean secondary = false;
            for (Item i : ingredients) {
                if (i instanceof Plant.Seed || i instanceof Runestone) {
                    secondary = true;
                    continue;
                }
                if (!ExoticPotion.regToExo.containsKey(i.getClass()) && !ExoticPotion.regToExo.containsValue(i.getClass())) continue;
                potion = true;
            }
            return potion && secondary;
        }

        @Override
        public int cost(ArrayList<Item> ingredients) {
            for (Item i : ingredients) {
                if (i instanceof Plant.Seed) {
                    return 0;
                }
                if (!(i instanceof Runestone)) continue;
                return 1;
            }
            return 0;
        }

        @Override
        public Item brew(ArrayList<Item> ingredients) {
            for (Item i : ingredients) {
                i.quantity(i.quantity() - 1);
            }
            return this.sampleOutput(null);
        }

        @Override
        public Item sampleOutput(ArrayList<Item> ingredients) {
            return new AlchemicalCatalyst();
        }
    }
}

