/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Elemental;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ElmoParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class CeremonialCandle
extends Item {
    public static int ritualPos;

    public CeremonialCandle() {
        this.image = ItemSpriteSheet.CANDLE;
        this.defaultAction = "THROW";
        this.unique = true;
        this.stackable = true;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public void doDrop(Hero hero) {
        super.doDrop(hero);
        CeremonialCandle.checkCandles();
    }

    @Override
    protected void onThrow(int cell) {
        super.onThrow(cell);
        CeremonialCandle.checkCandles();
    }

    private static void checkCandles() {
        Heap heapTop = (Heap)Dungeon.level.heaps.get(ritualPos - Dungeon.level.width());
        Heap heapRight = (Heap)Dungeon.level.heaps.get(ritualPos + 1);
        Heap heapBottom = (Heap)Dungeon.level.heaps.get(ritualPos + Dungeon.level.width());
        Heap heapLeft = (Heap)Dungeon.level.heaps.get(ritualPos - 1);
        if (heapTop != null && heapRight != null && heapBottom != null && heapLeft != null && heapTop.peek() instanceof CeremonialCandle && heapRight.peek() instanceof CeremonialCandle && heapBottom.peek() instanceof CeremonialCandle && heapLeft.peek() instanceof CeremonialCandle) {
            heapTop.pickUp();
            heapRight.pickUp();
            heapBottom.pickUp();
            heapLeft.pickUp();
            Elemental.NewbornFireElemental elemental = new Elemental.NewbornFireElemental();
            Char ch = Actor.findChar(ritualPos);
            if (ch != null) {
                ArrayList<Integer> candidates = new ArrayList<Integer>();
                int[] nArray = PathFinder.NEIGHBOURS8;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray[i];
                    int cell = ritualPos + n2;
                    if (!Dungeon.level.passable[cell] && !Dungeon.level.avoid[cell] || Actor.findChar(cell) != null) continue;
                    candidates.add(cell);
                }
                elemental.pos = candidates.size() > 0 ? (Integer)Random.element(candidates) : ritualPos;
            } else {
                elemental.pos = ritualPos;
            }
            elemental.state = elemental.HUNTING;
            GameScene.add(elemental, 1.0f);
            for (int i : PathFinder.NEIGHBOURS9) {
                CellEmitter.get(ritualPos + i).burst(ElmoParticle.FACTORY, 10);
            }
            Sample.INSTANCE.play((Object)"sounds/burning.mp3");
        }
    }
}

